<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        $table_exist = Schema::connection('mysql_common')->hasTable('rvw_release_notes');
        if (!$table_exist) {
            Schema::connection('mysql_common')->create('rvw_release_notes', function (Blueprint $table) {
                $table->id('note_id');
                $table->bigInteger('note_release_version_id', false, true)->comment('pk of rvw_version');
                $table->string('note_title', 1000);
                $table->string('note_description', 250);
                $table->integer('note_category', false, true)->comment('pk of rvw_release_category');
                $table->unsignedBigInteger('note_posted_by');
                $table->dateTime('note_posted_date');
                $table->unsignedBigInteger('note_proxy_id')->nullable();
                $table->char('note_operation', 1);
            });
        }
    }
    

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('rvw_release_notes');
    }
};
