<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasColumn('rvw_email_send_log', 'esl_rpid')) {
            DB::statement("ALTER TABLE `rvw_email_send_log` ADD `esl_rpid` BIGINT UNSIGNED DEFAULT NULL COMMENT 'To save parent id of replied mails for tracking parent mails' AFTER `esl_read_status`");
        }
        if (!Schema::hasColumn('tbk_email_send_log', 'esl_rpid')) {
            DB::statement("ALTER TABLE `tbk_email_send_log` ADD `esl_rpid` BIGINT UNSIGNED DEFAULT NULL COMMENT 'To save parent id of replied mails for tracking parent mails' AFTER `esl_read_status`");
        }
        if (!Schema::hasColumn('rvw_email_send_log', 'esl_response')) {
            DB::statement("ALTER TABLE `rvw_email_send_log` ADD `esl_response` datetime DEFAULT NULL COMMENT 'To save reply mail received time from mail box' AFTER `esl_trans_secret_id`");
        }
        if (!Schema::hasColumn('tbk_email_send_log', 'esl_response')) {
            DB::statement("ALTER TABLE `tbk_email_send_log` ADD `esl_response` datetime DEFAULT NULL COMMENT 'To save reply mail received time from mail box' AFTER `esl_trans_secret_id`");
        }
        if (!Schema::hasColumn('rvw_email_send_log', 'esl_rply_source')) {
            DB::statement("ALTER TABLE `rvw_email_send_log` ADD `esl_rply_source` CHAR(1) NULL DEFAULT NULL  COMMENT 'e = External source,s= From system' AFTER `esl_response`");
        }
        if (!Schema::hasColumn('tbk_email_send_log', 'esl_rply_source')) {
            DB::statement("ALTER TABLE `tbk_email_send_log` ADD `esl_rply_source`  CHAR(1) NULL DEFAULT NULL COMMENT 'e = External source,s= From system' AFTER `esl_response`");
        }

        $this->updateParentIds();
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        DB::statement("ALTER TABLE `rvw_email_send_log` DROP `esl_rpid`,DROP `esl_response`,DROP `esl_rply_source`");
        DB::statement("ALTER TABLE `tbk_email_send_log` DROP `esl_rpid`,DROP `esl_response`,DROP `esl_rply_source`");
    }

    private function updateParentIds()
    {
        $sentEmails = DB::table('rvw_email_send_log')->where('esl_trans_mode', 'r')->get();

        if (isset($sentEmails) && !empty($sentEmails)) {
            foreach ($sentEmails as $sentEmail) {
                $parent_mail_data = DB::table('rvw_email_send_log')
                    ->where('esl_trans_secret_id', $sentEmail->esl_trans_secret_id)
                    ->orderBy('esl_id', 'asc')
                    ->get();

                // update reply mail response time , reply parent id , reply mail source fields
                DB::table('rvw_email_send_log')
                    ->where('esl_id', '=', $sentEmail->esl_id)
                    ->where('esl_response', null)
                    ->update([
                        'esl_response' => $sentEmail->esl_posted_date,
                        'esl_rpid' => $parent_mail_data[0]->esl_id,
                        'esl_rply_source' => 'e',
                        'esl_operation' => 'm'
                    ]);
            }
        }
    }
};
