<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        DB::statement("CREATE TABLE IF NOT EXISTS `tbk_research_integrity_reports` (
            `rri_id` bigint UNSIGNED NOT NULL,
            `rri_art_id` bigint UNSIGNED NOT NULL COMMENT 'art id',
            `rri_report` text COMMENT 'report link',
            `rri_posted_by` bigint UNSIGNED NOT NULL,
            `rri_posted_date` datetime NOT NULL,
            `rri_proxy_id` bigint DEFAULT NULL,
            `rri_operation` char(1) NOT NULL DEFAULT 'u' COMMENT 'u-update,i-insert',
            `tbk_id` int UNSIGNED NOT NULL PRIMARY KEY AUTO_INCREMENT
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;");

        DB::unprepared("drop trigger if exists trg_research_integrity_reports_after_insert; CREATE TRIGGER trg_research_integrity_reports_after_insert  AFTER INSERT ON rvw_research_integrity_reports FOR EACH ROW INSERT INTO tbk_research_integrity_reports SELECT *,NULL tbk_id FROM rvw_research_integrity_reports WHERE rri_id= NEW.rri_id;");
        DB::unprepared("drop trigger if exists trg_research_integrity_reports_after_update; CREATE TRIGGER trg_research_integrity_reports_after_update  AFTER UPDATE ON rvw_research_integrity_reports FOR EACH ROW INSERT INTO tbk_research_integrity_reports SELECT *,NULL tbk_id FROM rvw_research_integrity_reports WHERE rri_id= OLD.rri_id;");
        

        if (!Schema::hasColumn('rvw_research_integrity_reports', 'rri_status')) {
            DB::statement("ALTER TABLE `rvw_research_integrity_reports` ADD `rri_status` CHAR(1) NULL DEFAULT NULL COMMENT 'n - not generated; y - generated' AFTER `rri_report`;");
        }
        if (!Schema::hasColumn('tbk_research_integrity_reports', 'rri_status')) {
            DB::statement("ALTER TABLE `tbk_research_integrity_reports` ADD `rri_status` CHAR(1) NULL DEFAULT NULL COMMENT 'n - not generated; y - generated' AFTER `rri_report`;");
        }
        if (!Schema::hasColumn('rvw_research_integrity_reports', 'rri_new_report')) {
            DB::statement("ALTER TABLE `rvw_research_integrity_reports` ADD `rri_new_report` CHAR(1) NULL DEFAULT NULL COMMENT 'n - old report; y - new report' AFTER `rri_status`;");
        }
        if (!Schema::hasColumn('tbk_research_integrity_reports', 'rri_new_report')) {
            DB::statement("ALTER TABLE `tbk_research_integrity_reports` ADD `rri_new_report` CHAR(1) NULL DEFAULT NULL COMMENT 'n - old report; y - new report' AFTER `rri_status`;");
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        DB::statement("ALTER TABLE `rvw_research_integrity_reports` DROP `rri_status`");
        DB::statement("ALTER TABLE `tbk_research_integrity_reports` DROP `rri_status`");
        DB::statement("ALTER TABLE `rvw_research_integrity_reports` DROP `rri_new_report`");
        DB::statement("ALTER TABLE `tbk_research_integrity_reports` DROP `rri_new_report`");
    }
};
