<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::table('rvw_email_send_log', function (Blueprint $table) {
            $table->string('esl_etmp_action', 100)
                  ->nullable()
                  ->comment('for which case (eg: complete, assigned) email triggered')
                  ->change();
        });
    }

    public function down()
    {
        Schema::table('rvw_email_send_log', function (Blueprint $table) {
            // Adjust based on original column definition
            $table->string('esl_etmp_action', 25)->nullable(false)->change();
        });
    }
};
