<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        try {
            DB::statement("CREATE TABLE `rvw_article_order_log` (`ord_id` BIGINT NOT NULL AUTO_INCREMENT, `src_art_id` BIGINT UNSIGNED NOT NULL, `des_art_id` BIGINT UNSIGNED NOT NULL, `ord_position` CHAR(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT 'b' COMMENT 'b=before,a=after',`ord_posted_by` BIGINT NULL , `ord_posted_date` DATETIME NULL ,`ord_proxy_id` BIGINT NOT NULL, `ord_operation` CHAR(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT 'u' COMMENT ' u-update,i-insert ' , PRIMARY KEY (`ord_id`))  ENGINE = InnoDB; ");
            DB::statement("ALTER TABLE `rvw_article_order_log` ADD INDEX(`src_art_id`);");
            DB::statement("ALTER TABLE `rvw_article_order_log` ADD INDEX(`des_art_id`);");
        } catch (\Exception $e) {
                 DB::rollback();
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
         //
    }
};
