<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('rvw_copyright_request')) {
            Schema::create('rvw_copyright_request', function (Blueprint $table) {
                $table->bigIncrements('crr_id');
                $table->unsignedBigInteger('crr_art_id');
                $table->unsignedBigInteger('crr_request_to')->comment('Who receive the copyright change request?');
                $table->unsignedBigInteger('crr_request_from')->comment('Who sent the copyright change request?');
                $table->char('crr_request_status', 1)->default('n')->comment('r-request send, c-completed request');
                $table->unsignedBigInteger('crr_posted_by');
                $table->datetime('crr_posted_date');
                $table->bigInteger('crr_proxy_id');
                $table->char('crr_operation', 1)->default('u')->comment('u-update, i-insert');
            });
        }

        Schema::table('rvw_articles', function (Blueprint $table) {
            $table->char('art_copyright_request', 1)
                  ->default('n')
                  ->comment('y-request to author c-author completed n-default')
                  ->after('art_final_decision_date');
        });

        Schema::table('tbk_articles', function (Blueprint $table) {
            $table->char('art_copyright_request', 1)
                  ->default('n')
                  ->comment('y-request to author c-author completed n-default')
                  ->after('art_final_decision_date');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('rvw_copyright_request');
        Schema::table('rvw_articles', function (Blueprint $table) {
            $table->dropColumn('art_copyright_request');
        });

        Schema::table('tbk_articles', function (Blueprint $table) {
            $table->dropColumn('art_copyright_request');
        });
    }
};
