<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Add jnl_supporting_forms to journal tables
        if (!Schema::hasColumn('rvw_journals', 'jnl_supporting_forms')) {
            Schema::table('rvw_journals', function (Blueprint $table) {
                $table->string('jnl_supporting_forms', 250)->nullable()->comment('Supporing data forms.')->default('[]')->after('jnl_metadata_id');
            });
        }
        if (!Schema::hasColumn('tbk_journals', 'jnl_supporting_forms')) {
            Schema::table('tbk_journals', function (Blueprint $table) {
                $table->string('jnl_supporting_forms', 250)->nullable()->comment('Supporing data forms.')->default('[]')->after('jnl_metadata_id');
            });
        }

        // Add jset_showsupportingdata to journal settings tables
        if (!Schema::hasColumn('rvw_journal_settings', 'jset_showsupportingdata')) {
            Schema::table('rvw_journal_settings', function (Blueprint $table) {
                $table->mediumText('jset_showsupportingdata')->nullable()->comment('Permission to view supporing data forms.')->after('jset_conf_duedate');
            });
        }
        if (!Schema::hasColumn('tbk_journal_settings', 'jset_showsupportingdata')) {
            Schema::table('tbk_journal_settings', function (Blueprint $table) {
                $table->mediumText('jset_showsupportingdata')->nullable()->comment('Permission to view supporing data forms.')->after('jset_conf_duedate');
            });
        }

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
        if (!Schema::hasColumn('rvw_journals', 'jnl_supporting_forms')) {
            Schema::table('rvw_journals', function (Blueprint $table) {
                $table->dropColumn('jnl_supporting_forms');
            });
        }
        if (!Schema::hasColumn('tbk_journals', 'jnl_supporting_forms')) {
            Schema::table('tbk_journals', function (Blueprint $table) {
                $table->dropColumn('jnl_supporting_forms');
            });
        }
        if (!Schema::hasColumn('rvw_journal_settings', 'jset_showsupportingdata')) {
            Schema::table('rvw_journal_settings', function (Blueprint $table) {
                $table->dropColumn('jset_showsupportingdata');
            });
        }
        if (!Schema::hasColumn('tbk_journal_settings', 'jset_showsupportingdata')) {
            Schema::table('tbk_journal_settings', function (Blueprint $table) {
                $table->dropColumn('jset_showsupportingdata');
            });
        }
    }
};
