<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Clients;
use App\Models\Client_settings;
use App\Models\Modules;
use App\Models\Generic_forms;
use App\Models\Generic_form_groups;
use App\Models\Generic_form_elements;
use DB;

class ClientSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $client_data    =   [
            "clnt_client_name" => "RVT",
            "clnt_client_code" => "default",
            "clnt_created_date" => date('Y-m-d h:i:s'),
            "clnt_review_terms" => "test",
            "clnt_posted_date" => date('Y-m-d h:i:s'),
        ];
        $id = Clients::insertGetId($client_data);

        $clnt_settings = [
            "cs_client_id" => $id,
            "cs_min_keyword" => 2,
            "cs_max_keyword" => 10,
            "cs_date_format" => 'd-m-y',
            "cs_posted_date" => date('Y-m-d h:i:s'),
            "cs_posted_by" => 2,
            "cs_proxy_id" => 0,
        ];
        Client_settings::insert($clnt_settings);

        $module_data = [
            "mdl_clnt_id" => $id,
            "mdl_journal" => 'y',
            "mdl_book" => 'n',
            "mdl_conference" => 'n',
            "mdl_orcid" => 'n',
            "mdl_review_for_doc" => 'n',
            "mdl_ringgold"=> 'n',
            "mdl_ror" => 'n',
            "mdl_rightslink" => 'n',
            "mdl_publons" => 'n',
            "mdl_dryad" => 'n',
            "mdl_word_to_pdf" => 'n',
            "mdl_ithenticate" => 'n',
            "mdl_production" => 'n',
            "mdl_research_integrity" => 'n',
            "mdl_posted_date" => date('Y-m-d h:i:s'),
            "mdl_posted_by" => 0
        ];
        Modules::insert($module_data);

        // $custom_email_template_tags = "INSERT INTO `rvw_custom_email_template_tags` (`cettag_id`, `cettag_name`, `cettag_value`, `cettag_posted_date`, `cettag_posted_by`, `cettag_proxy_id`, `cettag_operation`) VALUES
        // (1, 'TAG_DISCLAIMER', 'Phone: +1 (123) 456-7890', '2020-07-17 13:08:19', 1, 0, 'i'),
        // (2, 'ICE_PUBLISHING_SIGNATURE', 'Phone: +1 (123) 456-7890', '2021-03-23 12:29:35', 339, 0, 'i'),
        // (3, 'GEOT_STAFF_SIGNATURE', 'Phone: +1 (123) 456-7890', '2021-05-04 17:49:33', 29955, 0, 'm'),
        // (4, 'CURRENT_USER_ROLE_GEIN_EDITOR', 'Phone: +1 (123) 456-7890', '2022-02-16 10:40:49', 60435, 0, 'i');";

        // DB::select($custom_email_template_tags);

        $generic_forms = [
            "gncf_form_type" => 'feedback_form',
            "gncf_form_name" => 'Feedback Form',
            "gncf_form_title" => 'Feedback Form',
            "gncf_form_layout" => 'h',
            "gncf_form_description" => 'registration_forms',
            "gncf_reviewer_view" => 'n',
            "gncf_user_roles" => '[]',
            "gncf_form_privilege_usr_edit" => 'n',
            "gncf_form_created" => 'c',
            "gncf_posted_by" => 2,
            "gncf_posted_date" => date('Y-m-d h:i:s'),
            "gncf_proxy_id" => 0,
            "gncf_operation" => 'i'
        ];

        $generic_forms_id =  Generic_forms::insertGetId($generic_forms);

        $generic_form_group  =   [
            "gfg_gncf_id" => $generic_forms_id,
            "gfg_order" => 1,
            "gfg_posted_by" => 2,
            "gfg_posted_date" => date('Y-m-d h:i:s'),
            "gfg_proxy_id" => 0,
            "gfg_operation" => 'i'
        ];
        $generic_form_group_id  =   Generic_form_groups::insertGetId($generic_form_group);

        $generic_form_elements  =   [
            [
                "emt_gucf_id" => $generic_forms_id,
                "emt_gfg_id" => $generic_form_group_id,
                "emt_element_type" => "combobox",
                "emt_label" => "How did you hear about us?",
                "emt_required" => '1',
                "emt_word_min" => 0,
                "emt_word_max" => 0,
                "emt_options" => '[{"1":"Friend"},{"2":"Advertisement"},{"3":"Website"},{"4":"Newsletter"},{"5":"Other"}]',
                "emt_dependency_required" => 0,
                "emt_depending_control" => 0,
                "emt_active" => 0,
                "emt_order" => 1,
                "emt_attach_to_mail" => 'n',
                "emt_dynamic_status" => 'n',
                "emt_posted_by" => 2,
                "emt_posted_date" => date('Y-m-d h:i:s'),
                "emt_proxy_id" => 0,
                "emt_operation" => 'i'
            ]
        ];

        Generic_form_elements::insert($generic_form_elements);

        $rvw_email_tmpls = array(
            array('etmp_id' => '1','etmp_platform' => 'g','etmp_name' => 'create_user','etmp_templete_name' => '','etmp_notification' => 'User','etmp_cust_to' => '','etmp_cc' => '','etmp_cust_cc' => '','etmp_bcc' => '','etmp_cust_bcc' => '','etmp_content_type' => '','etmp_subject' => 'ReView account created - confirmation','etmp_email_template' => '<p>Dear ##RECIPIENT_FULLNAME##,</p>
          <p> </p>
          <p>Welcome to River Valley Technologies online submission and peer review system, <em>ReView</em>. </p>
          <p>Your username: ##RECIPIENT_USERNAME##</p>
          <p>If this is your first time logging in, you will first need to set your password. To do this, please click the following link: ##RESET_PASSWORD_LINK##</p>
          <p>Once you have completed this, please log in at ##SITE_URL## and read and accept our <em>Terms and Conditions</em> so that you are able to fully access the site.</p>
          <p>We recommend adding \'noreply@reviewdemo.rivervalleytechnologies.com\' to your contacts to avoid missing any emails from us. </p>
          <p> </p>
          <p>Kind regards,</p>
          <p>Ben Ramster</p>
          <p>Journals Manager</p>
          <p>River Valley Technologies</p>','etmp_posted_date' => '2022-07-29 14:47:30','etmp_posted_by' => '60435','etmp_proxy_id' => '0','etmp_operation' => 'u'),
            array('etmp_id' => '2','etmp_platform' => 'g','etmp_name' => 'forgot_password','etmp_templete_name' => '','etmp_notification' => 'User','etmp_cust_to' => '','etmp_cc' => '','etmp_cust_cc' => '','etmp_bcc' => '','etmp_cust_bcc' => '','etmp_content_type' => '','etmp_subject' => 'Reset your password for your ReView account','etmp_email_template' => '<p>Dear ##RECIPIENT_FULLNAME##,</p>
          <p> </p>
          <p>We have received a request to reset your password. If you did not make this request, please ignore this email.</p>
          <p>Otherwise, you can reset your password using the following link: ##RESET_PASSWORD_LINK##</p>
          <p> </p>
          <p>Kind regards,</p>
          <p>Editorial Office</p>
          <p>River Valley Technologies</p>
          <p> </p>
          <p>##TAG_DISCLAIMER##</p>','etmp_posted_date' => '2022-07-15 17:19:45','etmp_posted_by' => '60435','etmp_proxy_id' => '0','etmp_operation' => 'u'),
            array('etmp_id' => '3','etmp_platform' => 'g','etmp_name' => 'confirm_mail','etmp_templete_name' => '','etmp_notification' => 'User','etmp_cust_to' => '','etmp_cc' => '','etmp_cust_cc' => '','etmp_bcc' => '','etmp_cust_bcc' => '','etmp_content_type' => '','etmp_subject' => 'Please confirm your registration with RVT journal','etmp_email_template' => '<p>Dear ##RECIPIENT_FULLNAME##,</p>
          <p>You have been added to River Valley Technologies\'s submission and peer review system, <em>ReView</em> (##SITE_URL##).</p>
          <p>Please click this link to confirm your email account registration: ##CONFIRMATION_URL## </p>
          <p>This is an internet security best practice check.</p>
          <p>Kind regards,</p>
          <p>Editorial Office</p>
          <p>River Valley Technologies</p>
          <p> </p>
          <p>##TAG_DISCLAIMER##</p>','etmp_posted_date' => '2022-07-13 12:15:27','etmp_posted_by' => '60435','etmp_proxy_id' => '0','etmp_operation' => 'u'),
            array('etmp_id' => '10','etmp_platform' => 'g','etmp_name' => 'register_user','etmp_templete_name' => '','etmp_notification' => 'User','etmp_cust_to' => '','etmp_cc' => '','etmp_cust_cc' => '','etmp_bcc' => '','etmp_cust_bcc' => '','etmp_content_type' => '','etmp_subject' => 'ReView account registration','etmp_email_template' => '<p>Dear ##RECIPIENT_FULLNAME##,</p>
          <p>&nbsp;</p>
          <p>Welcome to River Valley Technologies&rsquo;s online submission and peer review system, <em>ReView</em>.</p>
          <p>Your username:&nbsp;##RECIPIENT_USERNAME##</p>
          <p>Please click the following link to activate your account: ##CONFIRMATION_URL##</p>
          <p>Then, you can log in at ##SITE_URL##. Please read and accept our terms and conditions so that you can fully access the site.&nbsp;</p>
          <p>&nbsp;</p>
          <p><em>Did you know?</em></p>
          <p>River Valley Technologies is happy to announce authors can now choose relevant UN Sustainable Development Goals (UN SDGs) to add to their paper. Look out for UN SDG icons on our published content at <a href="#" target="_blank" rel="noopener">Click here</a>.&nbsp;</p>
          <p>&nbsp;</p>
          <p>Kind regards,</p>
          <p>Ben Ramster&nbsp;</p>
          <p>Journals Manager</p>
          <p>River Valley Technologies</p>
          <p>&nbsp;</p>
          <p>##TAG_DISCLAIMER##</p>','etmp_posted_date' => '2023-08-02 16:04:41','etmp_posted_by' => '610','etmp_proxy_id' => '0','etmp_operation' => 'u'),
            array('etmp_id' => '17','etmp_platform' => 'g','etmp_name' => 'email_change','etmp_templete_name' => '','etmp_notification' => 'User','etmp_cust_to' => '','etmp_cc' => '','etmp_cust_cc' => '','etmp_bcc' => '','etmp_cust_bcc' => '','etmp_content_type' => '','etmp_subject' => 'Primary email address has been changed','etmp_email_template' => '<p>Dear ##RECIPIENT_FULLNAME##,</p>
          <p> </p>
          <p>This message is to notify you that your primary email address has been changed on your <em>ReView</em> account (River Valley Technologies online submission and peer review system).</p>
          <p>Please click this link to confirm your new email address: ##VERIFY_EMAIL##</p>
          <p> </p>
          <p>Regards,</p>
          <p>Editorial Office</p>
          <p>River Valley Technologies</p>','etmp_posted_date' => '2022-07-27 17:41:09','etmp_posted_by' => '60435','etmp_proxy_id' => '0','etmp_operation' => 'u'),
            array('etmp_id' => '23','etmp_platform' => 'g','etmp_name' => 'changed_password','etmp_templete_name' => '','etmp_notification' => 'User','etmp_cust_to' => '','etmp_cc' => '','etmp_cust_cc' => '','etmp_bcc' => '','etmp_cust_bcc' => '','etmp_content_type' => '','etmp_subject' => 'Password change alert','etmp_email_template' => '<p>Dear&nbsp;##RECIPIENT_FULLNAME##,</p>
          <p>&nbsp;</p>
          <p>This message is to notify you that your password has been changed on River Valley Technologies&rsquo;s online submission and peer review system, <em>ReView</em> (##SITE_URL##).</p>
          <p>This took place on ##CURRENT_DATE## at&nbsp;##CURRENT_TIME##.</p>
          <p>If this was not you, please reset your password using the following link: ##RESET_PASSWORD_LINK##</p>
          <p>Regards,</p>
          <p>Editorial Office</p>
          <p>River Valley Technologies</p>','etmp_posted_date' => '2023-09-04 09:56:46','etmp_posted_by' => '1','etmp_proxy_id' => '0','etmp_operation' => 'u'),
            array('etmp_id' => '24','etmp_platform' => 'g','etmp_name' => 'primary_email_changed','etmp_templete_name' => '','etmp_notification' => 'User','etmp_cust_to' => '','etmp_cc' => '','etmp_cust_cc' => '','etmp_bcc' => '','etmp_cust_bcc' => '','etmp_content_type' => '','etmp_subject' => 'Primary email address change has been successful','etmp_email_template' => '<p>Dear ##RECIPIENT_FULLNAME##,</p>
          <p> </p>
          <p>This message is to notify you that your primary email address has been successfully changed on <em>ReView</em> (River Valley Technologies online submission and peer review system).</p>
          <p> </p>
          <p>Regards,</p>
          <p>ReView</p>','etmp_posted_date' => '2022-07-27 17:43:44','etmp_posted_by' => '60435','etmp_proxy_id' => '0','etmp_operation' => 'u'),
            array('etmp_id' => '28','etmp_platform' => 'g','etmp_name' => 'remove_awaiting_activation_account','etmp_templete_name' => '','etmp_notification' => 'User','etmp_cust_to' => '','etmp_cc' => '','etmp_cust_cc' => '','etmp_bcc' => '','etmp_cust_bcc' => '','etmp_content_type' => '','etmp_subject' => 'User account removed','etmp_email_template' => '<p>Hi there, </p>
          <p>This message is to notify you that your account with <em>ReView</em> has been removed. This may be because your account was not activated in time. </p>
          <p><em>ReView</em> is River Valley Technologies online submission and peer review system. If you would like to work with River Valley Technologies journals on <em>ReView</em>, for example as a reviewer, please register a new user account at ##SITE_URL##.</p>
          <p>Thank you.</p>
          <p>Best regards,</p>
          <p>##RVT_PUBLISHING_SIGNATURE##</p>','etmp_posted_date' => '2022-10-27 12:49:09','etmp_posted_by' => '60435','etmp_proxy_id' => '0','etmp_operation' => 'u'),
            array('etmp_id' => '33','etmp_platform' => 'g','etmp_name' => 'verify_user','etmp_templete_name' => '','etmp_notification' => 'User','etmp_cust_to' => '','etmp_cc' => '','etmp_cust_cc' => '','etmp_bcc' => '','etmp_cust_bcc' => '','etmp_content_type' => '','etmp_subject' => 'Primary email address has been updated','etmp_email_template' => '<p>Dear ##RECIPIENT_FULLNAME##,</p>
          <p> </p>
          <p>This message is to notify you that your primary email address has been updated on your <em>ReView</em> account (River Valley Technologies online submission and peer review system).</p>
          <p>This took place on ##CURRENT_DATE## at ##CURRENT_TIME##.</p>
          <p>Please click this link to confirm the update: ##VERIFY_EMAIL##</p>
          <p>If you did not make this change, please click this link: ##REVERT_EMAIL##</p>
          <p> </p>
          <p>Regards,</p>
          <p>Editorial Office</p>
          <p>River Valley Technologies</p>','etmp_posted_date' => '2022-07-27 17:42:03','etmp_posted_by' => '60435','etmp_proxy_id' => '0','etmp_operation' => 'u'),
            array('etmp_id' => '38','etmp_platform' => 'g','etmp_name' => 'changed_username','etmp_templete_name' => '','etmp_notification' => 'User','etmp_cust_to' => '','etmp_cc' => '','etmp_cust_cc' => '','etmp_bcc' => '','etmp_cust_bcc' => '','etmp_content_type' => '','etmp_subject' => 'Your username has been changed','etmp_email_template' => '<p>Dear ##RECIPIENT_FULLNAME##,</p>
          <p> </p>
          <p>Your <em>ReView</em> username has been changed on ##CURRENT_DATE## at ##CURRENT_TIME##.</p>
          <p>You can use your registered email address to log in at ##SITE_URL##.</p>
          <p> </p>
          <p>Regards,</p>
          <p>##RVT_PUBLISHING_SIGNATURE##</p>
          <p> </p>
          <p>##TAG_DISCLAIMER##</p>','etmp_posted_date' => '2022-08-02 17:19:15','etmp_posted_by' => '60435','etmp_proxy_id' => '0','etmp_operation' => 'u'),
            array('etmp_id' => '39','etmp_platform' => 'g','etmp_name' => 'unregister_notification','etmp_templete_name' => '','etmp_notification' => 'User','etmp_cust_to' => '','etmp_cc' => '','etmp_cust_cc' => '','etmp_bcc' => '','etmp_cust_bcc' => '','etmp_content_type' => '','etmp_subject' => 'Your account has been unregistered','etmp_email_template' => '<p>Dear ##RECIPIENT_FULLNAME##,</p>
          <p>This is a message to inform you that we have received a request to unregister your account with <em>ReView</em>, River Valley Technologies online submission and peer review system. This will be processed shortly.</p>
          <p>For now, your account has been suspended. If you have not requested to unregister your account or this was by mistake, please get in touch with the River Valley Technologies team as soon as possible. See here: <a href="#" target="_blank">Contact us</a>.</p>
          <p>Regards,<br> <br> ##RVT_PUBLISHING_SIGNATURE##</p>','etmp_posted_date' => '2022-08-02 17:17:37','etmp_posted_by' => '60435','etmp_proxy_id' => '0','etmp_operation' => 'u'),
            array('etmp_id' => '40','etmp_platform' => 'g','etmp_name' => 'unregister_confirmation','etmp_templete_name' => '','etmp_notification' => 'User','etmp_cust_to' => '','etmp_cc' => '','etmp_cust_cc' => '','etmp_bcc' => '','etmp_cust_bcc' => '','etmp_content_type' => '','etmp_subject' => 'User account unregistered','etmp_email_template' => '<p>Dear ##RECIPIENT_FULLNAME##,</p>
          <p>As requested, your<em> ReView</em> account has been unregistered and your details have been removed from the site. You will no longer be able to recover your user information.</p>
          <p><em>ReView </em>is River Valley Technologies online submission and peer review system. If you would like to work with River Valley Technologies journals on <em>ReView</em>, please register a new user account at ##SITE_URL##.</p>
          <p>Regards,</p>
          <p>##RVT_PUBLISHING_SIGNATURE##</p>
          <p> </p>
          <p>##TAG_DISCLAIMER##</p>','etmp_posted_date' => '2022-08-02 17:16:40','etmp_posted_by' => '60435','etmp_proxy_id' => '0','etmp_operation' => 'u'),
            array('etmp_id' => '41','etmp_platform' => 'g','etmp_name' => 'unregister_diapproval','etmp_templete_name' => '','etmp_notification' => 'User','etmp_cust_to' => '','etmp_cc' => '','etmp_cust_cc' => '','etmp_bcc' => '','etmp_cust_bcc' => '','etmp_content_type' => '','etmp_subject' => 'Unregistering from ReView','etmp_email_template' => '<p>Dear ##RECIPIENT_FULLNAME##,</p>
          <p> </p>
          <p>Best regards,</p>
          <p>##RVT_PUBLISHING_SIGNATURE##</p>
          <p> </p>','etmp_posted_date' => '2022-08-02 17:18:10','etmp_posted_by' => '60435','etmp_proxy_id' => '0','etmp_operation' => 'u'),
            array('etmp_id' => '42','etmp_platform' => 'g','etmp_name' => 'unregister_notification_super','etmp_templete_name' => '','etmp_notification' => 'Super Admin','etmp_cust_to' => '','etmp_cc' => '','etmp_cust_cc' => '','etmp_bcc' => '','etmp_cust_bcc' => '','etmp_content_type' => '','etmp_subject' => 'Unregister Account Notification - Super Admin','etmp_email_template' => '<p>Dear ##RECIPIENT_FULLNAME##,</p>
          <p>##CURRENT_USER_FULLNAME## has requested that their account be unregistered. You can access this request in Manage Users.</p>
          <p>The reason given: ##CURRENT_USER_UNREGISTER_REASON##</p>
          <p>Regards,</p>
          <p>##RVT_PUBLISHING_SIGNATURE##</p>','etmp_posted_date' => '2022-08-02 17:17:55','etmp_posted_by' => '60435','etmp_proxy_id' => '0','etmp_operation' => 'u'),
            array('etmp_id' => '43','etmp_platform' => 'g','etmp_name' => 'api_client_expire_notification','etmp_templete_name' => '','etmp_notification' => 'User','etmp_cust_to' => '','etmp_cc' => '','etmp_cust_cc' => '','etmp_bcc' => '','etmp_cust_bcc' => '','etmp_content_type' => '','etmp_subject' => 'Api expire notification','etmp_email_template' => '<p>Dear ##API_CLIENT_NAME##,</p>
          <p>Your API KEY will be expired on ##EXPIRATION_DATE##.</p>
          <p>Regards,</p>
          <p>Team ReView</p>','etmp_posted_date' => '2019-03-06 10:27:26','etmp_posted_by' => '363','etmp_proxy_id' => '0','etmp_operation' => 'u'),
            array('etmp_id' => '44','etmp_platform' => 'g','etmp_name' => 'api_client_expired_notification','etmp_templete_name' => '','etmp_notification' => 'User','etmp_cust_to' => '','etmp_cc' => '','etmp_cust_cc' => '','etmp_bcc' => '','etmp_cust_bcc' => '','etmp_content_type' => '','etmp_subject' => 'Api expired notification','etmp_email_template' => '<p>Dear ##API_CLIENT_NAME##,</p>
          <p>Your API KEY has been expired..</p>
          <p>Regards,</p>
          <p>Team ReView.</p>','etmp_posted_date' => '2019-04-18 17:53:53','etmp_posted_by' => '363','etmp_proxy_id' => '0','etmp_operation' => 'u'),
            array('etmp_id' => '45','etmp_platform' => 'g','etmp_name' => 'api_client_invitation','etmp_templete_name' => '','etmp_notification' => 'User','etmp_cust_to' => '','etmp_cc' => '','etmp_cust_cc' => '','etmp_bcc' => '','etmp_cust_bcc' => '','etmp_content_type' => '','etmp_subject' => 'Api Invitation','etmp_email_template' => '<p>Dear ##API_CLIENT_NAME##,</p>
          <p>You are invited as api client user for the period of ##EXPIRATION_PERIOD##. Please use the below api for further usage</p>
          <p>Api Key: ##API_KEY##</p>
          <p>Api Key expires on ##EXPIRATION_DATE##</p>
          <p>Regards,</p>
          <p>Team ReView</p>','etmp_posted_date' => '2023-10-17 13:41:00','etmp_posted_by' => '610','etmp_proxy_id' => '0','etmp_operation' => 'u'),
            array('etmp_id' => '46','etmp_platform' => 'g','etmp_name' => 'manage_user_keywords','etmp_templete_name' => '','etmp_notification' => 'Users','etmp_cust_to' => '','etmp_cc' => '','etmp_cust_cc' => '','etmp_bcc' => '','etmp_cust_bcc' => '','etmp_content_type' => '','etmp_subject' => 'ReView user keywords changes','etmp_email_template' => '<p>Dear ##RECIPIENT_FULLNAME##,</p>
          <p> </p>
          <p>Your profile keywords have been modified.</p>
          <p>Added keyword(s): ##ADDED_USER_KEYWORDS##</p>
          <p>Removed keyword(s): ##REMOVED_USER_KEYWORDS##</p>
          <p> </p>
          <p>Regards,</p>
          <p>##CURRENT_USER_FULLNAME##</p>','etmp_posted_date' => '2022-07-15 17:24:51','etmp_posted_by' => '60435','etmp_proxy_id' => '0','etmp_operation' => 'u'),
            array('etmp_id' => '47','etmp_platform' => 'g','etmp_name' => 'added_alternative_email_id','etmp_templete_name' => '','etmp_notification' => 'User','etmp_cust_to' => '','etmp_cc' => '','etmp_cust_cc' => '','etmp_bcc' => '','etmp_cust_bcc' => '','etmp_content_type' => '','etmp_subject' => 'New alternative email ID added to ReView account','etmp_email_template' => '<p>Dear ##RECIPIENT_FULLNAME##,</p>
          <p>&nbsp;</p>
          <p>This message is to notify you that your email has been added as an alternative email in the ReView account for ##RECIPIENT_FULLNAME## in <em>##JOURNAL_NAME##</em>.</p>
          <p>If you are not the owner of this user account, report this to us and/or&nbsp;remove the email by using this link: ##ALTERNATIVE_EMAIL_CONFIRMATION##</p>
          <p>&nbsp;</p>
          <p>Regards,</p>
          <p>##JOURNAL_EPA_FULLNAME##</p>
          <p>##JOURNAL_EPA_EMAIL##</p>
          <p>##JOURNAL_NAME##</p>
          <p>River Valley Technologies</p>','etmp_posted_date' => '2023-10-17 09:28:20','etmp_posted_by' => '610','etmp_proxy_id' => '0','etmp_operation' => 'u')
        );

        DB::table('rvw_email_tmpls')->insert($rvw_email_tmpls);

        $country_update = "ALTER TABLE rvw_country DROP PRIMARY KEY;";
        DB::select($country_update);
        $country_update1 = "ALTER TABLE `rvw_country` ADD COLUMN `cnt_int_id` INT NOT NULL AUTO_INCREMENT FIRST, ADD PRIMARY KEY (`cnt_int_id`);";
        DB::select($country_update1);
        $country_details = "INSERT INTO `rvw_country` (`cnt_id`, `cnt_country`, `cnt_posted_date`, `cnt_posted_by`, `cnt_proxy_id`) VALUES
        ('AD', 'Andorra', '2017-03-02 15:50:33', NULL, NULL),
        ('AE', 'United Arab Emirates', '2017-03-02 15:50:33', NULL, NULL),
        ('AF', 'Afghanistan', '2017-03-02 15:50:33', NULL, NULL),
        ('AG', 'Antigua and Barbuda', '2017-03-02 15:50:33', NULL, NULL),
        ('AI', 'Anguilla', '2017-03-02 15:50:33', NULL, NULL),
        ('AL', 'Albania', '2017-03-02 15:50:33', NULL, NULL),
        ('AM', 'Armenia', '2017-03-02 15:50:33', NULL, NULL),
        ('AN', 'Netherlands Antilles', '2017-03-02 15:50:33', NULL, NULL),
        ('AO', 'Angola', '2017-03-02 15:50:33', NULL, NULL),
        ('AQ', 'Antarctica', '2017-03-02 15:50:33', NULL, NULL),
        ('AR', 'Argentina', '2017-03-02 15:50:33', NULL, NULL),
        ('AT', 'Austria', '2017-03-02 15:50:33', NULL, NULL),
        ('AU', 'Australia', '2017-03-02 15:50:33', NULL, NULL),
        ('AW', 'Aruba', '2017-03-02 15:50:33', NULL, NULL),
        ('AZ', 'Azerbaijan', '2017-03-02 15:50:33', NULL, NULL),
        ('BA', 'Bosnia and Herzegovina', '2017-03-02 15:50:33', NULL, NULL),
        ('BB', 'Barbados', '2017-03-02 15:50:33', NULL, NULL),
        ('BD', 'Bangladesh', '2017-03-02 15:50:33', NULL, NULL),
        ('BE', 'Belgium', '2017-03-02 15:50:33', NULL, NULL),
        ('BF', 'Burkina Faso', '2017-03-02 15:50:33', NULL, NULL),
        ('BG', 'Bulgaria', '2017-03-02 15:50:33', NULL, NULL),
        ('BH', 'Bahrain', '2017-03-02 15:50:33', NULL, NULL),
        ('BI', 'Burundi', '2017-03-02 15:50:33', NULL, NULL),
        ('BJ', 'Benin', '2017-03-02 15:50:33', NULL, NULL),
        ('BM', 'Bermuda', '2017-03-02 15:50:33', NULL, NULL),
        ('BN', 'Brunei Darussalam', '2017-03-02 15:50:33', NULL, NULL),
        ('BO', 'Bolivia', '2017-03-02 15:50:33', NULL, NULL),
        ('BR', 'Brazil', '2017-03-02 15:50:33', NULL, NULL),
        ('BS', 'Bahamas', '2017-03-02 15:50:33', NULL, NULL),
        ('BT', 'Bhutan', '2017-03-02 15:50:33', NULL, NULL),
        ('BV', 'Bouvet Island', '2017-03-02 15:50:33', NULL, NULL),
        ('BW', 'Botswana', '2017-03-02 15:50:33', NULL, NULL),
        ('BY', 'Belarus', '2017-03-02 15:50:33', NULL, NULL),
        ('BZ', 'Belize', '2017-03-02 15:50:33', NULL, NULL),
        ('CA', 'Canada', '2017-03-02 15:50:33', NULL, NULL),
        ('CC', 'Cocos (Keeling) Islands', '2017-03-02 15:50:33', NULL, NULL),
        ('CF', 'Central African Republic', '2017-03-02 15:50:33', NULL, NULL),
        ('CG', 'Congo', '2017-03-02 15:50:33', NULL, NULL),
        ('CH', 'Switzerland', '2017-03-02 15:50:33', NULL, NULL),
        ('CI', 'Ivory Coast', '2017-03-02 15:50:33', NULL, NULL),
        ('CK', 'Cook Islands', '2017-03-02 15:50:33', NULL, NULL),
        ('CL', 'Chile', '2017-03-02 15:50:33', NULL, NULL),
        ('CM', 'Cameroon', '2017-03-02 15:50:33', NULL, NULL),
        ('CN', 'China', '2017-03-02 15:50:33', NULL, NULL),
        ('CO', 'Colombia', '2017-03-02 15:50:33', NULL, NULL),
        ('CR', 'Costa Rica', '2017-03-02 15:50:33', NULL, NULL),
        ('CU', 'Cuba', '2017-03-02 15:50:33', NULL, NULL),
        ('CV', 'Cape Verde', '2017-03-02 15:50:33', NULL, NULL),
        ('CX', 'Christmas Island', '2017-03-02 15:50:33', NULL, NULL),
        ('CY', 'Cyprus', '2017-03-02 15:50:33', NULL, NULL),
        ('CZ', 'Czech Republic', '2017-03-02 15:50:33', NULL, NULL),
        ('DE', 'Germany', '2017-03-02 15:50:33', NULL, NULL),
        ('DJ', 'Djibouti', '2017-03-02 15:50:33', NULL, NULL),
        ('DK', 'Denmark', '2017-03-02 15:50:33', NULL, NULL),
        ('DM', 'Dominica', '2017-03-02 15:50:33', NULL, NULL),
        ('DO', 'Dominican Republic', '2017-03-02 15:50:33', NULL, NULL),
        ('DS', 'American Samoa', '2017-03-02 15:50:33', NULL, NULL),
        ('DZ', 'Algeria', '2017-03-02 15:50:33', NULL, NULL),
        ('EC', 'Ecuador', '2017-03-02 15:50:33', NULL, NULL),
        ('EE', 'Estonia', '2017-03-02 15:50:33', NULL, NULL),
        ('EG', 'Egypt', '2017-03-02 15:50:33', NULL, NULL),
        ('EH', 'Western Sahara', '2017-03-02 15:50:33', NULL, NULL),
        ('ER', 'Eritrea', '2017-03-02 15:50:33', NULL, NULL),
        ('ES', 'Spain', '2017-03-02 15:50:33', NULL, NULL),
        ('ET', 'Ethiopia', '2017-03-02 15:50:33', NULL, NULL),
        ('FI', 'Finland', '2017-03-02 15:50:33', NULL, NULL),
        ('FJ', 'Fiji', '2017-03-02 15:50:33', NULL, NULL),
        ('FK', 'Falkland Islands (Malvinas)', '2017-03-02 15:50:33', NULL, NULL),
        ('FM', 'Micronesia, Federated States of', '2017-03-02 15:50:33', NULL, NULL),
        ('FO', 'Faroe Islands', '2017-03-02 15:50:33', NULL, NULL),
        ('FR', 'France', '2017-03-02 15:50:33', NULL, NULL),
        ('FX', 'France, Metropolitan', '2017-03-02 15:50:33', NULL, NULL),
        ('GA', 'Gabon', '2017-03-02 15:50:33', NULL, NULL),
        ('GB', 'United Kingdom', '2017-03-02 15:50:33', NULL, NULL),
        ('GD', 'Grenada', '2017-03-02 15:50:33', NULL, NULL),
        ('GE', 'Georgia', '2017-03-02 15:50:33', NULL, NULL),
        ('GF', 'French Guiana', '2017-03-02 15:50:33', NULL, NULL),
        ('GH', 'Ghana', '2017-03-02 15:50:33', NULL, NULL),
        ('GI', 'Gibraltar', '2017-03-02 15:50:33', NULL, NULL),
        ('GK', 'Guernsey', '2017-03-02 15:50:33', NULL, NULL),
        ('GL', 'Greenland', '2017-03-02 15:50:33', NULL, NULL),
        ('GM', 'Gambia', '2017-03-02 15:50:33', NULL, NULL),
        ('GN', 'Guinea', '2017-03-02 15:50:33', NULL, NULL),
        ('GP', 'Guadeloupe', '2017-03-02 15:50:33', NULL, NULL),
        ('GQ', 'Equatorial Guinea', '2017-03-02 15:50:33', NULL, NULL),
        ('GR', 'Greece', '2017-03-02 15:50:33', NULL, NULL),
        ('GS', 'South Georgia South Sandwich Islands', '2017-03-02 15:50:33', NULL, NULL),
        ('GT', 'Guatemala', '2017-03-02 15:50:33', NULL, NULL),
        ('GU', 'Guam', '2017-03-02 15:50:33', NULL, NULL),
        ('GW', 'Guinea-Bissau', '2017-03-02 15:50:33', NULL, NULL),
        ('GY', 'Guyana', '2017-03-02 15:50:33', NULL, NULL),
        ('HK', 'Hong Kong', '2017-03-02 15:50:33', NULL, NULL),
        ('HM', 'Heard and Mc Donald Islands', '2017-03-02 15:50:33', NULL, NULL),
        ('HN', 'Honduras', '2017-03-02 15:50:33', NULL, NULL),
        ('HR', 'Croatia (Hrvatska)', '2017-03-02 15:50:33', NULL, NULL),
        ('HT', 'Haiti', '2017-03-02 15:50:33', NULL, NULL),
        ('HU', 'Hungary', '2017-03-02 15:50:33', NULL, NULL),
        ('ID', 'Indonesia', '2017-03-02 15:50:33', NULL, NULL),
        ('IE', 'Ireland', '2017-03-02 15:50:33', NULL, NULL),
        ('IL', 'Israel', '2017-03-02 15:50:33', NULL, NULL),
        ('IM', 'Isle of Man', '2017-03-02 15:50:33', NULL, NULL),
        ('IN', 'India', '2017-03-02 15:50:33', NULL, NULL),
        ('IO', 'British Indian Ocean Territory', '2017-03-02 15:50:33', NULL, NULL),
        ('IQ', 'Iraq', '2017-03-02 15:50:33', NULL, NULL),
        ('IR', 'Iran (Islamic Republic of)', '2017-03-02 15:50:33', NULL, NULL),
        ('IS', 'Iceland', '2017-03-02 15:50:33', NULL, NULL),
        ('IT', 'Italy', '2017-03-02 15:50:33', NULL, NULL),
        ('JE', 'Jersey', '2017-03-02 15:50:33', NULL, NULL),
        ('JM', 'Jamaica', '2017-03-02 15:50:33', NULL, NULL),
        ('JO', 'Jordan', '2017-03-02 15:50:33', NULL, NULL),
        ('JP', 'Japan', '2017-03-02 15:50:33', NULL, NULL),
        ('KE', 'Kenya', '2017-03-02 15:50:33', NULL, NULL),
        ('KG', 'Kyrgyzstan', '2017-03-02 15:50:33', NULL, NULL),
        ('KH', 'Cambodia', '2017-03-02 15:50:33', NULL, NULL),
        ('KI', 'Kiribati', '2017-03-02 15:50:33', NULL, NULL),
        ('KM', 'Comoros', '2017-03-02 15:50:33', NULL, NULL),
        ('KN', 'Saint Kitts and Nevis', '2017-03-02 15:50:33', NULL, NULL),
        ('KP', 'Korea, Democratic People\'s Republic of', '2017-03-02 15:50:33', NULL, NULL),
        ('KR', 'Korea, Republic of', '2017-03-02 15:50:33', NULL, NULL),
        ('KW', 'Kuwait', '2017-03-02 15:50:33', NULL, NULL),
        ('KY', 'Cayman Islands', '2017-03-02 15:50:33', NULL, NULL),
        ('KZ', 'Kazakhstan', '2017-03-02 15:50:33', NULL, NULL),
        ('LA', 'Lao People\'s Democratic Republic', '2017-03-02 15:50:33', NULL, NULL),
        ('LB', 'Lebanon', '2017-03-02 15:50:33', NULL, NULL),
        ('LC', 'Saint Lucia', '2017-03-02 15:50:33', NULL, NULL),
        ('LI', 'Liechtenstein', '2017-03-02 15:50:33', NULL, NULL),
        ('LK', 'Sri Lanka', '2017-03-02 15:50:33', NULL, NULL),
        ('LR', 'Liberia', '2017-03-02 15:50:33', NULL, NULL),
        ('LS', 'Lesotho', '2017-03-02 15:50:33', NULL, NULL),
        ('LT', 'Lithuania', '2017-03-02 15:50:33', NULL, NULL),
        ('LU', 'Luxembourg', '2017-03-02 15:50:33', NULL, NULL),
        ('LV', 'Latvia', '2017-03-02 15:50:33', NULL, NULL),
        ('LY', 'Libyan Arab Jamahiriya', '2017-03-02 15:50:33', NULL, NULL),
        ('MA', 'Morocco', '2017-03-02 15:50:33', NULL, NULL),
        ('MC', 'Monaco', '2017-03-02 15:50:33', NULL, NULL),
        ('MD', 'Moldova, Republic of', '2017-03-02 15:50:33', NULL, NULL),
        ('ME', 'Montenegro', '2017-03-02 15:50:33', NULL, NULL),
        ('MG', 'Madagascar', '2017-03-02 15:50:33', NULL, NULL),
        ('MH', 'Marshall Islands', '2017-03-02 15:50:33', NULL, NULL),
        ('MK', 'Macedonia', '2017-03-02 15:50:33', NULL, NULL),
        ('ML', 'Mali', '2017-03-02 15:50:33', NULL, NULL),
        ('MM', 'Myanmar', '2017-03-02 15:50:33', NULL, NULL),
        ('MN', 'Mongolia', '2017-03-02 15:50:33', NULL, NULL),
        ('MO', 'Macau', '2017-03-02 15:50:33', NULL, NULL),
        ('MP', 'Northern Mariana Islands', '2017-03-02 15:50:33', NULL, NULL),
        ('MQ', 'Martinique', '2017-03-02 15:50:33', NULL, NULL),
        ('MR', 'Mauritania', '2017-03-02 15:50:33', NULL, NULL),
        ('MS', 'Montserrat', '2017-03-02 15:50:33', NULL, NULL),
        ('MT', 'Malta', '2017-03-02 15:50:33', NULL, NULL),
        ('MU', 'Mauritius', '2017-03-02 15:50:33', NULL, NULL),
        ('MV', 'Maldives', '2017-03-02 15:50:33', NULL, NULL),
        ('MW', 'Malawi', '2017-03-02 15:50:33', NULL, NULL),
        ('MX', 'Mexico', '2017-03-02 15:50:33', NULL, NULL),
        ('MY', 'Malaysia', '2017-03-02 15:50:33', NULL, NULL),
        ('MZ', 'Mozambique', '2017-03-02 15:50:33', NULL, NULL),
        ('NA', 'Namibia', '2017-03-02 15:50:33', NULL, NULL),
        ('NC', 'New Caledonia', '2017-03-02 15:50:33', NULL, NULL),
        ('NE', 'Niger', '2017-03-02 15:50:33', NULL, NULL),
        ('NF', 'Norfolk Island', '2017-03-02 15:50:33', NULL, NULL),
        ('NG', 'Nigeria', '2017-03-02 15:50:33', NULL, NULL),
        ('NI', 'Nicaragua', '2017-03-02 15:50:33', NULL, NULL),
        ('NL', 'Netherlands', '2017-03-02 15:50:33', NULL, NULL),
        ('NO', 'Norway', '2017-03-02 15:50:33', NULL, NULL),
        ('NP', 'Nepal', '2017-03-02 15:50:33', NULL, NULL),
        ('NR', 'Nauru', '2017-03-02 15:50:33', NULL, NULL),
        ('NU', 'Niue', '2017-03-02 15:50:33', NULL, NULL),
        ('NZ', 'New Zealand', '2017-03-02 15:50:33', NULL, NULL),
        ('OM', 'Oman', '2017-03-02 15:50:33', NULL, NULL),
        ('PA', 'Panama', '2017-03-02 15:50:33', NULL, NULL),
        ('PE', 'Peru', '2017-03-02 15:50:33', NULL, NULL),
        ('PF', 'French Polynesia', '2017-03-02 15:50:33', NULL, NULL),
        ('PG', 'Papua New Guinea', '2017-03-02 15:50:33', NULL, NULL),
        ('PH', 'Philippines', '2017-03-02 15:50:33', NULL, NULL),
        ('PK', 'Pakistan', '2017-03-02 15:50:33', NULL, NULL),
        ('PL', 'Poland', '2017-03-02 15:50:33', NULL, NULL),
        ('PM', 'St. Pierre and Miquelon', '2017-03-02 15:50:33', NULL, NULL),
        ('PN', 'Pitcairn', '2017-03-02 15:50:33', NULL, NULL),
        ('PR', 'Puerto Rico', '2017-03-02 15:50:33', NULL, NULL),
        ('PS', 'Palestine', '2017-03-02 15:50:33', NULL, NULL),
        ('PT', 'Portugal', '2017-03-02 15:50:33', NULL, NULL),
        ('PW', 'Palau', '2017-03-02 15:50:33', NULL, NULL),
        ('PY', 'Paraguay', '2017-03-02 15:50:33', NULL, NULL),
        ('QA', 'Qatar', '2017-03-02 15:50:33', NULL, NULL),
        ('RE', 'Reunion', '2017-03-02 15:50:33', NULL, NULL),
        ('RO', 'Romania', '2017-03-02 15:50:33', NULL, NULL),
        ('RS', 'Serbia', '2017-03-02 15:50:33', NULL, NULL),
        ('RU', 'Russian Federation', '2017-03-02 15:50:33', NULL, NULL),
        ('RW', 'Rwanda', '2017-03-02 15:50:33', NULL, NULL),
        ('SA', 'Saudi Arabia', '2017-03-02 15:50:33', NULL, NULL),
        ('SB', 'Solomon Islands', '2017-03-02 15:50:33', NULL, NULL),
        ('SC', 'Seychelles', '2017-03-02 15:50:33', NULL, NULL),
        ('SD', 'Sudan', '2017-03-02 15:50:33', NULL, NULL),
        ('SE', 'Sweden', '2017-03-02 15:50:33', NULL, NULL),
        ('SG', 'Singapore', '2017-03-02 15:50:33', NULL, NULL),
        ('SH', 'St. Helena', '2017-03-02 15:50:33', NULL, NULL),
        ('SI', 'Slovenia', '2017-03-02 15:50:33', NULL, NULL),
        ('SJ', 'Svalbard and Jan Mayen Islands', '2017-03-02 15:50:33', NULL, NULL),
        ('SK', 'Slovakia', '2017-03-02 15:50:33', NULL, NULL),
        ('SL', 'Sierra Leone', '2017-03-02 15:50:33', NULL, NULL),
        ('SM', 'San Marino', '2017-03-02 15:50:33', NULL, NULL),
        ('SN', 'Senegal', '2017-03-02 15:50:33', NULL, NULL),
        ('SO', 'Somalia', '2017-03-02 15:50:33', NULL, NULL),
        ('SR', 'Suriname', '2017-03-02 15:50:33', NULL, NULL),
        ('ST', 'Sao Tome and Principe', '2017-03-02 15:50:33', NULL, NULL),
        ('SV', 'El Salvador', '2017-03-02 15:50:33', NULL, NULL),
        ('SY', 'Syrian Arab Republic', '2017-03-02 15:50:33', NULL, NULL),
        ('SZ', 'Swaziland', '2017-03-02 15:50:33', NULL, NULL),
        ('TC', 'Turks and Caicos Islands', '2017-03-02 15:50:33', NULL, NULL),
        ('TD', 'Chad', '2017-03-02 15:50:33', NULL, NULL),
        ('TF', 'French Southern Territories', '2017-03-02 15:50:33', NULL, NULL),
        ('TG', 'Togo', '2017-03-02 15:50:33', NULL, NULL),
        ('TH', 'Thailand', '2017-03-02 15:50:33', NULL, NULL),
        ('TJ', 'Tajikistan', '2017-03-02 15:50:33', NULL, NULL),
        ('TK', 'Tokelau', '2017-03-02 15:50:33', NULL, NULL),
        ('TM', 'Turkmenistan', '2017-03-02 15:50:33', NULL, NULL),
        ('TN', 'Tunisia', '2017-03-02 15:50:33', NULL, NULL),
        ('TO', 'Tonga', '2017-03-02 15:50:33', NULL, NULL),
        ('TP', 'East Timor', '2017-03-02 15:50:33', NULL, NULL),
        ('TR', 'Turkey', '2017-03-02 15:50:33', NULL, NULL),
        ('TT', 'Trinidad and Tobago', '2017-03-02 15:50:33', NULL, NULL),
        ('TV', 'Tuvalu', '2017-03-02 15:50:33', NULL, NULL),
        ('TW', 'Taiwan', '2017-03-02 15:50:33', NULL, NULL),
        ('TY', 'Mayotte', '2017-03-02 15:50:33', NULL, NULL),
        ('TZ', 'Tanzania, United Republic of', '2017-03-02 15:50:33', NULL, NULL),
        ('UA', 'Ukraine', '2017-03-02 15:50:33', NULL, NULL),
        ('UG', 'Uganda', '2017-03-02 15:50:33', NULL, NULL),
        ('UM', 'United States minor outlying islands', '2017-03-02 15:50:33', NULL, NULL),
        ('US', 'United States', '2017-03-02 15:50:33', NULL, NULL),
        ('UY', 'Uruguay', '2017-03-02 15:50:33', NULL, NULL),
        ('UZ', 'Uzbekistan', '2017-03-02 15:50:33', NULL, NULL),
        ('VA', 'Vatican City State', '2017-03-02 15:50:33', NULL, NULL),
        ('VC', 'Saint Vincent and the Grenadines', '2017-03-02 15:50:33', NULL, NULL),
        ('VE', 'Venezuela', '2017-03-02 15:50:33', NULL, NULL),
        ('VG', 'Virgin Islands (British)', '2017-03-02 15:50:33', NULL, NULL),
        ('VI', 'Virgin Islands (U.S.)', '2017-03-02 15:50:33', NULL, NULL),
        ('VN', 'Vietnam', '2017-03-02 15:50:33', NULL, NULL),
        ('VU', 'Vanuatu', '2017-03-02 15:50:33', NULL, NULL),
        ('WF', 'Wallis and Futuna Islands', '2017-03-02 15:50:33', NULL, NULL),
        ('WS', 'Samoa', '2017-03-02 15:50:33', NULL, NULL),
        ('XK', 'Kosovo', '2017-03-02 15:50:33', NULL, NULL),
        ('YE', 'Yemen', '2017-03-02 15:50:33', NULL, NULL),
        ('ZA', 'South Africa', '2017-03-02 15:50:33', NULL, NULL),
        ('ZM', 'Zambia', '2017-03-02 15:50:33', NULL, NULL),
        ('ZR', 'Zaire', '2017-03-02 15:50:33', NULL, NULL),
        ('ZW', 'Zimbabwe', '2017-03-02 15:50:33', NULL, NULL);";

        DB::select($country_details);

        $roles = "INSERT INTO rvw_roles (role_name, role_assigned_role, role_used_in, role_oa_discount_enabled, role_mfa_enabled, role_reauthorize_accont_enable, role_adhoc_role_status, role_adhoc_role_label, role_posted_by, role_posted_date, role_proxy_id, role_operation) VALUES ('Author', 'author', 'r,p', 'n', 'n', 'n', 'n', NULL, 1, '2017-01-09 08:41:55', 0, 'u'), ('Journal Admin', 'journal_admin', 'r,p', 'n', 'n', 'n', 'n', NULL, 1, '2017-01-09 08:41:55', 0, 'u'), ('System', 'system', 'r', 'n', 'n', 'n', 'n', NULL, 1, '2017-07-11 08:20:48', 0, 'i');";

        DB::select($roles);
    }
}
