<?php

namespace Database\Seeders;

use App\Models\Generic_form_elements; // Import your model
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class PopulateEmtPopulateDataPairSeeder extends Seeder
{
    public function run(): void
    {
        // Get all records where you want to populate the new field
        $records = Generic_form_elements::select('emt_id', 'emt_source_formid', 'emt_source_elementid')
            ->whereNotNull('emt_source_formid')
            ->where('emt_source_formid', '!=', 0)
            ->whereNotNull('emt_source_elementid')
            ->where('emt_source_elementid', '!=', 0)
            ->get();

        foreach ($records as $record) {
            $populateData =
                [ 
                    $record->emt_source_formid => ["" . (string)$record->emt_source_elementid] // The associative array inside
                ];
           
            $jsonData = json_encode([$populateData]); 

            Generic_form_elements::where('emt_id', $record->emt_id)->update([
                'emt_populate_data_pair' => $jsonData,
            ]);
        }
    }
}