<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use App\Models\User;
use DB;

class UserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $default_user_data  =   [
            "0" => [
              "usr_user_legacy_id"=> null,
              "usr_username"=> "sa",
              "usr_pwd_original"=> "733d7d737c3ed2b0adc36a010b24f4fb",
              "usr_pwd"=> '$2a$10$IiExah6A9nMFCVmbNtUmnOhoR3.XTfSQKztxCzDBHoAHE91EbKZva',
              "usr_title"=> "mr",
              "usr_first_name"=> "Gijo",
              "usr_middle_name"=> null,
              "usr_last_name"=> "Joseph",
              "usr_email"=> "test1@reviewdemo.rivervalleytechnologies.com",
              "usr_website"=> null,
              "usr_twitter_id"=> null,
              "usr_github_id"=> null,
              "usr_dnd"=> "n",
              "usr_dnd_marketing"=> null,
              "usr_dnd_share_data"=> null,
              "usr_dnd_jnls"=> null,
              "usr_status"=> "a",
              "usr_institution"=> null,
              "usr_postal_code"=> "666 666",
              "usr_phone_no"=> "(91)45559447311268",
              "usr_registered"=> "n",
              "usr_filter_key"=> null,
              "usr_home_filter_keys"=> '{"article_code":"","article_title":"","journals":"","article_type":"","stage_name":"","my_task":"1","jnlcd":"","sort":["undefined"]}',
              "usr_home_sort_keys"=> null,
              "usr_url"=> null,
              "usr_activation"=> "n",
              "usr_deeplink_token"=> "",
              "usr_roles"=> '["super_admin"]',
              "usr_jnl_standalone"=> null,
              "usr_image"=> "1699266711_1.jpg",
              "usr_thumb_preference"=> "list",
              "usr_f_status"=> "n",
              "usr_terms_condition"=> "y",
              "usr_last_review_invite"=> date('Y-m-d h:i:s'),
              "usr_orcid_response"=> null,
              "usr_reg_date"=> date('Y-m-d h:i:s'),
              "usr_reauthorised_date"=> null,
              "usr_mfa_token"=> null,
              "usr_alt_totps"=> null,
              "usr_gender"=> "n",
              "usr_ethnicity"=> '{"opt_val":"n"}',
              "usr_race"=> '{"opt_val":"n"}',
              "usr_posted_by"=> 1,
              "usr_posted_date"=> date('Y-m-d h:i:s'),
              "usr_proxy_id"=> 0,
              "usr_operation"=> "u",
              "usr_orcid_id"=> null,
              "usr_orcid_token"=> null,
            ],
            "1" => [
              "usr_user_legacy_id"=> null,
              "usr_username"=> "sudo",
              "usr_pwd_original"=> "c744401883782e51d1aaa4d7605bd9ca",
              "usr_pwd"=> '$2a$10$IiExah6A9nMFCVmbNtUmnOhoR3.XTfSQKztxCzDBHoAHE91EbKZva',
              "usr_title"=> "",
              "usr_first_name"=> "Rivervalley",
              "usr_middle_name"=> "",
              "usr_last_name"=> "Technologies",
              "usr_email"=> "test339@reviewdemo.rivervalleytechnologies.com",
              "usr_website"=> null,
              "usr_twitter_id"=> null,
              "usr_github_id"=> null,
              "usr_dnd"=> "n",
              "usr_dnd_marketing"=> null,
              "usr_dnd_share_data"=> null,
              "usr_dnd_jnls"=> null,
              "usr_status"=> "a",
              "usr_institution"=> null,
              "usr_postal_code"=> null,
              "usr_phone_no"=> "",
              "usr_registered"=> "y",
              "usr_filter_key"=> null,
              "usr_home_filter_keys"=> null,
              "usr_home_sort_keys"=> null,
              "usr_url"=> null,
              "usr_activation"=> "n",
              "usr_deeplink_token"=> "",
              "usr_roles"=> '["sudo"]',
              "usr_jnl_standalone"=> null,
              "usr_image"=> "339.jpg",
              "usr_thumb_preference"=> "list",
              "usr_f_status"=> "n",
              "usr_terms_condition"=> "y",
              "usr_last_review_invite"=> null,
              "usr_orcid_response"=> null,
              "usr_reg_date"=> date('Y-m-d h:i:s'),
              "usr_reauthorised_date"=> null,
              "usr_mfa_token"=> null,
              "usr_alt_totps"=> null,
              "usr_gender"=> "t",
              "usr_ethnicity"=> '{"opt_val":"we"}',
              "usr_race"=> '{"opt_val":"ap"}',
              "usr_posted_by"=> 339,
              "usr_posted_date"=> date('Y-m-d h:i:s'),
              "usr_proxy_id"=> 0,
              "usr_operation"=> "u",
              "usr_orcid_id"=> null,
              "usr_orcid_token"=> null,
            ],
            "2" => [
              "usr_user_legacy_id"=> null,
              "usr_username"=> "ja1",
              "usr_pwd_original"=> "",
              "usr_pwd"=> '$2a$10$IiExah6A9nMFCVmbNtUmnOhoR3.XTfSQKztxCzDBHoAHE91EbKZva',
              "usr_title"=> "mr",
              "usr_first_name"=> "William",
              "usr_middle_name"=> null,
              "usr_last_name"=> "Jackson",
              "usr_email"=> "test610@reviewdemo.rivervalleytechnologies.com",
              "usr_website"=> null,
              "usr_twitter_id"=> null,
              "usr_github_id"=> null,
              "usr_dnd"=> "n",
              "usr_dnd_marketing"=> null,
              "usr_dnd_share_data"=> null,
              "usr_dnd_jnls"=> null,
              "usr_status"=> "a",
              "usr_institution"=> null,
              "usr_postal_code"=> null,
              "usr_phone_no"=> null,
              "usr_registered"=> "n",
              "usr_filter_key"=> null,
              "usr_home_filter_keys"=> null,
              "usr_home_sort_keys"=> null,
              "usr_url"=> "",
              "usr_activation"=> "n",
              "usr_deeplink_token"=> "",
              "usr_roles"=> '["admin"]',
              "usr_jnl_standalone"=> null,
              "usr_image"=> "1699266635_610.jpg",
              "usr_thumb_preference"=> "list",
              "usr_f_status"=> "n",
              "usr_terms_condition"=> "y",
              "usr_last_review_invite"=> date('Y-m-d h:i:s'),
              "usr_orcid_response"=> null,
              "usr_reg_date"=> date('Y-m-d h:i:s'),
              "usr_reauthorised_date"=> null,
              "usr_mfa_token"=> null,
              "usr_alt_totps"=> null,
              "usr_gender"=> "m",
              "usr_ethnicity"=> '{"opt_val":"we"}',
              "usr_race"=> '{"opt_val":"b"}',
              "usr_posted_by"=> 610,
              "usr_posted_date"=> date('Y-m-d h:i:s'),
              "usr_proxy_id"=> 0,
              "usr_operation"=> "u",
              "usr_orcid_id"=> null,
              "usr_orcid_token"=> null,
            ]
        ];
        User::insert($default_user_data);

        $file_pload_type = "INSERT INTO `rvw_file_upload_type` (`fut_id`, `fut_name`, `fut_extension`, `fut_posted_by`, `fut_posted_date`, `fut_proxy_id`, `fut_operation`) VALUES
        (1, 'zip', '.zip', 0, '2017-01-30 13:10:17', NULL, 'u'),
        (2, 'doc', '.doc', 0, '2017-01-30 13:10:17', NULL, 'u'),
        (3, 'docx', '.docx', 0, '2017-01-30 13:10:17', NULL, 'u'),
        (4, 'odt', '.odt', 0, '2017-01-30 13:10:17', NULL, 'u'),
        (5, 'jpg', '.jpg', 1, '2017-06-29 11:37:56', NULL, 'u'),
        (6, 'jpeg', '.jpeg', 0, '2017-01-30 13:10:17', NULL, 'u'),
        (7, 'png', '.png', 0, '2017-01-30 13:10:17', NULL, 'u'),
        (8, 'tex', '.tex', 0, '2017-01-30 13:10:17', NULL, 'u'),
        (9, 'pdf', '.pdf', 0, '2017-01-30 13:10:17', NULL, 'u'),
        (10, 'eps', '.eps', 1, '2017-01-31 14:34:39', NULL, 'u'),
        (11, 'ppt', '.ppt', 1, '2017-03-15 15:56:35', NULL, 'i'),
        (12, 'tiff', '.tiff', 339, '2020-08-17 10:47:01', NULL, 'i'),
        (13, 'xls', '.xls', 1, '2021-01-27 07:34:22', NULL, 'i'),
        (14, 'xlsx', '.xlsx', 1, '2021-01-27 07:34:52', NULL, 'i'),
        (15, 'bst', '.bst', 339, '2021-01-28 11:21:52', NULL, 'i'),
        (16, 'cls', '.cls', 339, '2021-01-28 11:22:10', NULL, 'i'),
        (17, 'bib', '.bib', 339, '2021-01-28 11:22:26', NULL, 'i'),
        (18, 'pptx', '.pptx', 339, '2021-02-09 14:00:27', NULL, 'i'),
        (19, 'tif', '.tif', 339, '2021-02-09 14:00:43', NULL, 'i'),
        (20, 'ai', '.ai', 339, '2021-05-10 12:30:33', NULL, 'i'),
        (21, 'xml', '.xml', 339, '2021-05-10 12:32:34', NULL, 'i'),
        (22, 'gif', '.gif', 339, '2021-05-18 15:24:33', NULL, 'i'),
        (23, 'suppl', '.suppl', 339, '2021-05-18 15:25:01', NULL, 'i'),
        (24, 'mov', '.mov', 339, '2021-05-18 15:25:22', NULL, 'i'),
        (25, 'mp4', '.mp4', 339, '2022-09-13 06:21:41', NULL, 'i'),
        (33, 'afile', '.afile', 1, '2023-06-22 09:49:18', 0, 'i');";

        DB::select($file_pload_type);

        $general_permission = "INSERT INTO `rvw_general_permissions` (`id`, `permission_route`, `permission_parent_route`, `permission_caption`, `permission_icon`, `permission_roles`, `permission_posted_by`, `permission_posted_date`, `permission_proxy_id`, `permission_operation`) VALUES
        (1, 'manage-permission', '', ' Admin permissions', 'user-md  ', '[\"super_admin\"]', 0, '0000-00-00 00:00:00', 0, 'u'),
        (2, 'journals', 'journals', ' Journals', 'book ', '[\"super_admin\", \"admin\"]', 1, '2023-12-05 13:36:05', 0, 'u'),
        (3, 'manage-users', 'manage-users', ' Users', 'users ', '[\"super_admin\", \"admin\"]', 1, '2023-06-09 15:09:23', 0, 'u'),
        (4, 'user-role', 'user-role', ' Roles', 'user-secret ', '[\"super_admin\"]', 1, '2023-06-09 17:56:46', 0, 'u'),
        (5, 'user-to-journal', 'user-to-journal', ' Users in Journals', 'user-plus ', '[\"super_admin\"]', 1, '2023-06-09 17:52:06', 0, 'u'),
        (6, 'generic-form', 'generic-form', ' Custom forms', 'clipboard ', '[\"super_admin\", \"admin\"]', 1, '2023-06-09 17:57:55', 0, 'u'),
        (7, 'email-templates', 'email-templates', ' Email templates', 'envelope ', '[\"super_admin\", \"admin\"]', 1, '2023-06-09 17:57:49', 0, 'u'),
        (8, 'manage-email-template-tags', 'manage-email-template-tags', 'Custom email tags', 'pencil-square-o', '[\"super_admin\", \"report_operator\"]', 1, '2023-06-09 17:53:28', 0, 'u'),
        (9, 'add-user', 'manage-users', '', ' ', '[\"\", \"super_admin\", \"admin\"]', 339, '2021-02-25 15:10:12', 0, 'u'),
        (10, 'edit-user', 'manage-users', '', NULL, '[\"\", \"super_admin\", \"admin\"]', 339, '2021-02-25 15:10:12', 0, 'u'),
        (11, 'journal-settings', 'journals', '', NULL, '[\"\", \"super_admin\"]', 1, '2017-07-10 13:02:24', 0, 'u'),
        (12, 'add-email', 'email-templates', '', NULL, '[\"\", \"super_admin\", \"report_operator\"]', 339, '2021-08-05 15:00:46', 0, 'u'),
        (13, 'edit-email', 'email-templates', '', NULL, '[\"\", \"super_admin\", \"report_operator\"]', 339, '2021-08-05 15:00:46', 0, 'u'),
        (14, 'add-stage-email', 'email-templates', '', NULL, '[\"\", \"super_admin\", \"report_operator\"]', 339, '2021-08-05 15:00:46', 0, 'u'),
        (15, 'edit-stage-email', 'email-templates', '', NULL, '[\"\", \"super_admin\", \"report_operator\"]', 339, '2021-08-05 15:00:46', 0, 'u'),
        (16, 'manage-flag', 'manage-flag', ' Flags', 'flag-checkered ', '[\"super_admin\", \"admin\"]', 1, '2023-06-09 17:58:02', 0, 'u'),
        (17, 'manage-file-upload-type', 'manage-file-upload-type', ' File upload', 'upload ', '[\"super_admin\"]', 1, '2023-06-09 17:51:14', 0, 'u'),
        (18, 'manage-file-descriptions', 'manage-file-descriptions', ' File descriptions', 'file-text-o ', '[\"super_admin\"]', 1, '2023-06-09 17:51:04', 0, 'u'),
        (19, 'manage-keywords', 'manage-keywords', ' Keywords', 'font', '[\"super_admin\"]', 1, '2023-06-09 17:56:26', 0, 'u'),
        (20, 'manage-reject-reason', 'manage-reject-reason', ' Reasons for rejection ', 'window-close-o', '[\"super_admin\"]', 1, '2023-06-09 17:56:34', 0, 'u'),
        (23, 'copyright-statement', 'copyright-statement', ' Copyright statement', 'copyright ', '[\"super_admin\"]', 1, '2023-06-09 17:57:18', 0, 'u'),
        (25, 'view-report', 'view-report', 'Reports', 'bar-chart ', '[\"super_admin\"]', 1, '2023-06-09 17:53:04', 0, 'u'),
        (26, 'casrai-credits', 'casrai-credits', 'Contributorship', 'credit-card ', '[\"super_admin\"]', 0, '2017-06-22 00:00:00', 0, 'u'),
        (27, 'define-summary-report', 'define-summary-report', '', '', '[\"\", \"super_admin\", \"admin\", \"report_operator\"]', 1, '2017-02-21 09:27:24', 0, 'u'),
        (28, 'cron-task', 'cron-task', 'Cron Task', 'tasks ', '[\"\", \"super_admin\"]', 1, '2017-09-15 09:22:00', 1, 'u'),
        (29, 'manage-rescind-request', 'manage-rescind-request', 'Rescind request', 'undo', '[\"super_admin\", \"admin\"]', 339, '2023-12-07 13:57:47', 0, 'u'),
        (30, 'discussion-type', 'discussion-type', 'Discussion type', 'comments-o', '[\"super_admin\"]', 1, '2023-06-09 17:52:22', 0, 'u'),
        (31, 'conferences', 'conferences', 'Conferences', 'book ', '[\"\", \"super_admin\"]', 1, '2023-07-10 13:02:24', 0, 'i'),
        (32, 'manage-ftp', 'manage-ftp', 'Manage Ftp', 'tasks ', '[\"\", \"super_admin\"]', 1, '2023-11-28 09:22:00', 1, 'u');";

        DB::select($general_permission);

        $general_settings = "INSERT INTO `rvw_general_settings` (`gnl_id`, `gnl_aff_markup`, `gnl_file_types`, `gnl_fundref`, `gnl_orcid`, `gnl_ithenticate`, `gnl_ringgold`, `gnl_rightslink`, `gnl_multi_client`, `gnl_debug_mode`, `gnl_under_maintenance`, `gnl_posted_by`, `gnl_posted_date`, `gnl_proxy_id`, `gnl_operation`) VALUES
        (1, '', '[\"jpg\",\"jpeg\",\"png\",\"pdf\"]', 'n', 'n', 'n', 'n', 'n', 'n', 'y', 'n', 339, '2023-10-11 16:20:11', 0, 'u');";

        DB::select($general_settings);

        $copy_right_master1 = "INSERT INTO `rvw_copyright_master` (`crtm_id`, `crtm_license_name`, `crtm_payment`, `crtm_amount`, `crtm_license_details`, `crtm_license_content`, `crtm_posted_by`, `crtm_posted_date`, `crtm_proxy_id`, `crtm_operation`) VALUES
        (1, 'ICE Publishing', 't', 0, 'This option assigns the copyright to  the publisher. Once published, the paper will be available to subscribers of the journal. There is no processing charge for this option.', '<p><img src=\"https://ice-rvtesting.rivervalleytechnologies.com/assets/images/client_log/ice_publishing_logo.png\" alt=\"ICE Publishing\" width=\"100\" height=\"103\" /></p>\r\n<p><span style=\"font-size: 18pt;\"><strong>Journal Publishing Agreement</strong></span></p>\r\n<p><br /><span style=\"font-size: 10pt;\">It is our policy to ask authors to assign the copyright of articles accepted for publication to the Publisher. Exceptions are possible for reasons of national rules or funding.</span></p>\r\n<p><br /><span style=\"font-size: 10pt;\">In assigning copyright to us, you retain all proprietary rights including patent rights, and the right to make personal (non-commercial) use of the article, subject to acknowledgment of the journal as the original source of publication. </span></p>\r\n<p><span style=\"font-size: 10pt;\">By signing this agreement, you are confirming that you have obtained permission from any co-authors and advised them of this copyright transfer. Kindly note that copyright transfer is not applicable to authors who are opting to publish their papers as Open Access. </span></p>\r\n<p> </p>\r\n<p><span style=\"font-size: 10pt;\">I, the lead author and rights owner of the Content, require a Crown Copyright Publication Agreement or another form of Agreement and have contacted the ICE Publishing editorial office to obtain, sign and submit a printed copy of the same.</span></p>\r\n<p> </p>\r\n<p>Journal name: %journal_name%</p>\r\n<p>Article Title: %article_title%<br />Manuscript reference number: %manuscript_id%<br />Authors: %author_name%<br />Signature and date: %copyright_date%</p>\r\n<p><span style=\"font-size: 10pt;\"> </span></p>\r\n<p> </p>', 339, '2021-10-28 11:12:03', 0, 'u'),
        (2, 'CC BY', 'o', 0, 'Creative Commons Attribution (CC BY): this is the most accommodating of licences offered. It lets others distribute, remix, tweak, and build upon your work, even commercially, as long as they credit you for the original creation. (If your work is funded by The Wellcome Trust or Research Councils UK you must use this licence.)', '<p><img src=\"https://ice-rvtesting.rivervalleytechnologies.com/assets/images/client_log/ice_publishing_logo.png\" alt=\"ICE Publishing\" width=\"100\" height=\"103\" /></p>\r\n<h1 style=\"font-family: \'Times New Roman\';\">Journals Publication Agreement and Open Access Licence Agreement</h1>\r\n<h2 style=\"font-family: \'Times New Roman\';\"><strong><em>Creative Commons Attribution CC BY Licence</em></strong></h2>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\">THE WORK (AS DEFINED BELOW) IS PROVIDED UNDER THE TERMS OF THIS CREATIVE COMMONS PUBLIC LICENSE (&ldquo;CCPL&rdquo; OR &ldquo;LICENSE&rdquo;). THE WORK IS PROTECTED BY COPYRIGHT AND/OR OTHER APPLICABLE LAW. ANY USE OF THE WORK OTHER THAN AS AUTHORIZED UNDER THIS LICENSE OR COPYRIGHT LAW IS PROHIBITED.</p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\">BY EXERCISING ANY RIGHTS TO THE WORK PROVIDED HERE, YOU ACCEPT AND AGREE TO BE BOUND BY THE TERMS OF THIS LICENSE. TO THE EXTENT THIS LICENSE MAY BE CONSIDERED TO BE A CONTRACT, THE LICENSOR GRANTS YOU THE RIGHTS CONTAINED HERE IN CONSIDERATION OF YOUR ACCEPTANCE OF SUCH TERMS AND CONDITIONS.</p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\"><strong>1. Definitions</strong></p>\r\n<ol style=\"font-family: \'Times New Roman\'; font-size: medium;\" type=\"a\">\r\n<li><strong>&ldquo;Adaptation&rdquo;</strong>&nbsp;means a work based upon the Work, or upon the Work and other pre-existing works, such as a translation, adaptation, derivative work, arrangement of music or other alterations of a literary or artistic work, or phonogram or performance and includes cinematographic adaptations or any other form in which the Work may be recast, transformed, or adapted including in any form recognizably derived from the original, except that a work that constitutes a Collection will not be considered an Adaptation for the purpose of this License. For the avoidance of doubt, where the Work is a musical work, performance or phonogram, the synchronization of the Work in timed-relation with a moving image (&ldquo;synching&rdquo;) will be considered an Adaptation for the purpose of this License.</li>\r\n<li><strong>&ldquo;Collection&rdquo;</strong>&nbsp;means a collection of literary or artistic works, such as encyclopedias and anthologies, or performances, phonograms or broadcasts, or other works or subject matter other than works listed in Section 1(f) below, which, by reason of the selection and arrangement of their contents, constitute intellectual creations, in which the Work is included in its entirety in unmodified form along with one or more other contributions, each constituting separate and independent works in themselves, which together are assembled into a collective whole. A work that constitutes a Collection will not be considered an Adaptation (as defined above) for the purposes of this License.</li>\r\n<li><strong>&ldquo;Distribute&rdquo;</strong>&nbsp;means to make available to the public the original and copies of the Work or Adaptation, as appropriate, through sale or other transfer of ownership.</li>\r\n<li><strong>&ldquo;Licensor&rdquo;</strong>&nbsp;means the individual, individuals, entity or entities that offer(s) the Work under the terms of this License.</li>\r\n<li><strong>&ldquo;Original Author&rdquo;</strong>&nbsp;means, in the case of a literary or artistic work, the individual, individuals, entity or entities who created the Work or if no individual or entity can be identified, the publisher; and in addition (i) in the case of a performance the actors, singers, musicians, dancers, and other persons who act, sing, deliver, declaim, play in, interpret or otherwise perform literary or artistic works or expressions of folklore; (ii) in the case of a phonogram the producer being the person or legal entity who first fixes the sounds of a performance or other sounds; and, (iii) in the case of broadcasts, the organization that transmits the broadcast.</li>\r\n<li><strong>&ldquo;Work&rdquo;</strong>&nbsp;means the literary and/or artistic work offered under the terms of this License including without limitation any production in the literary, scientific and artistic domain, whatever may be the mode or form of its expression including digital form, such as a book, pamphlet and other writing; a lecture, address, sermon or other work of the same nature; a dramatic or dramatico-musical work; a choreographic work or entertainment in dumb show; a musical composition with or without words; a cinematographic work to which are assimilated works expressed by a process analogous to cinematography; a work of drawing, painting, architecture, sculpture, engraving or lithography; a photographic work to which are assimilated works expressed by a process analogous to photography; a work of applied art; an illustration, map, plan, sketch or three-dimensional work relative to geography, topography, architecture or science; a performance; a broadcast; a phonogram; a compilation of data to the extent it is protected as a copyrightable work; or a work performed by a variety or circus performer to the extent it is not otherwise considered a literary or artistic work.</li>\r\n<li><strong>&ldquo;You&rdquo;</strong>&nbsp;means an individual or entity exercising rights under this License who has not previously violated the terms of this License with respect to the Work, or who has received express permission from the Licensor to exercise rights under this License despite a previous violation.</li>\r\n<li><strong>&ldquo;Publicly Perform&rdquo;</strong>&nbsp;means to perform public recitations of the Work and to communicate to the public those public recitations, by any means or process, including by wire or wireless means or public digital performances; to make available to the public Works in such a way that members of the public may access these Works from a place and at a place individually chosen by them; to perform the Work to the public by any means or process and the communication to the public of the performances of the Work, including by public digital performance; to broadcast and rebroadcast the Work by any means including signs, sounds or images.</li>\r\n<li><strong>&ldquo;Reproduce&rdquo;</strong>&nbsp;means to make copies of the Work by any means including without limitation by sound or visual recordings and the right of fixation and reproducing fixations of the Work, including storage of a protected performance or phonogram in digital form or other electronic medium.</li>\r\n</ol>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\">&nbsp;</p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\"><strong>2. Fair Dealing Rights.</strong>&nbsp;Nothing in this License is intended to reduce, limit, or restrict anyuses free from copyright or rights arising from limitations or exceptions that are provided for in connection with the copyright protection under copyright law or other applicable laws.</p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\"><strong>3. License Grant.</strong>&nbsp;Subject to the terms and conditions of this License, Licensor hereby grants You a worldwide, royalty-free, non-exclusive, perpetual (for the duration of the applicable copyright) license to exercise the rights in the Work as stated below:</p>\r\n<ol style=\"font-family: \'Times New Roman\'; font-size: medium;\" type=\"a\">\r\n<li>to Reproduce the Work, to incorporate the Work into one or more Collections, and to Reproduce the Work as incorporated in the Collections;</li>\r\n<li>to create and Reproduce Adaptations provided that any such Adaptation, including any translation in any medium, takes reasonable steps to clearly label, demarcate or otherwise identify that changes were made to the original Work. For example, a translation could be marked &ldquo;The original work was translated from English to Spanish,&rdquo; or a modification could indicate &ldquo;The original work has been modified.&rdquo;;</li>\r\n<li>to Distribute and Publicly Perform the Work including as incorporated in Collections; and,</li>\r\n<li>to Distribute and Publicly Perform Adaptations.</li>\r\n<li>For the avoidance of doubt:\r\n<ol type=\"i\">\r\n<li><strong>Non-waivable Compulsory License Schemes</strong>. In those jurisdictions in which the right to collect royalties through any statutory or compulsory licensing scheme cannot be waived, the Licensor reserves the exclusive right to collect such royalties for any exercise by You of the rights granted under this License;</li>\r\n<li><strong>Waivable Compulsory License Schemes</strong>. In those jurisdictions in which the right to collect royalties through any statutory or compulsory licensing scheme can be waived, the Licensor waives the exclusive right to collect such royalties for any exercise by You of the rights granted under this License; and,</li>\r\n<li><strong>Voluntary License Schemes</strong>. The Licensor waives the right to collect royalties, whether individually or, in the event that the Licensor is a member of a collecting society that administers voluntary licensing schemes, via that society, from any exercise by You of the rights granted under this License.</li>\r\n</ol>\r\n</li>\r\n</ol>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\">&nbsp;</p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\">The above rights may be exercised in all media and formats whether now known or hereafter devised. The above rights include the right to make such modifications as are technically necessary to exercise the rights in other media and formats. Subject to Section 8(f), all rights not expressly granted by Licensor are hereby reserved.</p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\"><strong>4. Restrictions.</strong>&nbsp;The license granted in Section 3 above is expressly made subject to and limited by the following restrictions:</p>\r\n<ol style=\"font-family: \'Times New Roman\'; font-size: medium;\" type=\"a\">\r\n<li>You may Distribute or Publicly Perform the Work only under the terms of this License. You must include a copy of, or the Uniform Resource Identifier (URI) for, this License with every copy of the Work You Distribute or Publicly Perform. You may not offer or impose any terms on the Work that restrict the terms of this License or the ability of the recipient of the Work to exercise the rights granted to that recipient under the terms of the License. You may not sublicense the Work. You must keep intact all notices that refer to this License and to the disclaimer of warranties with every copy of the Work You Distribute or Publicly Perform. When You Distribute or Publicly Perform the Work, You may not impose any effective technological measures on the Work that restrict the ability of a recipient of the Work from You to exercise the rights granted to that recipient under the terms of the License. This Section 4(a) applies to the Work as incorporated in a Collection, but this does not require the Collection apart from the Work itself to be made subject to the terms of this License. If You create a Collection, upon notice from any Licensor You must, to the extent practicable, remove from the Collection any credit as required by Section 4(b), as requested. If You create an Adaptation, upon notice from any Licensor You must, to the extent practicable, remove from the Adaptation any credit as required by Section 4(b), as requested.</li>\r\n<li>If You Distribute, or Publicly Perform the Work or any Adaptations or Collections, You must, unless a request has been made pursuant to Section 4(a), keep intact all copyright notices for the Work and provide, reasonable to the medium or means You are utilizing: (i) the name of the Original Author (or pseudonym, if applicable) if supplied, and/or if the Original Author and/or Licensor designate another party or parties (e.g., a sponsor institute, publishing entity, journal) for attribution (&ldquo;Attribution Parties&rdquo;) in Licensor\'s copyright notice, terms of service or by other reasonable means, the name of such party or parties; (ii) the title of the Work if supplied; (iii) to the extent reasonably practicable, the URI, if any, that Licensor specifies to be associated with the Work, unless such URI does not refer to the copyright notice or licensing information for the Work; and (iv) , consistent with Section 3(b), in the case of an Adaptation, a credit identifying the use of the Work in the Adaptation (e.g., &ldquo;French translation of the Work by Original Author,&rdquo; or &ldquo;Screenplay based on original Work by Original Author&rdquo;). The credit required by this Section 4 (b) may be implemented in any reasonable manner; provided, however, that in the case of a Adaptation or Collection, at a minimum such credit will appear, if a credit for all contributing authors of the Adaptation or Collection appears, then as part of these credits and in a manner at least as prominent as the credits for the other contributing authors. For the avoidance of doubt, You may only use the credit required by this Section for the purpose of attribution in the manner set out above and, by exercisingYour rights under this License, You may not implicitly or explicitly assert or imply any connection with, sponsorship or endorsement by the Original Author, Licensor and/or Attribution Parties, as appropriate, of You or Your use of the Work, without the separate, express prior written permission of the Original Author, Licensor and/or Attribution Parties.</li>\r\n<li>Except as otherwise agreed in writing by the Licensor or as may be other wisepermitted by applicable law, if You Reproduce, Distribute or Publicly Perform the Work either by itself or as part of any Adaptations or Collections, You must not distort, mutilate, modify or take other derogatory action in relation to the Work which would be prejudicial to the Original Author\'s honor or reputation. Licensor agrees that in those jurisdictions (e.g. Japan), in which any exercise of the right granted in Section 3(b) of this License (the right to make Adaptations) would be deemed to be a distortion, mutilation, modification or other derogatory action prejudicial to the Original Author\'s honor and reputation, the Licensor will waive or not assert, as appropriate, this Section, to the fullest extent permitted by the applicable national law, to enable You to reasonably exercise Your right under Section 3(b) of this License (right to make Adaptations) but not otherwise.</li>\r\n</ol>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\">&nbsp;</p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\"><strong>5. Representations, Warranties and Disclaimer</strong></p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\">UNLESS OTHERWISE MUTUALLY AGREED TO BY THE PARTIES IN WRITING, LICENSOR OFFERS THE WORK AS-IS AND MAKES NO REPRESENTATIONS OR WARRANTIES OF ANY KIND CONCERNING THE WORK, EXPRESS, IMPLIED, STATUTORY OR OTHERWISE, INCLUDING, WITHOUT LIMITATION, WARRANTIES OF TITLE, MERCHANTIBILITY, FITNESS FOR A PARTICULAR PURPOSE, NONINFRINGEMENT, OR THE ABSENCE OF LATENT OR OTHER DEFECTS, ACCURACY, OR THE PRESENCE OF ABSENCE OF ERRORS, WHETHER OR NOT DISCOVERABLE. SOME JURISDICTIONS DO NOT ALLOW THE EXCLUSION OF IMPLIED WARRANTIES, SO SUCH EXCLUSION MAY NOT APPLY TO YOU.</p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\"><strong>6. Limitation on Liability.</strong>&nbsp;EXCEPT TO THE EXTENT REQUIRED BY APPLICABLE LAW, IN NO EVENT WILL LICENSOR BE LIABLE TO YOU ON ANY LEGAL THEORY FOR ANY SPECIAL, INCIDENTAL, CONSEQUENTIAL, PUNITIVE OR EXEMPLARY DAMAGES ARISING OUT OF THIS LICENSE OR THE USE OF THE WORK, EVEN IF LICENSOR HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.</p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\"><strong>7. Termination</strong></p>\r\n<ol style=\"font-family: \'Times New Roman\'; font-size: medium;\" type=\"a\">\r\n<li>This License and the rights granted hereunder will terminate automatically upon any breach by You of the terms of this License. Individuals or entities who have received Adaptations or Collections from You under this License, however, will not have their licenses terminated provided such individuals or entities remain in full compliance with those licenses. Sections 1, 2, 5, 6, 7, and 8 will survive any termination of this License.</li>\r\n<li>Subject to the above terms and conditions, the license granted here is perpetual (for the duration of the applicable copyright in the Work). Notwithstanding the above, Licensor reserves the right to release the Work under different license terms or to stop distributing the Work at any time; provided, however that any such election will not serve to withdraw this License (or any other license that has been, or is required to be, granted under the terms of this License), and this License will continue in full force and effect unless terminated as stated above.</li>\r\n</ol>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\">&nbsp;</p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\"><strong>8. Miscellaneous</strong></p>\r\n<ol style=\"font-family: \'Times New Roman\'; font-size: medium;\" type=\"a\">\r\n<li>Each time You Distribute or Publicly Perform the Work or a Collection, the Licensor offers to the recipient a license to the Work on the same terms and conditions as the license granted to You under this License.</li>\r\n<li>Each time You Distribute or Publicly Perform an Adaptation, Licensor offers to the recipient a license to the original Work on the same terms and conditions as the license granted to You under this License.</li>\r\n<li>If any provision of this License is invalid or unenforceable under applicable law, it shall not affect the validity or enforceability of the remainder of the terms of this License, and without further action by the parties to this agreement, such provision shall be reformed to the minimum extent necessary to make such provision valid and enforceable.</li>\r\n<li>No term or provision of this License shall be deemed waived and no breach consented to unless such waiver or consent shall be in writing and signed by the party to be charged with such waiver or consent.</li>\r\n<li>This License constitutes the entire agreement between the parties with respect to the Work licensed here. There are no understandings, agreements or representations with respect to the Work not specified here. Licensor shall not be bound by any additional provisions that may appear in any communication from You. This License may not be modified without the mutual written agreement of the Licensor and You.</li>\r\n<li>The rights granted under, and the subject matter referenced, in this License were drafted utilizing the terminology of the Berne Convention for the Protection of Literary and Artistic Works (as amended on September 28, 1979), the Rome Convention of 1961, the WIPO Copyright Treaty of 1996, the WIPO Performances and Phonograms Treaty of 1996 and the Universal Copyright Convention (as revised on July 24, 1971). These rights and subject matter take effect in the relevant jurisdiction in which the License terms are sought to be enforced according to the corresponding provisions of the implementation of those treaty provisions in the applicable national law. If the standard suite of rights granted under applicable copyright law includes additional rights not granted under this License, such additional rights are deemed to be included in the License; this License is not intended to restrict the license of any rights under applicable law.</li>\r\n</ol>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\">&nbsp;</p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\"><strong><em>Creative Commons Attribution CC BY Licence</em></strong></p>\r\n<p>&nbsp;</p>\r\n<p style=\"color: #000000; font-family: \'Times New Roman\'; font-size: medium; font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; font-weight: normal; letter-spacing: normal; orphans: 2; text-align: start; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-stroke-width: 0px;\">I, on behalf of myself and my co-authors agree to the publication of the submitted content under this type of Creative Commons Attribution licence. This licence lets others distribute, remix, tweak, and build upon your work, even commercially, as long as they credit you for the original creation. This is the most accommodating of licences offered. Recommended for maximum dissemination and use of licenced materials. (If your work is funded by The Wellcome Trust or Research Councils UK you must use this licence.)</p>\r\n<p style=\"color: #000000; font-family: \'Times New Roman\'; font-size: medium; font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; font-weight: normal; letter-spacing: normal; orphans: 2; text-align: start; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-stroke-width: 0px;\">Journal Name: %journal_name%</p>\r\n<p style=\"color: #000000; font-family: \'Times New Roman\'; font-size: medium; font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; font-weight: normal; letter-spacing: normal; orphans: 2; text-align: start; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-stroke-width: 0px;\">Manuscript ID:&nbsp;%manuscript_id%</p>\r\n<p style=\"color: #000000; font-family: \'Times New Roman\'; font-size: medium; font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; font-weight: normal; letter-spacing: normal; orphans: 2; text-align: start; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-stroke-width: 0px;\">Paper Title: %article_title%</p>\r\n<p style=\"color: #000000; font-family: \'Times New Roman\'; font-size: medium; font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; font-weight: normal; letter-spacing: normal; orphans: 2; text-align: start; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-stroke-width: 0px;\">Name: %author_name%</p>\r\n<p style=\"color: #000000; font-family: \'Times New Roman\'; font-size: medium; font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; font-weight: normal; letter-spacing: normal; orphans: 2; text-align: start; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-stroke-width: 0px;\">Date:&nbsp;%copyright_date%</p>', 339, '2021-10-11 08:01:10', 0, 'u'),
        (3, 'CC BY-ND', 'o', 0, 'Creative Commons Attribution-NoDerivs (CC BY-ND) This licence allows for redistribution, commercial and non-commercial, as long as it is passed along unchanged and in whole, with credit to you.', '<p>&nbsp;</p>\r\n<h1 style=\"font-family: \'Times New Roman\';\">Journals Publication Agreement and Open Access Licence Agreement</h1>\r\n<h2 style=\"font-family: \'Times New Roman\';\"><strong><em>Creative Commons Attribution-NoDerivs CC BY-ND Licence</em></strong></h2>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\">THE WORK (AS DEFINED BELOW) IS PROVIDED UNDER THE TERMS OF THIS CREATIVE COMMONS PUBLIC LICENSE (&ldquo;CCPL&rdquo; OR &ldquo;LICENSE&rdquo;). THE WORK IS PROTECTED BY COPYRIGHT AND/OR OTHER APPLICABLE LAW. ANY USE OF THE WORK OTHER THAN AS AUTHORIZED UNDER THIS LICENSE OR COPYRIGHT LAW IS PROHIBITED.</p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\">BY EXERCISING ANY RIGHTS TO THE WORK PROVIDED HERE, YOU ACCEPT AND AGREE TO BE BOUND BY THE TERMS OF THIS LICENSE. TO THE EXTENT THIS LICENSE MAY BE CONSIDERED TO BE A CONTRACT, THE LICENSOR GRANTS YOU THE RIGHTS CONTAINED HERE IN CONSIDERATION OF YOUR ACCEPTANCE OF SUCH TERMS AND CONDITIONS.</p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\"><strong>1. Definitions</strong></p>\r\n<ol style=\"font-family: \'Times New Roman\'; font-size: medium;\" type=\"a\">\r\n<li><strong>&ldquo;Adaptation&rdquo;</strong>&nbsp;means a work based upon the Work, or upon the Work and other pre-existing works, such as a translation, adaptation, derivative work, arrangement of music or other alterations of a literary or artistic work, or phonogram or performance and includes cinematographic adaptations or any other form in which the Work may be recast, transformed, or adapted including in any form recognizably derived from the original, except that a work that constitutes a Collection will not be considered an Adaptation for the purpose of this License. For the avoidance of doubt, where the Work is a musical work, performance or phonogram, the synchronization of the Work in timed-relation with a moving image (&ldquo;synching&rdquo;) will be considered an Adaptation for the purpose of this License.</li>\r\n<li><strong>&ldquo;Collection&rdquo;</strong>&nbsp;means a collection of literary or artistic works, such as encyclopedias and anthologies, or performances, phonograms or broadcasts, or other works or subject matter other than works listed in Section 1(f) below, which, by reason of the selection and arrangement of their contents, constitute intellectual creations, in which the Work is included in its entirety in unmodified form along with one or more other contributions, each constituting separate and independent works in themselves, which together are assembled into a collective whole. A work that constitutes a Collection will not be considered an Adaptation (as defined above) for the purposes of this License.</li>\r\n<li><strong>&ldquo;Distribute&rdquo;</strong>&nbsp;means to make available to the public the original and copies of the Work through sale or other transfer of ownership.</li>\r\n<li><strong>&ldquo;Licensor&rdquo;</strong>&nbsp;means the individual, individuals, entity or entities that offer(s) the Work under the terms of this License.</li>\r\n<li><strong>&ldquo;Original Author&rdquo;</strong>&nbsp;means, in the case of a literary or artistic work, the individual, individuals, entity or entities who created the Work or if no individual or entity can be identified, the publisher; and in addition (i) in the case of a performance the actors, singers, musicians, dancers, and other persons who act, sing, deliver, declaim, play in, interpret or otherwise perform literary or artistic works or expressions of folklore; (ii) in the case of a phonogram the producer being the person or legal entity who first fixes the sounds of a performance or other sounds; and, (iii) in the case of broadcasts, the organization that transmits the broadcast.</li>\r\n<li><strong>&ldquo;Work&rdquo;</strong>&nbsp;means the literary and/or artistic work offered under the terms of this License including without limitation any production in the literary, scientific and artistic domain, whatever may be the mode or form of its expression including digital form, such as a book, pamphlet and other writing; a lecture, address, sermon or other work of the same nature; a dramatic or dramatico-musical work; a choreographic work or entertainment in dumb show; a musical composition with or without words; a cinematographic work to which are assimilated works expressed by a process analogous to cinematography; a work of drawing, painting, architecture, sculpture, engraving or lithography; a photographic work to which are assimilated works expressed by a process analogous to photography; a work of applied art; an illustration, map, plan, sketch or three-dimensional work relative to geography, topography, architecture or science; a performance; a broadcast; a phonogram; a compilation of data to the extent it is protected as a copyrightable work; or a work performed by a variety or circus performer to the extent it is not otherwise considered a literary or artistic work.</li>\r\n<li><strong>&ldquo;You&rdquo;</strong>&nbsp;means an individual or entity exercising rights under this License who has not previously violated the terms of this License with respect to the Work, or who has received express permission from the Licensor to exercise rights under this License despite a previous violation.</li>\r\n<li><strong>&ldquo;Publicly Perform&rdquo;</strong>&nbsp;means to perform public recitations of the Work and to communicate to the public those public recitations, by any means or process, including by wire or wireless means or public digital performances; to make available to the public Works in such a way that members of the public may access these Works from a place and at a place individually chosen by them; to perform the Work to the public by any means or process and the communication to the public of the performances of the Work, including by public digital performance; to broadcast and rebroadcast the Work by any means including signs, sounds or images.</li>\r\n<li><strong>&ldquo;Reproduce&rdquo;</strong>&nbsp;means to make copies of the Work by any means including without limitation by sound or visual recordings and the right of fixation and reproducing fixations of the Work, including storage of a protected performance or phonogram in digital form or other electronic medium.</li>\r\n</ol>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\">&nbsp;</p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\"><strong>2. Fair Dealing Rights.</strong>&nbsp;Nothing in this License is intended to reduce, limit, or restrict any uses free from copyright or rights arising from limitations or exceptions that are provided for in connection with the copyright protection under copyright law or other applicable laws.</p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\"><strong>3. License Grant.</strong>&nbsp;Subject to the terms and conditions of this License, Licensor hereby grants You a worldwide, royalty-free, non-exclusive, perpetual (for the duration of the applicable copyright) license to exercise the rights in the Work as stated below:</p>\r\n<ol style=\"font-family: \'Times New Roman\'; font-size: medium;\" type=\"a\">\r\n<li>to Reproduce the Work, to incorporate the Work into one or more Collections, and to Reproduce the Work as incorporated in the Collections; and,</li>\r\n<li>to Distribute and Publicly Perform the Work including as incorporated in Collections.</li>\r\n<li>For the avoidance of doubt:\r\n<ol type=\"i\">\r\n<li><strong>Non-waivable Compulsory License Schemes.</strong>&nbsp;In those jurisdictions in which the right to collect royalties through any statutory or compulsory licensing scheme cannot be waived, the Licensor reserves the exclusive right to collect such royalties for any exercise by You of the rights granted under this License;</li>\r\n<li><strong>Waivable Compulsory License Schemes.</strong>&nbsp;In those jurisdictions in which the right to collect royalties through any statutory or compulsory licensing scheme can be waived, the Licensor waives the exclusive right to collect such royalties for any exercise by You of the rights granted under this License; and,</li>\r\n<li><strong>Voluntary License Schemes.</strong>&nbsp;The Licensor waives the right to collect royalties, whether individually or, in the event that the Licensor is a member of a collecting society that administers voluntary licensing schemes, via that society, from any exercise by You of the rights granted under this License.</li>\r\n</ol>\r\n</li>\r\n</ol>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\">&nbsp;</p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\">The above rights may be exercised in all media and formats whether now known or hereafter devised. The above rights include the right to make such modifications as are technically necessary to exercise the rights in other media and formats, but otherwise you have no rights to make Adaptations. Subject to Section 8(f), all rights not expressly granted by Licensor are hereby reserved.</p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\"><strong>4. Restrictions.</strong>&nbsp;The license granted in Section 3 above is expressly made subject to and limited by the following restrictions:</p>\r\n<ol style=\"font-family: \'Times New Roman\'; font-size: medium;\" type=\"a\">\r\n<li>You may Distribute or Publicly Perform the Work only under the terms of this License. You must include a copy of, or the Uniform Resource Identifier (URI) for, this License with every copy of the Work You Distribute or Publicly Perform. You may not offer or impose any terms on the Work that restrict the terms of this License or the ability of the recipient of the Work to exercise the rights granted to that recipient under the terms of the License. You may not sublicense the Work. You must keep intact all notices that refer to this License and to the disclaimer of warranties with every copy of the Work You Distribute or Publicly Perform. When You Distribute or Publicly Perform the Work, You may not impose any effective technological measures on the Work that restrict the ability of a recipient of the Work from You to exercise the rights granted to that recipient under the terms of the License. This Section 4(a) applies to the Work as incorporated in a Collection, but this does not require the Collection apart from the Work itself to be made subject to the terms of this License. If You create a Collection, upon notice from any Licensor You must, to the extent practicable, remove from the Collection any credit as required by Section 4(b), as requested.</li>\r\n<li>If You Distribute, or Publicly Perform the Work or Collections, You must, unless a request has been made pursuant to Section 4(a), keep intact all copyright notices for the Work and provide, reasonable to the medium or means You are utilizing: (i) the name of the Original Author (or pseudonym, if applicable) if supplied, and/or if the Original Author and/or Licensor designate another party or parties (e.g., a sponsor institute, publishing entity, journal) for attribution (&ldquo;Attribution Parties&rdquo;) in Licensor\'s copyright notice, terms of service or by other reasonable means, the name of such party or parties; (ii) the title of the Work if supplied; (iii) to the extent reasonably practicable, the URI, if any, that Licensor specifies to be associated with the Work, unless such URI does not refer to the copyright notice or licensing information for the Work. The credit required by this Section 4(b) may be implemented in any reasonable manner; provided, however, that in the case of a Collection, at a minimum such credit will appear, if a credit for all contributing authors of the Collection appears, then as part of these credits and in a manner at least as prominent as the credits for the other contributing authors. For the avoidance of doubt, You may only use the credit required by this Section for the purpose of attribution in the manner set out above and, by exercising Your rights under this License, You may not implicitly or explicitly assert or imply any connection with, sponsorship or endorsement by the Original Author, Licensor and/or Attribution Parties, as appropriate, of You or Your use of the Work, without the separate, express prior written permission of the Original Author, Licensor and/or Attribution Parties.</li>\r\n<li>Except as otherwise agreed in writing by the Licensor or as may be otherwise permitted by applicable law, if You Reproduce, Distribute or Publicly Perform the Work either by itself or as part of any Collections, You must not distort, mutilate, modify or take other derogatory action in relation to the Work which would be prejudicial to the Original Author\'s honor or reputation.</li>\r\n</ol>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\">&nbsp;</p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\"><strong>5. Representations, Warranties and Disclaimer</strong></p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\">UNLESS OTHERWISE MUTUALLY AGREED TO BY THE PARTIES IN WRITING, LICENSOR OFFERS THE WORK AS-IS AND MAKES NO REPRESENTATIONS OR WARRANTIES OF ANY KIND CONCERNING THE WORK, EXPRESS, IMPLIED, STATUTORY OR OTHERWISE, INCLUDING, WITHOUT LIMITATION, WARRANTIES OF TITLE, MERCHANTIBILITY, FITNESS FOR A PARTICULAR PURPOSE, NONINFRINGEMENT, OR THE ABSENCE OF LATENT OR OTHER DEFECTS, ACCURACY, OR THE PRESENCE OF ABSENCE OF ERRORS, WHETHER OR NOT DISCOVERABLE. SOME JURISDICTIONS DO NOT ALLOW THE EXCLUSION OF IMPLIED WARRANTIES, SO SUCH EXCLUSION MAY NOT APPLY TO YOU.</p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\"><strong>6. Limitation on Liability.</strong>&nbsp;EXCEPT TO THE EXTENT REQUIRED BY APPLICABLE LAW, IN NO EVENT WILL LICENSOR BE LIABLE TO YOU ON ANY LEGAL THEORY FOR ANY SPECIAL, INCIDENTAL, CONSEQUENTIAL, PUNITIVE OR EXEMPLARY DAMAGES ARISING OUT OF THIS LICENSE OR THE USE OF THE WORK, EVEN IF LICENSOR HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.</p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\"><strong>7. Termination</strong></p>\r\n<ol style=\"font-family: \'Times New Roman\'; font-size: medium;\" type=\"a\">\r\n<li>This License and the rights granted hereunder will terminate automatically upon any breach by You of the terms of this License. Individuals or entities who have received Collections from You under this License, however, will not have their licenses terminated provided such individuals or entities remain in full compliance with those licenses. Sections 1, 2, 5, 6, 7, and 8 will survive any termination of this License.</li>\r\n<li>Subject to the above terms and conditions, the license granted here is perpetual (for the duration of the applicable copyright in the Work). Notwithstanding the above, Licensor reserves the right to release the Work under different license terms or to stop distributing the Work at any time; provided, however that any such election will not serve to withdraw this License (or any other license that has been, or is required to be, granted under the terms of this License), and this License will continue in full force and effect unless terminated as stated above.</li>\r\n</ol>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\">&nbsp;</p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\"><strong>8. Miscellaneous</strong></p>\r\n<ol style=\"font-family: \'Times New Roman\'; font-size: medium;\" type=\"a\">\r\n<li>Each time You Distribute or Publicly Perform the Work or a Collection, the Licensor offers to the recipient a license to the Work on the same terms and conditions as the license granted to You under this License.</li>\r\n<li>If any provision of this License is invalid or unenforceable under applicable law, it shall not affect the validity or enforceability of the remainder of the terms of this License, and without further action by the parties to this agreement, such provision shall be reformed to the minimum extent necessary to make such provision valid and enforceable.</li>\r\n<li>No term or provision of this License shall be deemed waived and no breach consented to unless such waiver or consent shall be in writing and signed by the party to be charged with such waiver or consent.</li>\r\n<li>This License constitutes the entire agreement between the parties with respect to the Work licensed here. There are no understandings, agreements or representations with respect to the Work not specified here. Licensor shall not be bound by any additional provisions that may appear in any communication from You. This License may not be modified without the mutual written agreement of the Licensor and You.</li>\r\n<li>The rights granted under, and the subject matter referenced, in this License were drafted utilizing the terminology of the Berne Convention for the Protection of Literary and Artistic Works (as amended on September 28, 1979), the Rome Convention of 1961, the WIPO Copyright Treaty of 1996, the WIPO Performances and Phonograms Treaty of 1996 and the Universal Copyright Convention (as revised on July 24, 1971). These rights and subject matter take effect in the relevant jurisdiction in which the License terms are sought to be enforced according to the corresponding provisions of the implementation of those treaty provisions in the applicable national law. If the standard suite of rights granted under applicable copyright law includes additional rights not granted under this License, such additional rights are deemed to be included in the License; this License is not intended to restrict the license of any rights under applicable law.</li>\r\n</ol>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\">&nbsp;</p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\"><strong><em>Creative Commons Attribution-NoDerivs CC BY-ND Licence</em></strong></p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\">I, on behalf of myself and my co-authors agree to the publication of the submitted content under this type of Creative Commons Attribution licence. This licence allows for redistribution, commercial and non-commercial, as long as it is passed along unchanged and in whole, with credit to you.</p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\">Journal Name: %journal_name%</p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\">Manuscript ID:&nbsp;%manuscript_id%</p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\">Paper Title:&nbsp;%article_title%</p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\">Name:&nbsp;%author_name%</p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\">Date:&nbsp;%copyright_date%</p>\r\n<p>&nbsp;</p>', 339, '2021-10-11 08:01:53', 0, 'u');";

        DB::select($copy_right_master1);

        $copy_right_master2 = "INSERT INTO `rvw_copyright_master` (`crtm_id`, `crtm_license_name`, `crtm_payment`, `crtm_amount`, `crtm_license_details`, `crtm_license_content`, `crtm_posted_by`, `crtm_posted_date`, `crtm_proxy_id`, `crtm_operation`) VALUES
        (4, 'CC BY-NC', 'o', 0, 'Creative Commons Attribution-Non Commercial (CC BY-NC) This licence lets others remix, tweak, and build upon your work non-commercially, and although their new works must also acknowledge you and be non-commercial, they don\'t have to licence their derivative works on the same terms.', '<p>Journals Publication Agreement and Open Access Licence Agreement</p>\r\n<h2 style=\"font-family: \'Times New Roman\';\"><strong><em>Creative Commons Attribution-NonCommercial CC BY-NC Licence</em></strong></h2>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\">THE WORK (AS DEFINED BELOW) IS PROVIDED UNDER THE TERMS OF THIS CREATIVE COMMONS PUBLIC LICENSE (&ldquo;CCPL&rdquo; OR &ldquo;LICENSE&rdquo;). THE WORK IS PROTECTED BY COPYRIGHT AND/OR OTHER APPLICABLE LAW. ANY USE OF THE WORK OTHER THAN AS AUTHORIZED UNDER THIS LICENSE OR COPYRIGHT LAW IS PROHIBITED.</p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\">BY EXERCISING ANY RIGHTS TO THE WORK PROVIDED HERE, YOU ACCEPT AND AGREE TO BE BOUND BY THE TERMS OF THIS LICENSE. TO THE EXTENT THIS LICENSE MAY BE CONSIDERED TO BE A CONTRACT, THE LICENSOR GRANTS YOU THE RIGHTS CONTAINED HERE IN CONSIDERATION OF YOUR ACCEPTANCE OF SUCH TERMS AND CONDITIONS.</p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\"><strong>1. Definitions</strong></p>\r\n<ol style=\"font-family: \'Times New Roman\'; font-size: medium;\" type=\"a\">\r\n<li><strong>&ldquo;Adaptation&rdquo;</strong>&nbsp;means a work based upon the Work, or upon the Work and other pre-existing works, such as a translation, adaptation, derivative work, arrangement of music or other alterations of a literary or artistic work, or phonogram or performance and includes cinematographic adaptations or any other form in which the Work may be recast, transformed, or adapted including in any form recognizably derived from the original, except that a work that constitutes a Collection will not be considered an Adaptation for the purpose of this License. For the avoidance of doubt, where the Work is a musical work, performance or phonogram, the synchronization of the Work in timed-relation with a moving image (&ldquo;synching&rdquo;) will be considered an Adaptation for the purpose of this License.</li>\r\n<li><strong>&ldquo;Collection&rdquo;</strong>&nbsp;means a collection of literary or artistic works, such as encyclopedias and anthologies, or performances, phonograms or broadcasts, or other works or subject matter other than works listed in Section 1(f) below, which, by reason of the selection and arrangement of their contents, constitute intellectual creations, in which the Work is included in its entirety in unmodified form along with one or more other contributions, each constituting separate and independent works in themselves, which together are assembled into a collective whole. A work that constitutes a Collection will not be considered an Adaptation (as defined above) for the purposes of this License.</li>\r\n<li><strong>&ldquo;Distribute&rdquo;</strong>&nbsp;means to make available to the public the original and copies of the Work or Adaptation, as appropriate, through sale or other transfer of ownership.</li>\r\n<li><strong>&ldquo;Licensor&rdquo;</strong>&nbsp;means the individual, individuals, entity or entities that offer(s) the Work under the terms of this License.\r\n<p>&nbsp;</p>\r\n</li>\r\n<li><strong>&ldquo;Original Author&rdquo;</strong>&nbsp;means, in the case of a literary or artistic work, the individual, individuals, entity or entities who created the Work or if no individual or entity can be identified, the publisher; and in addition (i) in the case of a performance the actors, singers, musicians, dancers, and other persons who act, sing, deliver, declaim, play in, interpret or otherwise perform literary or artistic works or expressions of folklore; (ii) in the case of a phonogram the producer being the person or legal entity who first fixes the sounds of a performance or other sounds; and, (iii) in the case of broadcasts, the organization that transmits the broadcast.</li>\r\n<li><strong>&ldquo;Work&rdquo;</strong>&nbsp;means the literary and/or artistic work offered under the terms of this License including without limitation any production in the literary, scientific and artistic domain, whatever may be the mode or form of its expression including digital form, such as a book, pamphlet and other writing; a lecture, address, sermon or other work of the same nature; a dramatic or dramatico-musical work; a choreographic work or entertainment in dumb show; a musical composition with or without words; a cinematographic work to which are assimilated works expressed by a process analogous to cinematography; a work of drawing, painting, architecture, sculpture, engraving or lithography; a photographic work to which are assimilated works expressed by a process analogous to photography; a work of applied art; an illustration, map, plan, sketch or three-dimensional work relative to geography, topography, architecture or science; a performance; a broadcast; a phonogram; a compilation of data to the extent it is protected as a copyrightable work; or a work performed by a variety or circus performer to the extent it is not otherwise considered a literary or artistic work.</li>\r\n<li><strong>&ldquo;You&rdquo;</strong>&nbsp;means an individual or entity exercising rights under this License who has not previously violated the terms of this License with respect to the Work, or who has received express permission from the Licensor to exercise rights under this License despite a previous violation.</li>\r\n<li><strong>&ldquo;Publicly Perform&rdquo;</strong>&nbsp;means to perform public recitations of the Work and to communicate to the public those public recitations, by any means or process, including by wire or wireless means or public digital performances; to make available to the public Works in such a way that members of the public may access these Works from a place and at a place individually chosen by them; to perform the Work to the public by any means or process and the communication to the public of the performances of the Work, including by public digital performance; to broadcast and rebroadcast the Work by any means including signs, sounds or images.</li>\r\n<li><strong>&ldquo;Reproduce&rdquo;</strong>&nbsp;means to make copies of the Work by any means including without limitation by sound or visual recordings and the right of fixation and reproducing fixations of the Work, including storage of a protected performance or phonogram in digital form or other electronic medium.</li>\r\n</ol>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\">&nbsp;</p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\"><strong>2. Fair Dealing Rights.</strong>&nbsp;Nothing in this License is intended to reduce, limit, or restrict any uses free from copyright or rights arising from limitations or exceptions that are provided for in connection with the copyright protection under copyright law or other applicable laws.</p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\"><strong>3. License Grant.</strong>&nbsp;Subject to the terms and conditions of this License, Licensor hereby grants You a worldwide, royalty-free, non-exclusive, perpetual (for the duration of the applicable copyright) license to exercise the rights in the Work as stated below:</p>\r\n<ol style=\"font-family: \'Times New Roman\'; font-size: medium;\" type=\"a\">\r\n<li>to Reproduce the Work, to incorporate the Work into one or more Collections, and to Reproduce the Work as incorporated in the Collections;</li>\r\n<li>to create and Reproduce Adaptations provided that any such Adaptation, including any translation in any medium, takes reasonable steps to clearly label, demarcate or otherwise identify that changes were made to the original Work. For example, a translation could be marked &ldquo;The original work was translated from English to Spanish,&rdquo; or a modification could indicate &ldquo;The original work has been modified.&rdquo;;</li>\r\n<li>to Distribute and Publicly Perform the Work including as incorporated in Collections; and,</li>\r\n<li>to Distribute and Publicly Perform Adaptations.</li>\r\n</ol>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\">&nbsp;</p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\">The above rights may be exercised in all media and formats whether now known or hereafter devised. The above rights include the right to make such modifications as are technically necessary to exercise the rights in other media and formats. Subject to Section 8(f), all rights not expressly granted by Licensor are hereby reserved, including but not limited to the rights set forth in Section 4(d).</p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\"><strong>4. Restrictions.</strong>&nbsp;The license granted in Section 3 above is expressly made subject to and limited by the following restrictions:</p>\r\n<ol style=\"font-family: \'Times New Roman\'; font-size: medium;\" type=\"a\">\r\n<li>You may Distribute or Publicly Perform the Work only under the terms of this License. You must include a copy of, or the Uniform Resource Identifier (URI) for, this License with every copy of the Work You Distribute or Publicly Perform. You may not offer or impose any terms on the Work that restrict the terms of this License or the ability of the recipient of the Work to exercise the rights granted to that recipient under the terms of the License. You may not sublicense the Work. You must keep intact all notices that refer to this License and to the disclaimer of warranties with every copy of the Work You Distribute or Publicly Perform. When You Distribute or Publicly Perform the Work, You may not impose any effective technological measures on the Work that restrict the ability of a recipient of the Work from You to exercise the rights granted to that recipient under the terms of the License. This Section 4(a) applies to the Work as incorporated in a Collection, but this does not require the Collection apart from the Work itself to be made subject to the terms of this License. If You create a Collection, upon notice from any Licensor You must, to the extent practicable, remove from the Collection any credit as required by Section 4(c), as requested. If You create an Adaptation, upon notice from any Licensor You must, to the extent practicable, remove from the Adaptation any credit as required by Section 4(c), as requested.</li>\r\n<li>You may not exercise any of the rights granted to You in Section 3 above in any manner that is primarily intended for or directed toward commercial advantage or private monetary compensation. The exchange of the Work for other copyrighted works by means of digital file-sharing or otherwise shall not be considered to be intended for or directed toward commercial advantage or private monetary compensation, provided there is no payment of any monetary compensation in connection with the exchange of copyrighted works.</li>\r\n<li>If You Distribute, or Publicly Perform the Work or any Adaptations or Collections, You must, unless a request has been made pursuant to Section 4(a), keep intact all copyright notices for the Work and provide, reasonable to the medium or means You are utilizing: (i) the name of the Original Author (or pseudonym, if applicable) if supplied, and/or if the Original Author and/or Licensor designate another party or parties (e.g., a sponsor institute, publishing entity, journal) for attribution (&ldquo;Attribution Parties&rdquo;) in Licensor\'s copyright notice, terms of service or by other reasonable means, the name of such party or parties; (ii) the title of the Work if supplied; (iii) to the extent reasonably practicable, the URI, if any, that Licensor specifies to be associated with the Work, unless such URI does not refer to the copyright notice or licensing information for the Work; and, (iv) consistent with Section 3(b), in the case of an Adaptation, a credit identifying the use of the Work in the Adaptation (e.g., &ldquo;French translation of the Work by Original Author,&rdquo; or &ldquo;Screenplay based on original Work by Original Author&rdquo;). The credit required by this Section 4(c) may be implemented in any reasonable manner; provided, however, that in the case of a Adaptation or Collection, at a minimum such credit will appear, if a credit for all contributing authors of the Adaptation or Collection appears, then as part of these credits and in a manner at least as prominent as the credits for the other contributing authors. For the avoidance of doubt, You may only use the credit required by this Section for the purpose of attribution in the manner set out above and, by exercising Your rights under this License, You may not implicitly or explicitly assert or imply any connection with, sponsorship or endorsement by the Original Author, Licensor and/or Attribution Parties, as appropriate, of You or Your use of the Work, without the separate, express prior written permission of the Original Author, Licensor and/or Attribution Parties.</li>\r\n<li>For the avoidance of doubt:\r\n<ol type=\"i\">\r\n<li><strong>Non-waivable Compulsory License Schemes</strong>. In those jurisdictions in which the right to collect royalties through any statutory or compulsory licensing scheme cannot be waived, the Licensor reserves the exclusive right to collect such royalties for any exercise by You of the rights granted under this License;</li>\r\n<li><strong>Waivable Compulsory License Schemes</strong>. In those jurisdictions in which the right to collect royalties through any statutory or compulsory licensing scheme can be waived, the Licensor reserves the exclusive right to collect such royalties for any exercise by You of the rights granted under this License if Your exercise of such rights is for a purpose or use which is otherwise than noncommercial as permitted under Section 4(b) and otherwise waives the right to collect royalties through any statutory or compulsory licensing scheme; and,</li>\r\n<li><strong>Voluntary License Schemes</strong>. The Licensor reserves the right to collect royalties, whether individually or, in the event that the Licensor is a member of a collecting society that administers voluntary licensing schemes, via that society, from any exercise by You of the rights granted under this License that is for a purpose or use which is otherwise than noncommercial as permitted under Section 4(c).</li>\r\n</ol>\r\n</li>\r\n<li>Except as otherwise agreed in writing by the Licensor or as may be otherwise permitted by applicable law, if You Reproduce, Distribute or Publicly Perform the Work either by itself or as part of any Adaptations or Collections, You must not distort, mutilate, modify or take other derogatory action in relation to the Work which would be prejudicial to the Original Author\'s honor or reputation. Licensor agrees that in those jurisdictions (e.g. Japan), in which any exercise of the right granted in Section 3(b) of this License (the right to make Adaptations) would be deemed to be a distortion, mutilation, modification or other derogatory action prejudicial to the Original Author\'s honor and reputation, the Licensor will waive or not assert, as appropriate, this Section, to the fullest extent permitted by the applicable national law, to enable You to reasonably exercise Your right under Section 3(b) of this License (right to make Adaptations) but not otherwise.</li>\r\n</ol>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\">&nbsp;</p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\"><strong>5. Representations, Warranties and Disclaimer</strong></p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\">UNLESS OTHERWISE MUTUALLY AGREED TO BY THE PARTIES IN WRITING, LICENSOR OFFERS THE WORK AS-IS AND MAKES NO REPRESENTATIONS OR WARRANTIES OF ANY KIND CONCERNING THE WORK, EXPRESS, IMPLIED, STATUTORY OR OTHERWISE, INCLUDING, WITHOUT LIMITATION, WARRANTIES OF TITLE, MERCHANTIBILITY, FITNESS FOR A PARTICULAR PURPOSE, NONINFRINGEMENT, OR THE ABSENCE OF LATENT OR OTHER DEFECTS, ACCURACY, OR THE PRESENCE OF ABSENCE OF ERRORS, WHETHER OR NOT DISCOVERABLE. SOME JURISDICTIONS DO NOT ALLOW THE EXCLUSION OF IMPLIED WARRANTIES, SO SUCH EXCLUSION MAY NOT APPLY TO YOU.</p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\"><strong>6. Limitation on Liability.</strong>&nbsp;EXCEPT TO THE EXTENT REQUIRED BY APPLICABLE LAW, IN NO EVENT WILL LICENSOR BE LIABLE TO YOU ON ANY LEGAL THEORY FOR ANY SPECIAL, INCIDENTAL, CONSEQUENTIAL, PUNITIVE OR EXEMPLARY DAMAGES ARISING OUT OF THIS LICENSE OR THE USE OF THE WORK, EVEN IF LICENSOR HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.</p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\"><strong>7. Termination</strong></p>\r\n<ol style=\"font-family: \'Times New Roman\'; font-size: medium;\" type=\"a\">\r\n<li>This License and the rights granted hereunder will terminate automatically upon any breach by You of the terms of this License. Individuals or entities who have received Adaptations or Collections from You under this License, however, will not have their licenses terminated provided such individuals or entities remain in full compliance with those licenses. Sections 1, 2, 5, 6, 7, and 8 will survive any termination of this License.</li>\r\n<li>Subject to the above terms and conditions, the license granted here is perpetual (for the duration of the applicable copyright in the Work). Notwithstanding the above, Licensor reserves the right to release the Work under different license terms or to stop distributing the Work at any time; provided, however that any such election will not serve to withdraw this License (or any other license that has been, or is required to be, granted under the terms of this License), and this License will continue in full force and effect unless terminated as stated above.</li>\r\n</ol>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\">&nbsp;</p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\"><strong>8. Miscellaneous</strong></p>\r\n<ol style=\"font-family: \'Times New Roman\'; font-size: medium;\" type=\"a\">\r\n<li>Each time You Distribute or Publicly Perform the Work or a Collection, the Licensor offers to the recipient a license to the Work on the same terms and conditions as the license granted to You under this License.</li>\r\n<li>Each time You Distribute or Publicly Perform an Adaptation, Licensor offers to the recipient a license to the original Work on the same terms and conditions as the license granted to You under this License.</li>\r\n<li>If any provision of this License is invalid or unenforceable under applicable law, it shall not affect the validity or enforceability of the remainder of the terms of this License, and without further action by the parties to this agreement, such provision shall be reformed to the minimum extent necessary to make such provision valid and enforceable.</li>\r\n<li>No term or provision of this License shall be deemed waived and no breach consented to unless such waiver or consent shall be in writing and signed by the party to be charged with such waiver or consent.</li>\r\n<li>This License constitutes the entire agreement between the parties with respect to the Work licensed here. There are no understandings, agreements or representations with respect to the Work not specified here. Licensor shall not be bound by any additional provisions that may appear in any communication from You. This License may not be modified without the mutual written agreement of the Licensor and You.</li>\r\n<li>The rights granted under, and the subject matter referenced, in this License were drafted utilizing the terminology of the Berne Convention for the Protection of Literary and Artistic Works (as amended on September 28, 1979), the Rome Convention of 1961, the WIPO Copyright Treaty of 1996, the WIPO Performances and Phonograms Treaty of 1996 and the Universal Copyright Convention (as revised on July 24, 1971). These rights and subject matter take effect in the relevant jurisdiction in which the License terms are sought to be enforced according to the corresponding provisions of the implementation of those treaty provisions in the applicable national law. If the standard suite of rights granted under applicable copyright law includes additional rights not granted under this License, such additional rights are deemed to be included in the License; this License is not intended to restrict the license of any rights under applicable law.</li>\r\n</ol>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\">&nbsp;</p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\"><strong><em>Creative Commons Attribution-NonCommercial CC BY-NC Licence</em></strong></p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\">I, on behalf of myself and my co-authors agree to the publication of the submitted content under this type of Creative Commons Attribution licence. This licence lets others remix, tweak, and build upon your work non-commercially, and although their new works must also acknowledge you and be non-commercial, they don\'t have to licence their derivative works on the same terms.</p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\">Journal Name: %journal_name%</p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\">Manuscript ID:&nbsp;%manuscript_id%</p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\">Paper Title:&nbsp;%article_title%</p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\">Name:&nbsp;%author_name%</p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\">Date:&nbsp;%copyright_date%</p>', 339, '2021-10-11 08:01:23', 0, 'u'),
        (5, 'CC BY-NC-ND', 'o', 0, 'Creative Commons Attribution-NonCommercial-NoDerivs (CC BY-NC-ND) This licence is the most restrictive licence we offer, only allowing others to download your works and share them with others as long as they credit you, but they can\'t change them in any way or use them commercially.', '<p>Journals Publication Agreement and Open Access Licence Agreement</p>\r\n<h2 style=\"font-family: \'Times New Roman\';\"><strong><em>Creative Commons Attribution-NonCommercial-NoDerivs CC BY-NC-ND Licence</em></strong></h2>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\">THE WORK (AS DEFINED BELOW) IS PROVIDED UNDER THE TERMS OF THIS CREATIVE COMMONS PUBLIC LICENSE (&ldquo;CCPL&rdquo; OR &ldquo;LICENSE&rdquo;). THE WORK IS PROTECTED BY COPYRIGHT AND/OR OTHER APPLICABLE LAW. ANY USE OF THE WORK OTHER THAN AS AUTHORIZED UNDER THIS LICENSE OR COPYRIGHT LAW IS PROHIBITED.</p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\">BY EXERCISING ANY RIGHTS TO THE WORK PROVIDED HERE, YOU ACCEPT AND AGREE TO BE BOUND BY THE TERMS OF THIS LICENSE. TO THE EXTENT THIS LICENSE MAY BE CONSIDERED TO BE A CONTRACT, THE LICENSOR GRANTS YOU THE RIGHTS CONTAINED HERE IN CONSIDERATION OF YOUR ACCEPTANCE OF SUCH TERMS AND CONDITIONS.</p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\"><strong>1. Definitions</strong></p>\r\n<ol style=\"font-family: \'Times New Roman\'; font-size: medium;\" type=\"a\">\r\n<li><strong>&ldquo;Adaptation&rdquo;</strong>&nbsp;means a work based upon the Work, or upon the Work and other pre-existing works, such as a translation, adaptation, derivative work, arrangement of music or other alterations of a literary or artistic work, or phonogram or performance and includes cinematographic adaptations or any other form in which the Work may be recast, transformed, or adapted including in any form recognizably derived from the original, except that a work that constitutes a Collection will not be considered an Adaptation for the purpose of this License. For the avoidance of doubt, where the Work is a musical work, performance or phonogram, the synchronization of the Work in timed-relation with a moving image (&ldquo;synching&rdquo;) will be considered an Adaptation for the purpose of this License.</li>\r\n<li><strong>&ldquo;Collection&rdquo;</strong>&nbsp;means a collection of literary or artistic works, such as encyclopedias and anthologies, or performances, phonograms or broadcasts, or other works or subject matter other than works listed in Section 1(f) below, which, by reason of the selection and arrangement of their contents, constitute intellectual creations, in which the Work is included in its entirety in unmodified form along with one or more other contributions, each constituting separate and independent works in themselves, which together are assembled into a collective whole. A work that constitutes a Collection will not be considered an Adaptation (as defined above) for the purposes of this License.</li>\r\n<li><strong>&ldquo;Distribute&rdquo;</strong>&nbsp;means to make available to the public the original and copies of the Work through sale or other transfer of ownership.</li>\r\n<li><strong>&ldquo;Licensor&rdquo;</strong>&nbsp;means the individual, individuals, entity or entities that offer(s) the Work under the terms of this License.\r\n<p>&nbsp;</p>\r\n</li>\r\n<li><strong>&ldquo;Original Author&rdquo;</strong>&nbsp;means, in the case of a literary or artistic work, the individual, individuals, entity or entities who created the Work or if no individual or entity can be identified, the publisher; and in addition (i) in the case of a performance the actors, singers, musicians, dancers, and other persons who act, sing, deliver, declaim, play in, interpret or otherwise perform literary or artistic works or expressions of folklore; (ii) in the case of a phonogram the producer being the person or legal entity who first fixes the sounds of a performance or other sounds; and, (iii) in the case of broadcasts, the organization that transmits the broadcast.</li>\r\n<li><strong>&ldquo;Work&rdquo;</strong>&nbsp;means the literary and/or artistic work offered under the terms of this License including without limitation any production in the literary, scientific and artistic domain, whatever may be the mode or form of its expression including digital form, such as a book, pamphlet and other writing; a lecture, address, sermon or other work of the same nature; a dramatic or dramatico-musical work; a choreographic work or entertainment in dumb show; a musical composition with or without words; a cinematographic work to which are assimilated works expressed by a process analogous to cinematography; a work of drawing, painting, architecture, sculpture, engraving or lithography; a photographic work to which are assimilated works expressed by a process analogous to photography; a work of applied art; an illustration, map, plan, sketch or three-dimensional work relative to geography, topography, architecture or science; a performance; a broadcast; a phonogram; a compilation of data to the extent it is protected as a copyrightable work; or a work performed by a variety or circus performer to the extent it is not otherwise considered a literary or artistic work.</li>\r\n<li><strong>&ldquo;You&rdquo;</strong>&nbsp;means an individual or entity exercising rights under this License who has not previously violated the terms of this License with respect to the Work, or who has received express permission from the Licensor to exercise rights under this License despite a previous violation.\r\n<p>&nbsp;</p>\r\n</li>\r\n<li><strong>&ldquo;Publicly Perform&rdquo;</strong>&nbsp;means to perform public recitations of the Work and to communicate to the public those public recitations, by any means or process, including by wire or wireless means or public digital performances; to make available to the public Works in such a way that members of the public may access these Works from a place and at a place individually chosen by them; to perform the Work to the public by any means or process and the communication to the public of the performances of the Work, including by public digital performance; to broadcast and rebroadcast the Work by any means including signs, sounds or images.</li>\r\n<li><strong>&ldquo;Reproduce&rdquo;</strong>&nbsp;means to make copies of the Work by any means including without limitation by sound or visual recordings and the right of fixation and reproducing fixations of the Work, including storage of a protected performance or phonogram in digital form or other electronic medium.</li>\r\n</ol>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\">&nbsp;</p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\"><strong>2. Fair Dealing Rights.</strong>&nbsp;Nothing in this License is intended to reduce, limit, or restrict any uses free from copyright or rights arising from limitations or exceptions that are provided for in connection with the copyright protection under copyright law or other applicable laws.</p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\"><strong>3. License Grant.</strong>&nbsp;Subject to the terms and conditions of this License, Licensor hereby grants You a worldwide, royalty-free, non-exclusive, perpetual (for the duration of the applicable copyright) license to exercise the rights in the Work as stated below:</p>\r\n<ol style=\"font-family: \'Times New Roman\'; font-size: medium;\" type=\"a\">\r\n<li>to Reproduce the Work, to incorporate the Work into one or more Collections, and to Reproduce the Work as incorporated in the Collections; and,</li>\r\n<li>to Distribute and Publicly Perform the Work including as incorporated in Collections.</li>\r\n</ol>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\">&nbsp;</p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\">The above rights may be exercised in all media and formats whether now known or hereafter devised. The above rights include the right to make such modifications as are technically necessary to exercise the rights in other media and formats, but otherwise you have no rights to make Adaptations. Subject to 8(f), all rights not expressly granted by Licensor are hereby reserved, including but not limited to the rights set forth in Section 4(d).</p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\"><strong>4. Restrictions.</strong>&nbsp;The license granted in Section 3 above is expressly made subject to and limited by the following restrictions:</p>\r\n<ol style=\"font-family: \'Times New Roman\'; font-size: medium;\" type=\"a\">\r\n<li>You may Distribute or Publicly Perform the Work only under the terms of this License. You must include a copy of, or the Uniform Resource Identifier (URI) for, this License with every copy of the Work You Distribute or Publicly Perform. You may not offer or impose any terms on the Work that restrict the terms of this License or the ability of the recipient of the Work to exercise the rights granted to that recipient under the terms of the License. You may not sublicense the Work. You must keep intact all notices that refer to this License and to the disclaimer of warranties with every copy of the Work You Distribute or Publicly Perform. When You Distribute or Publicly Perform the Work, You may not impose any effective technological measures on the Work that restrict the ability of a recipient of the Work from You to exercise the rights granted to that recipient under the terms of the License. This Section 4(a) applies to the Work as incorporated in a Collection, but this does not require the Collection apart from the Work itself to be made subject to the terms of this License. If You create a Collection, upon notice from any Licensor You must, to the extent practicable, remove from the Collection any credit as required by Section 4(c), as requested.</li>\r\n<li>You may not exercise any of the rights granted to You in Section 3 above in any manner that is primarily intended for or directed toward commercial advantage or private monetary compensation. The exchange of the Work for other copyrighted works by means of digital file-sharing or otherwise shall not be considered to be intended for or directed toward commercial advantage or private monetary compensation, provided there is no payment of any monetary compensation in connection with the exchange of copyrighted works.</li>\r\n<li>If You Distribute, or Publicly Perform the Work or Collections, You must, unless a request has been made pursuant to Section 4(a), keep intact all copyright notices for the Work and provide, reasonable to the medium or means You are utilizing: (i) the name of the Original Author (or pseudonym, if applicable) if supplied, and/or if the Original Author and/or Licensor designate another party or parties (e.g., a sponsor institute, publishing entity, journal) for attribution (&ldquo;Attribution Parties&rdquo;) in Licensor\'s copyright notice, terms of service or by other reasonable means, the name of such party or parties; (ii) the title of the Work if supplied; (iii) to the extent reasonably practicable, the URI, if any, that Licensor specifies to be associated with the Work, unless such URI does not refer to the copyright notice or licensing information for the Work. The credit required by this Section 4(c) may be implemented in any reasonable manner; provided, however, that in the case of a Collection, at a minimum such credit will appear, if a credit for all contributing authors of Collection appears, then as part of these credits and in a manner at least as prominent as the credits for the other contributing authors. For the avoidance of doubt, You may only use the credit required by this Section for the purpose of attribution in the manner set out above and, by exercising Your rights under this License, You may not implicitly or explicitly assert or imply any connection with, sponsorship or endorsement by the Original Author, Licensor and/or Attribution Parties, as appropriate, of You or Your use of the Work, without the separate, express prior written permission of the Original Author, Licensor and/or Attribution Parties.</li>\r\n<li>For the avoidance of doubt:\r\n<ol type=\"i\">\r\n<li><strong>Non-waivable Compulsory License Schemes</strong>. In those jurisdictions in which the right to collect royalties through any statutory or compulsory licensing scheme cannot be waived, the Licensor reserves the exclusive right to collect such royalties for any exercise by You of the rights granted under this License;</li>\r\n<li><strong>Waivable Compulsory License Schemes</strong>. In those jurisdictions in which the right to collect royalties through any statutory or compulsory licensing scheme can be waived, the Licensor reserves the exclusive right to collect such royalties for any exercise by You of the rights granted under this License if Your exercise of such rights is for a purpose or use which is otherwise than noncommercial as permitted under Section 4(b) and otherwise waives the right to collect royalties through any statutory or compulsory licensing scheme; and,</li>\r\n<li><strong>Voluntary License Schemes</strong>. The Licensor reserves the right to collect royalties, whether individually or, in the event that the Licensor is a member of a collecting society that administers voluntary licensing schemes, via that society, from any exercise by You of the rights granted under this License that is for a purpose or use which is otherwise than noncommercial as permitted under Section 4(b).</li>\r\n</ol>\r\n</li>\r\n<li>Except as otherwise agreed in writing by the Licensor or as may be otherwise permitted by applicable law, if You Reproduce, Distribute or Publicly Perform the Work either by itself or as part of any Collections, You must not distort, mutilate, modify or take other derogatory action in relation to the Work which would be prejudicial to the Original Author\'s honor or reputation.</li>\r\n</ol>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\">&nbsp;</p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\"><strong>5. Representations, Warranties and Disclaimer</strong></p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\">UNLESS OTHERWISE MUTUALLY AGREED BY THE PARTIES IN WRITING, LICENSOR OFFERS THE WORK AS-IS AND MAKES NO REPRESENTATIONS OR WARRANTIES OF ANY KIND CONCERNING THE WORK, EXPRESS, IMPLIED, STATUTORY OR OTHERWISE, INCLUDING, WITHOUT LIMITATION, WARRANTIES OF TITLE, MERCHANTIBILITY, FITNESS FOR A PARTICULAR PURPOSE, NONINFRINGEMENT, OR THE ABSENCE OF LATENT OR OTHER DEFECTS, ACCURACY, OR THE PRESENCE OF ABSENCE OF ERRORS, WHETHER OR NOT DISCOVERABLE. SOME JURISDICTIONS DO NOT ALLOW THE EXCLUSION OF IMPLIED WARRANTIES, SO SUCH EXCLUSION MAY NOT APPLY TO YOU.</p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\"><strong>6. Limitation on Liability.</strong>&nbsp;EXCEPT TO THE EXTENT REQUIRED BY APPLICABLE LAW, IN NO EVENT WILL LICENSOR BE LIABLE TO YOU ON ANY LEGAL THEORY FOR ANY SPECIAL, INCIDENTAL, CONSEQUENTIAL, PUNITIVE OR EXEMPLARY DAMAGES ARISING OUT OF THIS LICENSE OR THE USE OF THE WORK, EVEN IF LICENSOR HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.</p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\"><strong>7. Termination</strong></p>\r\n<ol style=\"font-family: \'Times New Roman\'; font-size: medium;\" type=\"a\">\r\n<li>This License and the rights granted hereunder will terminate automatically upon any breach by You of the terms of this License. Individuals or entities who have received Collections from You under this License, however, will not have their licenses terminated provided such individuals or entities remain in full compliance with those licenses. Sections 1, 2, 5, 6, 7, and 8 will survive any termination of this License.</li>\r\n<li>Subject to the above terms and conditions, the license granted here is perpetual (for the duration of the applicable copyright in the Work). Notwithstanding the above, Licensor reserves the right to release the Work under different license terms or to stop distributing the Work at any time; provided, however that any such election will not serve to withdraw this License (or any other license that has been, or is required to be, granted under the terms of this License), and this License will continue in full force and effect unless terminated as stated above.</li>\r\n</ol>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\">&nbsp;</p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\"><strong>8. Miscellaneous</strong></p>\r\n<ol style=\"font-family: \'Times New Roman\'; font-size: medium;\" type=\"a\">\r\n<li>Each time You Distribute or Publicly Perform the Work or a Collection, the Licensor offers to the recipient a license to the Work on the same terms and conditions as the license granted to You under this License.</li>\r\n<li>If any provision of this License is invalid or unenforceable under applicable law, it shall not affect the validity or enforceability of the remainder of the terms of this License, and without further action by the parties to this agreement, such provision shall be reformed to the minimum extent necessary to make such provision valid and enforceable.</li>\r\n<li>No term or provision of this License shall be deemed waived and no breach consented to unless such waiver or consent shall be in writing and signed by the party to be charged with such waiver or consent.</li>\r\n<li>This License constitutes the entire agreement between the parties with respect to the Work licensed here. There are no understandings, agreements or representations with respect to the Work not specified here. Licensor shall not be bound by any additional provisions that may appear in any communication from You. This License may not be modified without the mutual written agreement of the Licensor and You.</li>\r\n<li>The rights granted under, and the subject matter referenced, in this License were drafted utilizing the terminology of the Berne Convention for the Protection of Literary and Artistic Works (as amended on September 28, 1979), the Rome Convention of 1961, the WIPO Copyright Treaty of 1996, the WIPO Performances and Phonograms Treaty of 1996 and the Universal Copyright Convention (as revised on July 24, 1971). These rights and subject matter take effect in the relevant jurisdiction in which the License terms are sought to be enforced according to the corresponding provisions of the implementation of those treaty provisions in the applicable national law. If the standard suite of rights granted under applicable copyright law includes additional rights not granted under this License, such additional rights are deemed to be included in the License; this License is not intended to restrict the license of any rights under applicable law.</li>\r\n</ol>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\">&nbsp;</p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\"><strong><em>Creative Commons Attribution-NonCommercial-NoDerivs CC BY-NC-ND Licence</em></strong></p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\">I, on behalf of myself and my co-authors agree to the publication of the submitted content under this type of Creative Commons Attribution licence. This licence is the most restrictive licence we offer, only allowing others to download your works and share them with others as long as they credit you, but they can\'t change them in any way or use them commercially.</p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\">Journal Name: %journal_name%</p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\">Manuscript ID: &nbsp;%manuscript_id%</p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\">Paper Title:&nbsp;%article_title%</p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\">Name:&nbsp;%author_name%</p>\r\n<p style=\"font-family: \'Times New Roman\'; font-size: medium;\">Date:&nbsp;%copyright_date%</p>', 339, '2021-10-11 08:01:38', 0, 'u'),
        (10, 'test', 'o', 0, 'test', '<p>tes5</p>', 1, '2023-11-28 11:35:41', 0, 'i');";

      DB::select($copy_right_master2);
    }
}
