#!/bin/bash

# texlive-full container should be running ; cmd = docker run -dit --name texlive-full -v "/usr/share/html":/usr/share/html texlive-full /bin/bash
# $1 = LATEX TOOL
# $2 = .tex file name for latexmk / newfilename & foldername for pdflatex


CURRENT_DIR=$PWD

if [ "$1" = "LATEXMK" ]; then
    docker exec texlive-full latexmk -f -pdf -xelatex -output-directory="$CURRENT_DIR" "$CURRENT_DIR/$2"
fi

if [ "$1" = "PDFLATEX" ]; then
    docker exec texlive-full pdflatex -output-directory="$CURRENT_DIR/$2" -jobname="$2" -interaction=nonstopmode -shell-escape "$CURRENT_DIR/join_template.tex"
fi
