(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('prop-types'), require('react')) :
  typeof define === 'function' && define.amd ? define(['exports', 'prop-types', 'react'], factory) :
  (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.ReactTabs = {}, global.PropTypes, global.React));
})(this, (function (exports, PropTypes, React) { 'use strict';

  function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

  var PropTypes__default = /*#__PURE__*/_interopDefaultLegacy(PropTypes);
  var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

  function makeTypeChecker(tabsRole){return function(element){return !!element.type&&element.type.tabsRole===tabsRole}}var isTab=makeTypeChecker("Tab");var isTabList=makeTypeChecker("TabList");var isTabPanel=makeTypeChecker("TabPanel");

  function isTabChild(child){return isTab(child)||isTabList(child)||isTabPanel(child)}function deepMap(children,callback){return React.Children.map(children,function(child){if(child===null)return null;if(isTabChild(child)){return callback(child)}if(child.props&&child.props.children&&typeof child.props.children==="object"){return React.cloneElement(child,Object.assign({},child.props,{children:deepMap(child.props.children,callback)}))}return child})}function deepForEach(children,callback){return React.Children.forEach(children,function(child){if(child===null)return;if(isTab(child)||isTabPanel(child)){callback(child);}else if(child.props&&child.props.children&&typeof child.props.children==="object"){if(isTabList(child))callback(child);deepForEach(child.props.children,callback);}})}

  function childrenPropType(props,propName,componentName){var error;var tabsCount=0;var panelsCount=0;var tabListFound=false;var listTabs=[];var children=props[propName];deepForEach(children,function(child){if(isTabList(child)){if(child.props&&child.props.children&&typeof child.props.children==="object"){deepForEach(child.props.children,function(listChild){return listTabs.push(listChild)});}if(tabListFound){error=new Error("Found multiple 'TabList' components inside 'Tabs'. Only one is allowed.");}tabListFound=true;}if(isTab(child)){if(!tabListFound||listTabs.indexOf(child)===-1){error=new Error("Found a 'Tab' component outside of the 'TabList' component. 'Tab' components "+"have to be inside the 'TabList' component.");}tabsCount++;}else if(isTabPanel(child)){panelsCount++;}});if(!error&&tabsCount!==panelsCount){error=new Error("There should be an equal number of 'Tab' and 'TabPanel' in `"+componentName+"`. "+("Received "+tabsCount+" 'Tab' and "+panelsCount+" 'TabPanel'."));}return error}function onSelectPropType(props,propName,componentName,location,propFullName){var prop=props[propName];var name=propFullName||propName;var error=null;if(prop&&typeof prop!=="function"){error=new Error("Invalid "+location+" `"+name+"` of type `"+typeof prop+"` supplied "+("to `"+componentName+"`, expected `function`."));}else if(props.selectedIndex!=null&&prop==null){error=new Error("The "+location+" `"+name+"` is marked as required in `"+componentName+"`, but "+"its value is `undefined` or `null`.\n"+"`onSelect` is required when `selectedIndex` is also set. Not doing so will "+"make the tabs not do anything, as `selectedIndex` indicates that you want to "+"handle the selected tab yourself.\n"+"If you only want to set the inital tab replace `selectedIndex` with `defaultIndex`.");}return error}function selectedIndexPropType(props,propName,componentName,location,propFullName){var prop=props[propName];var name=propFullName||propName;var error=null;if(prop!=null&&typeof prop!=="number"){error=new Error("Invalid "+location+" `"+name+"` of type `"+typeof prop+"` supplied to "+("`"+componentName+"`, expected `number`."));}else if(props.defaultIndex!=null&&prop!=null){return new Error("The "+location+" `"+name+"` cannot be used together with `defaultIndex` "+("in `"+componentName+"`.\n")+("Either remove `"+name+"` to let `"+componentName+"` handle the selected ")+"tab internally or remove `defaultIndex` to handle it yourself.")}return error}

  function _objectWithoutPropertiesLoose(source, excluded) {
    if (source == null) return {};
    var target = {};
    var sourceKeys = Object.keys(source);
    var key, i;
    for (i = 0; i < sourceKeys.length; i++) {
      key = sourceKeys[i];
      if (excluded.indexOf(key) >= 0) continue;
      target[key] = source[key];
    }
    return target;
  }

  function r(e) {
    var t,
      f,
      n = "";
    if ("string" == typeof e || "number" == typeof e) n += e;else if ("object" == typeof e) if (Array.isArray(e)) for (t = 0; t < e.length; t++) e[t] && (f = r(e[t])) && (n && (n += " "), n += f);else for (t in e) e[t] && (n && (n += " "), n += t);
    return n;
  }
  function clsx() {
    for (var e, t, f = 0, n = ""; f < arguments.length;) (e = arguments[f++]) && (t = r(e)) && (n && (n += " "), n += t);
    return n;
  }

  function getTabsCount(children){var tabCount=0;deepForEach(children,function(child){if(isTab(child))tabCount++;});return tabCount}

  var _excluded$3=["children","className","disabledTabClassName","domRef","focus","forceRenderTabPanel","onSelect","selectedIndex","selectedTabClassName","selectedTabPanelClassName","environment","disableUpDownKeys","disableLeftRightKeys"];function isNode(node){return node&&"getAttribute"in node}function isTabNode(node){return isNode(node)&&node.getAttribute("data-rttab")}function isTabDisabled(node){return isNode(node)&&node.getAttribute("aria-disabled")==="true"}var canUseActiveElement;function determineCanUseActiveElement(environment){var env=environment||(typeof window!=="undefined"?window:undefined);try{canUseActiveElement=!!(typeof env!=="undefined"&&env.document&&env.document.activeElement);}catch(e){canUseActiveElement=false;}}var defaultProps$4={className:"react-tabs",focus:false};var propTypes$4={children:childrenPropType,direction:PropTypes__default["default"].oneOf(["rtl","ltr"]),className:PropTypes__default["default"].oneOfType([PropTypes__default["default"].string,PropTypes__default["default"].array,PropTypes__default["default"].object]),disabledTabClassName:PropTypes__default["default"].string,disableUpDownKeys:PropTypes__default["default"].bool,disableLeftRightKeys:PropTypes__default["default"].bool,domRef:PropTypes__default["default"].func,focus:PropTypes__default["default"].bool,forceRenderTabPanel:PropTypes__default["default"].bool,onSelect:PropTypes__default["default"].func.isRequired,selectedIndex:PropTypes__default["default"].number.isRequired,selectedTabClassName:PropTypes__default["default"].string,selectedTabPanelClassName:PropTypes__default["default"].string,environment:PropTypes__default["default"].object};var UncontrolledTabs=function UncontrolledTabs(props){var tabNodes=React.useRef([]);var tabIds=React.useRef([]);var _ref=React.useRef();function setSelected(index,event){if(index<0||index>=getTabsCount$1())return;var onSelect=props.onSelect,selectedIndex=props.selectedIndex;onSelect(index,selectedIndex,event);}function getNextTab(index){var count=getTabsCount$1();for(var i=index+1;i<count;i++){if(!isTabDisabled(getTab(i))){return i}}for(var _i=0;_i<index;_i++){if(!isTabDisabled(getTab(_i))){return _i}}return index}function getPrevTab(index){var i=index;while(i--){if(!isTabDisabled(getTab(i))){return i}}i=getTabsCount$1();while(i-->index){if(!isTabDisabled(getTab(i))){return i}}return index}function getFirstTab(){var count=getTabsCount$1();for(var i=0;i<count;i++){if(!isTabDisabled(getTab(i))){return i}}return null}function getLastTab(){var i=getTabsCount$1();while(i--){if(!isTabDisabled(getTab(i))){return i}}return null}function getTabsCount$1(){var children=props.children;return getTabsCount(children)}function getTab(index){return tabNodes.current["tabs-"+index]}function getChildren(){var index=0;var children=props.children,disabledTabClassName=props.disabledTabClassName,focus=props.focus,forceRenderTabPanel=props.forceRenderTabPanel,selectedIndex=props.selectedIndex,selectedTabClassName=props.selectedTabClassName,selectedTabPanelClassName=props.selectedTabPanelClassName,environment=props.environment;tabIds.current=tabIds.current||[];var diff=tabIds.current.length-getTabsCount$1();var id=React.useId();while(diff++<0){tabIds.current.push(""+id+tabIds.current.length);}return deepMap(children,function(child){var result=child;if(isTabList(child)){var listIndex=0;var wasTabFocused=false;if(canUseActiveElement==null){determineCanUseActiveElement(environment);}var env=environment||(typeof window!=="undefined"?window:undefined);if(canUseActiveElement&&env){wasTabFocused=React__default["default"].Children.toArray(child.props.children).filter(isTab).some(function(tab,i){return env.document.activeElement===getTab(i)});}result=React.cloneElement(child,{children:deepMap(child.props.children,function(tab){var key="tabs-"+listIndex;var selected=selectedIndex===listIndex;var props={tabRef:function tabRef(node){tabNodes.current[key]=node;},id:tabIds.current[listIndex],selected:selected,focus:selected&&(focus||wasTabFocused)};if(selectedTabClassName)props.selectedClassName=selectedTabClassName;if(disabledTabClassName)props.disabledClassName=disabledTabClassName;listIndex++;return React.cloneElement(tab,props)})});}else if(isTabPanel(child)){var _props={id:tabIds.current[index],selected:selectedIndex===index};if(forceRenderTabPanel)_props.forceRender=forceRenderTabPanel;if(selectedTabPanelClassName)_props.selectedClassName=selectedTabPanelClassName;index++;result=React.cloneElement(child,_props);}return result})}function handleKeyDown(e){var direction=props.direction,disableUpDownKeys=props.disableUpDownKeys,disableLeftRightKeys=props.disableLeftRightKeys;if(isTabFromContainer(e.target)){var index=props.selectedIndex;var preventDefault=false;var useSelectedIndex=false;if(e.code==="Space"||e.keyCode===32||e.code==="Enter"||e.keyCode===13){preventDefault=true;useSelectedIndex=false;handleClick(e);}if(!disableLeftRightKeys&&(e.keyCode===37||e.code==="ArrowLeft")||!disableUpDownKeys&&(e.keyCode===38||e.code==="ArrowUp")){if(direction==="rtl"){index=getNextTab(index);}else {index=getPrevTab(index);}preventDefault=true;useSelectedIndex=true;}else if(!disableLeftRightKeys&&(e.keyCode===39||e.code==="ArrowRight")||!disableUpDownKeys&&(e.keyCode===40||e.code==="ArrowDown")){if(direction==="rtl"){index=getPrevTab(index);}else {index=getNextTab(index);}preventDefault=true;useSelectedIndex=true;}else if(e.keyCode===35||e.code==="End"){index=getLastTab();preventDefault=true;useSelectedIndex=true;}else if(e.keyCode===36||e.code==="Home"){index=getFirstTab();preventDefault=true;useSelectedIndex=true;}if(preventDefault){e.preventDefault();}if(useSelectedIndex){setSelected(index,e);}}}function handleClick(e){var node=e.target;do{if(isTabFromContainer(node)){if(isTabDisabled(node)){return}var index=[].slice.call(node.parentNode.children).filter(isTabNode).indexOf(node);setSelected(index,e);return}}while((node=node.parentNode)!=null)}function isTabFromContainer(node){if(!isTabNode(node)){return false}var nodeAncestor=node.parentElement;do{if(nodeAncestor===_ref.current)return true;if(nodeAncestor.getAttribute("data-rttabs"))break;nodeAncestor=nodeAncestor.parentElement;}while(nodeAncestor);return false}props.children;var className=props.className;props.disabledTabClassName;var domRef=props.domRef;props.focus;props.forceRenderTabPanel;props.onSelect;props.selectedIndex;props.selectedTabClassName;props.selectedTabPanelClassName;props.environment;props.disableUpDownKeys;props.disableLeftRightKeys;var attributes=_objectWithoutPropertiesLoose(props,_excluded$3);return React__default["default"].createElement("div",Object.assign({},attributes,{className:clsx(className),onClick:handleClick,onKeyDown:handleKeyDown,ref:function ref(node){_ref.current=node;if(domRef)domRef(node);},"data-rttabs":true}),getChildren())};UncontrolledTabs.defaultProps=defaultProps$4;UncontrolledTabs.propTypes=propTypes$4;

  var MODE_CONTROLLED=0;var MODE_UNCONTROLLED=1;var propTypes$3={children:childrenPropType,className:PropTypes__default["default"].oneOfType([PropTypes__default["default"].string,PropTypes__default["default"].array,PropTypes__default["default"].object]),defaultFocus:PropTypes__default["default"].bool,defaultIndex:PropTypes__default["default"].number,direction:PropTypes__default["default"].oneOf(["rtl","ltr"]),disabledTabClassName:PropTypes__default["default"].string,disableUpDownKeys:PropTypes__default["default"].bool,disableLeftRightKeys:PropTypes__default["default"].bool,domRef:PropTypes__default["default"].func,environment:PropTypes__default["default"].object,focusTabOnClick:PropTypes__default["default"].bool,forceRenderTabPanel:PropTypes__default["default"].bool,onSelect:onSelectPropType,selectedIndex:selectedIndexPropType,selectedTabClassName:PropTypes__default["default"].string,selectedTabPanelClassName:PropTypes__default["default"].string};var defaultProps$3={defaultFocus:false,focusTabOnClick:true,forceRenderTabPanel:false,selectedIndex:null,defaultIndex:null,environment:null,disableUpDownKeys:false,disableLeftRightKeys:false};var getModeFromProps=function getModeFromProps(props){return props.selectedIndex===null?MODE_UNCONTROLLED:MODE_CONTROLLED};var checkForIllegalModeChange=function checkForIllegalModeChange(props,mode){if(mode!=undefined&&mode!==getModeFromProps(props)){throw new Error("Switching between controlled mode (by using `selectedIndex`) and uncontrolled mode is not supported in `Tabs`.\nFor more information about controlled and uncontrolled mode of react-tabs see https://github.com/reactjs/react-tabs#controlled-vs-uncontrolled-mode.")}};var Tabs=function Tabs(props){var children=props.children,defaultFocus=props.defaultFocus,defaultIndex=props.defaultIndex,focusTabOnClick=props.focusTabOnClick,onSelect=props.onSelect;var _useState=React.useState(defaultFocus),focus=_useState[0],setFocus=_useState[1];var _useState2=React.useState(getModeFromProps(props)),mode=_useState2[0];var _useState3=React.useState(mode===MODE_UNCONTROLLED?defaultIndex||0:null),selectedIndex=_useState3[0],setSelectedIndex=_useState3[1];React.useEffect(function(){setFocus(false);},[]);if(mode===MODE_UNCONTROLLED){var tabsCount=getTabsCount(children);React.useEffect(function(){if(selectedIndex!=null){var maxTabIndex=Math.max(0,tabsCount-1);setSelectedIndex(Math.min(selectedIndex,maxTabIndex));}},[tabsCount]);}checkForIllegalModeChange(props,mode);var handleSelected=function handleSelected(index,last,event){if(typeof onSelect==="function"){if(onSelect(index,last,event)===false)return}if(focusTabOnClick){setFocus(true);}if(mode===MODE_UNCONTROLLED){setSelectedIndex(index);}};var subProps=Object.assign({},props);subProps.focus=focus;subProps.onSelect=handleSelected;if(selectedIndex!=null){subProps.selectedIndex=selectedIndex;}delete subProps.defaultFocus;delete subProps.defaultIndex;delete subProps.focusTabOnClick;return React__default["default"].createElement(UncontrolledTabs,subProps,children)};Tabs.propTypes=propTypes$3;Tabs.defaultProps=defaultProps$3;Tabs.tabsRole="Tabs";

  var _excluded$2=["children","className"];var defaultProps$2={className:"react-tabs__tab-list"};var propTypes$2={children:PropTypes__default["default"].oneOfType([PropTypes__default["default"].object,PropTypes__default["default"].array]),className:PropTypes__default["default"].oneOfType([PropTypes__default["default"].string,PropTypes__default["default"].array,PropTypes__default["default"].object])};var TabList=function TabList(props){var children=props.children,className=props.className,attributes=_objectWithoutPropertiesLoose(props,_excluded$2);return React__default["default"].createElement("ul",Object.assign({},attributes,{className:clsx(className),role:"tablist"}),children)};TabList.tabsRole="TabList";TabList.propTypes=propTypes$2;TabList.defaultProps=defaultProps$2;

  var _excluded$1=["children","className","disabled","disabledClassName","focus","id","selected","selectedClassName","tabIndex","tabRef"];var DEFAULT_CLASS$1="react-tabs__tab";var defaultProps$1={className:DEFAULT_CLASS$1,disabledClassName:DEFAULT_CLASS$1+"--disabled",focus:false,id:null,selected:false,selectedClassName:DEFAULT_CLASS$1+"--selected"};var propTypes$1={children:PropTypes__default["default"].oneOfType([PropTypes__default["default"].array,PropTypes__default["default"].object,PropTypes__default["default"].string]),className:PropTypes__default["default"].oneOfType([PropTypes__default["default"].string,PropTypes__default["default"].array,PropTypes__default["default"].object]),disabled:PropTypes__default["default"].bool,disabledClassName:PropTypes__default["default"].string,focus:PropTypes__default["default"].bool,id:PropTypes__default["default"].string,selected:PropTypes__default["default"].bool,selectedClassName:PropTypes__default["default"].string,tabIndex:PropTypes__default["default"].string,tabRef:PropTypes__default["default"].func};var Tab=function Tab(props){var _cx;var nodeRef=React.useRef();var children=props.children,className=props.className,disabled=props.disabled,disabledClassName=props.disabledClassName,focus=props.focus,id=props.id,selected=props.selected,selectedClassName=props.selectedClassName,tabIndex=props.tabIndex,tabRef=props.tabRef,attributes=_objectWithoutPropertiesLoose(props,_excluded$1);React.useEffect(function(){if(selected&&focus){nodeRef.current.focus();}},[selected,focus]);return React__default["default"].createElement("li",Object.assign({},attributes,{className:clsx(className,(_cx={},_cx[selectedClassName]=selected,_cx[disabledClassName]=disabled,_cx)),ref:function ref(node){nodeRef.current=node;if(tabRef)tabRef(node);},role:"tab",id:"tab"+id,"aria-selected":selected?"true":"false","aria-disabled":disabled?"true":"false","aria-controls":"panel"+id,tabIndex:tabIndex||(selected?"0":null),"data-rttab":true}),children)};Tab.propTypes=propTypes$1;Tab.tabsRole="Tab";Tab.defaultProps=defaultProps$1;

  var _excluded=["children","className","forceRender","id","selected","selectedClassName"];var DEFAULT_CLASS="react-tabs__tab-panel";var defaultProps={className:DEFAULT_CLASS,forceRender:false,selectedClassName:DEFAULT_CLASS+"--selected"};var propTypes={children:PropTypes__default["default"].node,className:PropTypes__default["default"].oneOfType([PropTypes__default["default"].string,PropTypes__default["default"].array,PropTypes__default["default"].object]),forceRender:PropTypes__default["default"].bool,id:PropTypes__default["default"].string,selected:PropTypes__default["default"].bool,selectedClassName:PropTypes__default["default"].string};var TabPanel=function TabPanel(props){var _cx;var children=props.children,className=props.className,forceRender=props.forceRender,id=props.id,selected=props.selected,selectedClassName=props.selectedClassName,attributes=_objectWithoutPropertiesLoose(props,_excluded);return React__default["default"].createElement("div",Object.assign({},attributes,{className:clsx(className,(_cx={},_cx[selectedClassName]=selected,_cx)),role:"tabpanel",id:"panel"+id,"aria-labelledby":"tab"+id}),forceRender||selected?children:null)};TabPanel.tabsRole="TabPanel";TabPanel.propTypes=propTypes;TabPanel.defaultProps=defaultProps;

  exports.Tab = Tab;
  exports.TabList = TabList;
  exports.TabPanel = TabPanel;
  exports.Tabs = Tabs;

  Object.defineProperty(exports, '__esModule', { value: true });

}));
//# sourceMappingURL=react-tabs.development.js.map
