import PropTypes from"prop-types";import React,{useEffect,useState}from"react";import{childrenPropType,onSelectPropType,selectedIndexPropType}from"../helpers/propTypes";import UncontrolledTabs from"./UncontrolledTabs";import{getTabsCount}from"../helpers/count";var MODE_CONTROLLED=0;var MODE_UNCONTROLLED=1;var propTypes=process.env.NODE_ENV!=="production"?{children:childrenPropType,className:PropTypes.oneOfType([PropTypes.string,PropTypes.array,PropTypes.object]),defaultFocus:PropTypes.bool,defaultIndex:PropTypes.number,direction:PropTypes.oneOf(["rtl","ltr"]),disabledTabClassName:PropTypes.string,disableUpDownKeys:PropTypes.bool,disableLeftRightKeys:PropTypes.bool,domRef:PropTypes.func,environment:PropTypes.object,focusTabOnClick:PropTypes.bool,forceRenderTabPanel:PropTypes.bool,onSelect:onSelectPropType,selectedIndex:selectedIndexPropType,selectedTabClassName:PropTypes.string,selectedTabPanelClassName:PropTypes.string}:{};var defaultProps={defaultFocus:false,focusTabOnClick:true,forceRenderTabPanel:false,selectedIndex:null,defaultIndex:null,environment:null,disableUpDownKeys:false,disableLeftRightKeys:false};var getModeFromProps=function getModeFromProps(props){return props.selectedIndex===null?MODE_UNCONTROLLED:MODE_CONTROLLED};var checkForIllegalModeChange=function checkForIllegalModeChange(props,mode){if(process.env.NODE_ENV!=="production"&&mode!=undefined&&mode!==getModeFromProps(props)){throw new Error("Switching between controlled mode (by using `selectedIndex`) and uncontrolled mode is not supported in `Tabs`.\nFor more information about controlled and uncontrolled mode of react-tabs see https://github.com/reactjs/react-tabs#controlled-vs-uncontrolled-mode.")}};var Tabs=function Tabs(props){var children=props.children,defaultFocus=props.defaultFocus,defaultIndex=props.defaultIndex,focusTabOnClick=props.focusTabOnClick,onSelect=props.onSelect;var _useState=useState(defaultFocus),focus=_useState[0],setFocus=_useState[1];var _useState2=useState(getModeFromProps(props)),mode=_useState2[0];var _useState3=useState(mode===MODE_UNCONTROLLED?defaultIndex||0:null),selectedIndex=_useState3[0],setSelectedIndex=_useState3[1];useEffect(function(){setFocus(false)},[]);if(mode===MODE_UNCONTROLLED){var tabsCount=getTabsCount(children);useEffect(function(){if(selectedIndex!=null){var maxTabIndex=Math.max(0,tabsCount-1);setSelectedIndex(Math.min(selectedIndex,maxTabIndex))}},[tabsCount])}checkForIllegalModeChange(props,mode);var handleSelected=function handleSelected(index,last,event){if(typeof onSelect==="function"){if(onSelect(index,last,event)===false)return}if(focusTabOnClick){setFocus(true)}if(mode===MODE_UNCONTROLLED){setSelectedIndex(index)}};var subProps=Object.assign({},props);subProps.focus=focus;subProps.onSelect=handleSelected;if(selectedIndex!=null){subProps.selectedIndex=selectedIndex}delete subProps.defaultFocus;delete subProps.defaultIndex;delete subProps.focusTabOnClick;return React.createElement(UncontrolledTabs,subProps,children)};Tabs.propTypes=process.env.NODE_ENV!=="production"?propTypes:{};Tabs.defaultProps=defaultProps;Tabs.tabsRole="Tabs";export default Tabs;