var _excluded=["children","className","disabledTabClassName","domRef","focus","forceRenderTabPanel","onSelect","selectedIndex","selectedTabClassName","selectedTabPanelClassName","environment","disableUpDownKeys","disableLeftRightKeys"];function _objectWithoutPropertiesLoose(source,excluded){if(source==null)return{};var target={};var sourceKeys=Object.keys(source);var key,i;for(i=0;i<sourceKeys.length;i++){key=sourceKeys[i];if(excluded.indexOf(key)>=0)continue;target[key]=source[key]}return target}import PropTypes from"prop-types";import React,{cloneElement,useRef,useId}from"react";import cx from"clsx";import{childrenPropType}from"../helpers/propTypes";import{getTabsCount as getTabsCountHelper}from"../helpers/count";import{deepMap}from"../helpers/childrenDeepMap";import{isTabList,isTabPanel,isTab}from"../helpers/elementTypes";function isNode(node){return node&&"getAttribute"in node}function isTabNode(node){return isNode(node)&&node.getAttribute("data-rttab")}function isTabDisabled(node){return isNode(node)&&node.getAttribute("aria-disabled")==="true"}var canUseActiveElement;function determineCanUseActiveElement(environment){var env=environment||(typeof window!=="undefined"?window:undefined);try{canUseActiveElement=!!(typeof env!=="undefined"&&env.document&&env.document.activeElement)}catch(e){canUseActiveElement=false}}var defaultProps={className:"react-tabs",focus:false};var propTypes=process.env.NODE_ENV!=="production"?{children:childrenPropType,direction:PropTypes.oneOf(["rtl","ltr"]),className:PropTypes.oneOfType([PropTypes.string,PropTypes.array,PropTypes.object]),disabledTabClassName:PropTypes.string,disableUpDownKeys:PropTypes.bool,disableLeftRightKeys:PropTypes.bool,domRef:PropTypes.func,focus:PropTypes.bool,forceRenderTabPanel:PropTypes.bool,onSelect:PropTypes.func.isRequired,selectedIndex:PropTypes.number.isRequired,selectedTabClassName:PropTypes.string,selectedTabPanelClassName:PropTypes.string,environment:PropTypes.object}:{};var UncontrolledTabs=function UncontrolledTabs(props){var tabNodes=useRef([]);var tabIds=useRef([]);var _ref=useRef();function setSelected(index,event){if(index<0||index>=getTabsCount())return;var onSelect=props.onSelect,selectedIndex=props.selectedIndex;onSelect(index,selectedIndex,event)}function getNextTab(index){var count=getTabsCount();for(var i=index+1;i<count;i++){if(!isTabDisabled(getTab(i))){return i}}for(var _i=0;_i<index;_i++){if(!isTabDisabled(getTab(_i))){return _i}}return index}function getPrevTab(index){var i=index;while(i--){if(!isTabDisabled(getTab(i))){return i}}i=getTabsCount();while(i-->index){if(!isTabDisabled(getTab(i))){return i}}return index}function getFirstTab(){var count=getTabsCount();for(var i=0;i<count;i++){if(!isTabDisabled(getTab(i))){return i}}return null}function getLastTab(){var i=getTabsCount();while(i--){if(!isTabDisabled(getTab(i))){return i}}return null}function getTabsCount(){var children=props.children;return getTabsCountHelper(children)}function getTab(index){return tabNodes.current["tabs-"+index]}function getChildren(){var index=0;var children=props.children,disabledTabClassName=props.disabledTabClassName,focus=props.focus,forceRenderTabPanel=props.forceRenderTabPanel,selectedIndex=props.selectedIndex,selectedTabClassName=props.selectedTabClassName,selectedTabPanelClassName=props.selectedTabPanelClassName,environment=props.environment;tabIds.current=tabIds.current||[];var diff=tabIds.current.length-getTabsCount();var id=useId();while(diff++<0){tabIds.current.push(""+id+tabIds.current.length)}return deepMap(children,function(child){var result=child;if(isTabList(child)){var listIndex=0;var wasTabFocused=false;if(canUseActiveElement==null){determineCanUseActiveElement(environment)}var env=environment||(typeof window!=="undefined"?window:undefined);if(canUseActiveElement&&env){wasTabFocused=React.Children.toArray(child.props.children).filter(isTab).some(function(tab,i){return env.document.activeElement===getTab(i)})}result=cloneElement(child,{children:deepMap(child.props.children,function(tab){var key="tabs-"+listIndex;var selected=selectedIndex===listIndex;var props={tabRef:function tabRef(node){tabNodes.current[key]=node},id:tabIds.current[listIndex],selected:selected,focus:selected&&(focus||wasTabFocused)};if(selectedTabClassName)props.selectedClassName=selectedTabClassName;if(disabledTabClassName)props.disabledClassName=disabledTabClassName;listIndex++;return cloneElement(tab,props)})})}else if(isTabPanel(child)){var _props={id:tabIds.current[index],selected:selectedIndex===index};if(forceRenderTabPanel)_props.forceRender=forceRenderTabPanel;if(selectedTabPanelClassName)_props.selectedClassName=selectedTabPanelClassName;index++;result=cloneElement(child,_props)}return result})}function handleKeyDown(e){var direction=props.direction,disableUpDownKeys=props.disableUpDownKeys,disableLeftRightKeys=props.disableLeftRightKeys;if(isTabFromContainer(e.target)){var index=props.selectedIndex;var preventDefault=false;var useSelectedIndex=false;if(e.code==="Space"||e.keyCode===32||e.code==="Enter"||e.keyCode===13){preventDefault=true;useSelectedIndex=false;handleClick(e)}if(!disableLeftRightKeys&&(e.keyCode===37||e.code==="ArrowLeft")||!disableUpDownKeys&&(e.keyCode===38||e.code==="ArrowUp")){if(direction==="rtl"){index=getNextTab(index)}else{index=getPrevTab(index)}preventDefault=true;useSelectedIndex=true}else if(!disableLeftRightKeys&&(e.keyCode===39||e.code==="ArrowRight")||!disableUpDownKeys&&(e.keyCode===40||e.code==="ArrowDown")){if(direction==="rtl"){index=getPrevTab(index)}else{index=getNextTab(index)}preventDefault=true;useSelectedIndex=true}else if(e.keyCode===35||e.code==="End"){index=getLastTab();preventDefault=true;useSelectedIndex=true}else if(e.keyCode===36||e.code==="Home"){index=getFirstTab();preventDefault=true;useSelectedIndex=true}if(preventDefault){e.preventDefault()}if(useSelectedIndex){setSelected(index,e)}}}function handleClick(e){var node=e.target;do{if(isTabFromContainer(node)){if(isTabDisabled(node)){return}var index=[].slice.call(node.parentNode.children).filter(isTabNode).indexOf(node);setSelected(index,e);return}}while((node=node.parentNode)!=null)}function isTabFromContainer(node){if(!isTabNode(node)){return false}var nodeAncestor=node.parentElement;do{if(nodeAncestor===_ref.current)return true;if(nodeAncestor.getAttribute("data-rttabs"))break;nodeAncestor=nodeAncestor.parentElement}while(nodeAncestor);return false}var children=props.children,className=props.className,disabledTabClassName=props.disabledTabClassName,domRef=props.domRef,focus=props.focus,forceRenderTabPanel=props.forceRenderTabPanel,onSelect=props.onSelect,selectedIndex=props.selectedIndex,selectedTabClassName=props.selectedTabClassName,selectedTabPanelClassName=props.selectedTabPanelClassName,environment=props.environment,disableUpDownKeys=props.disableUpDownKeys,disableLeftRightKeys=props.disableLeftRightKeys,attributes=_objectWithoutPropertiesLoose(props,_excluded);return React.createElement("div",Object.assign({},attributes,{className:cx(className),onClick:handleClick,onKeyDown:handleKeyDown,ref:function ref(node){_ref.current=node;if(domRef)domRef(node)},"data-rttabs":true}),getChildren())};UncontrolledTabs.defaultProps=defaultProps;UncontrolledTabs.propTypes=process.env.NODE_ENV!=="production"?propTypes:{};export default UncontrolledTabs;