"use strict";exports.__esModule=true;exports["default"]=void 0;var _propTypes=_interopRequireDefault(require("prop-types"));var _react=_interopRequireWildcard(require("react"));var _propTypes2=require("../helpers/propTypes");var _UncontrolledTabs=_interopRequireDefault(require("./UncontrolledTabs"));var _count=require("../helpers/count");function _getRequireWildcardCache(nodeInterop){if(typeof WeakMap!=="function")return null;var cacheBabelInterop=new WeakMap;var cacheNodeInterop=new WeakMap;return(_getRequireWildcardCache=function _getRequireWildcardCache(nodeInterop){return nodeInterop?cacheNodeInterop:cacheBabelInterop})(nodeInterop)}function _interopRequireWildcard(obj,nodeInterop){if(!nodeInterop&&obj&&obj.__esModule){return obj}if(obj===null||typeof obj!=="object"&&typeof obj!=="function"){return{"default":obj}}var cache=_getRequireWildcardCache(nodeInterop);if(cache&&cache.has(obj)){return cache.get(obj)}var newObj={};var hasPropertyDescriptor=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var key in obj){if(key!=="default"&&Object.prototype.hasOwnProperty.call(obj,key)){var desc=hasPropertyDescriptor?Object.getOwnPropertyDescriptor(obj,key):null;if(desc&&(desc.get||desc.set)){Object.defineProperty(newObj,key,desc)}else{newObj[key]=obj[key]}}}newObj["default"]=obj;if(cache){cache.set(obj,newObj)}return newObj}function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{"default":obj}}var MODE_CONTROLLED=0;var MODE_UNCONTROLLED=1;var propTypes=process.env.NODE_ENV!=="production"?{children:_propTypes2.childrenPropType,className:_propTypes["default"].oneOfType([_propTypes["default"].string,_propTypes["default"].array,_propTypes["default"].object]),defaultFocus:_propTypes["default"].bool,defaultIndex:_propTypes["default"].number,direction:_propTypes["default"].oneOf(["rtl","ltr"]),disabledTabClassName:_propTypes["default"].string,disableUpDownKeys:_propTypes["default"].bool,disableLeftRightKeys:_propTypes["default"].bool,domRef:_propTypes["default"].func,environment:_propTypes["default"].object,focusTabOnClick:_propTypes["default"].bool,forceRenderTabPanel:_propTypes["default"].bool,onSelect:_propTypes2.onSelectPropType,selectedIndex:_propTypes2.selectedIndexPropType,selectedTabClassName:_propTypes["default"].string,selectedTabPanelClassName:_propTypes["default"].string}:{};var defaultProps={defaultFocus:false,focusTabOnClick:true,forceRenderTabPanel:false,selectedIndex:null,defaultIndex:null,environment:null,disableUpDownKeys:false,disableLeftRightKeys:false};var getModeFromProps=function getModeFromProps(props){return props.selectedIndex===null?MODE_UNCONTROLLED:MODE_CONTROLLED};var checkForIllegalModeChange=function checkForIllegalModeChange(props,mode){if(process.env.NODE_ENV!=="production"&&mode!=undefined&&mode!==getModeFromProps(props)){throw new Error("Switching between controlled mode (by using `selectedIndex`) and uncontrolled mode is not supported in `Tabs`.\nFor more information about controlled and uncontrolled mode of react-tabs see https://github.com/reactjs/react-tabs#controlled-vs-uncontrolled-mode.")}};var Tabs=function Tabs(props){var children=props.children,defaultFocus=props.defaultFocus,defaultIndex=props.defaultIndex,focusTabOnClick=props.focusTabOnClick,onSelect=props.onSelect;var _useState=(0,_react.useState)(defaultFocus),focus=_useState[0],setFocus=_useState[1];var _useState2=(0,_react.useState)(getModeFromProps(props)),mode=_useState2[0];var _useState3=(0,_react.useState)(mode===MODE_UNCONTROLLED?defaultIndex||0:null),selectedIndex=_useState3[0],setSelectedIndex=_useState3[1];(0,_react.useEffect)(function(){setFocus(false)},[]);if(mode===MODE_UNCONTROLLED){var tabsCount=(0,_count.getTabsCount)(children);(0,_react.useEffect)(function(){if(selectedIndex!=null){var maxTabIndex=Math.max(0,tabsCount-1);setSelectedIndex(Math.min(selectedIndex,maxTabIndex))}},[tabsCount])}checkForIllegalModeChange(props,mode);var handleSelected=function handleSelected(index,last,event){if(typeof onSelect==="function"){if(onSelect(index,last,event)===false)return}if(focusTabOnClick){setFocus(true)}if(mode===MODE_UNCONTROLLED){setSelectedIndex(index)}};var subProps=Object.assign({},props);subProps.focus=focus;subProps.onSelect=handleSelected;if(selectedIndex!=null){subProps.selectedIndex=selectedIndex}delete subProps.defaultFocus;delete subProps.defaultIndex;delete subProps.focusTabOnClick;return _react["default"].createElement(_UncontrolledTabs["default"],subProps,children)};Tabs.propTypes=process.env.NODE_ENV!=="production"?propTypes:{};Tabs.defaultProps=defaultProps;Tabs.tabsRole="Tabs";var _default=Tabs;exports["default"]=_default;