"use strict";exports.__esModule=true;exports["default"]=void 0;var _propTypes=_interopRequireDefault(require("prop-types"));var _react=_interopRequireWildcard(require("react"));var _clsx=_interopRequireDefault(require("clsx"));var _propTypes2=require("../helpers/propTypes");var _count=require("../helpers/count");var _childrenDeepMap=require("../helpers/childrenDeepMap");var _elementTypes=require("../helpers/elementTypes");var _excluded=["children","className","disabledTabClassName","domRef","focus","forceRenderTabPanel","onSelect","selectedIndex","selectedTabClassName","selectedTabPanelClassName","environment","disableUpDownKeys","disableLeftRightKeys"];function _getRequireWildcardCache(nodeInterop){if(typeof WeakMap!=="function")return null;var cacheBabelInterop=new WeakMap;var cacheNodeInterop=new WeakMap;return(_getRequireWildcardCache=function _getRequireWildcardCache(nodeInterop){return nodeInterop?cacheNodeInterop:cacheBabelInterop})(nodeInterop)}function _interopRequireWildcard(obj,nodeInterop){if(!nodeInterop&&obj&&obj.__esModule){return obj}if(obj===null||typeof obj!=="object"&&typeof obj!=="function"){return{"default":obj}}var cache=_getRequireWildcardCache(nodeInterop);if(cache&&cache.has(obj)){return cache.get(obj)}var newObj={};var hasPropertyDescriptor=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var key in obj){if(key!=="default"&&Object.prototype.hasOwnProperty.call(obj,key)){var desc=hasPropertyDescriptor?Object.getOwnPropertyDescriptor(obj,key):null;if(desc&&(desc.get||desc.set)){Object.defineProperty(newObj,key,desc)}else{newObj[key]=obj[key]}}}newObj["default"]=obj;if(cache){cache.set(obj,newObj)}return newObj}function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{"default":obj}}function _objectWithoutPropertiesLoose(source,excluded){if(source==null)return{};var target={};var sourceKeys=Object.keys(source);var key,i;for(i=0;i<sourceKeys.length;i++){key=sourceKeys[i];if(excluded.indexOf(key)>=0)continue;target[key]=source[key]}return target}function isNode(node){return node&&"getAttribute"in node}function isTabNode(node){return isNode(node)&&node.getAttribute("data-rttab")}function isTabDisabled(node){return isNode(node)&&node.getAttribute("aria-disabled")==="true"}var canUseActiveElement;function determineCanUseActiveElement(environment){var env=environment||(typeof window!=="undefined"?window:undefined);try{canUseActiveElement=!!(typeof env!=="undefined"&&env.document&&env.document.activeElement)}catch(e){canUseActiveElement=false}}var defaultProps={className:"react-tabs",focus:false};var propTypes=process.env.NODE_ENV!=="production"?{children:_propTypes2.childrenPropType,direction:_propTypes["default"].oneOf(["rtl","ltr"]),className:_propTypes["default"].oneOfType([_propTypes["default"].string,_propTypes["default"].array,_propTypes["default"].object]),disabledTabClassName:_propTypes["default"].string,disableUpDownKeys:_propTypes["default"].bool,disableLeftRightKeys:_propTypes["default"].bool,domRef:_propTypes["default"].func,focus:_propTypes["default"].bool,forceRenderTabPanel:_propTypes["default"].bool,onSelect:_propTypes["default"].func.isRequired,selectedIndex:_propTypes["default"].number.isRequired,selectedTabClassName:_propTypes["default"].string,selectedTabPanelClassName:_propTypes["default"].string,environment:_propTypes["default"].object}:{};var UncontrolledTabs=function UncontrolledTabs(props){var tabNodes=(0,_react.useRef)([]);var tabIds=(0,_react.useRef)([]);var _ref=(0,_react.useRef)();function setSelected(index,event){if(index<0||index>=getTabsCount())return;var onSelect=props.onSelect,selectedIndex=props.selectedIndex;onSelect(index,selectedIndex,event)}function getNextTab(index){var count=getTabsCount();for(var i=index+1;i<count;i++){if(!isTabDisabled(getTab(i))){return i}}for(var _i=0;_i<index;_i++){if(!isTabDisabled(getTab(_i))){return _i}}return index}function getPrevTab(index){var i=index;while(i--){if(!isTabDisabled(getTab(i))){return i}}i=getTabsCount();while(i-->index){if(!isTabDisabled(getTab(i))){return i}}return index}function getFirstTab(){var count=getTabsCount();for(var i=0;i<count;i++){if(!isTabDisabled(getTab(i))){return i}}return null}function getLastTab(){var i=getTabsCount();while(i--){if(!isTabDisabled(getTab(i))){return i}}return null}function getTabsCount(){var children=props.children;return(0,_count.getTabsCount)(children)}function getTab(index){return tabNodes.current["tabs-"+index]}function getChildren(){var index=0;var children=props.children,disabledTabClassName=props.disabledTabClassName,focus=props.focus,forceRenderTabPanel=props.forceRenderTabPanel,selectedIndex=props.selectedIndex,selectedTabClassName=props.selectedTabClassName,selectedTabPanelClassName=props.selectedTabPanelClassName,environment=props.environment;tabIds.current=tabIds.current||[];var diff=tabIds.current.length-getTabsCount();var id=(0,_react.useId)();while(diff++<0){tabIds.current.push(""+id+tabIds.current.length)}return(0,_childrenDeepMap.deepMap)(children,function(child){var result=child;if((0,_elementTypes.isTabList)(child)){var listIndex=0;var wasTabFocused=false;if(canUseActiveElement==null){determineCanUseActiveElement(environment)}var env=environment||(typeof window!=="undefined"?window:undefined);if(canUseActiveElement&&env){wasTabFocused=_react["default"].Children.toArray(child.props.children).filter(_elementTypes.isTab).some(function(tab,i){return env.document.activeElement===getTab(i)})}result=(0,_react.cloneElement)(child,{children:(0,_childrenDeepMap.deepMap)(child.props.children,function(tab){var key="tabs-"+listIndex;var selected=selectedIndex===listIndex;var props={tabRef:function tabRef(node){tabNodes.current[key]=node},id:tabIds.current[listIndex],selected:selected,focus:selected&&(focus||wasTabFocused)};if(selectedTabClassName)props.selectedClassName=selectedTabClassName;if(disabledTabClassName)props.disabledClassName=disabledTabClassName;listIndex++;return(0,_react.cloneElement)(tab,props)})})}else if((0,_elementTypes.isTabPanel)(child)){var _props={id:tabIds.current[index],selected:selectedIndex===index};if(forceRenderTabPanel)_props.forceRender=forceRenderTabPanel;if(selectedTabPanelClassName)_props.selectedClassName=selectedTabPanelClassName;index++;result=(0,_react.cloneElement)(child,_props)}return result})}function handleKeyDown(e){var direction=props.direction,disableUpDownKeys=props.disableUpDownKeys,disableLeftRightKeys=props.disableLeftRightKeys;if(isTabFromContainer(e.target)){var index=props.selectedIndex;var preventDefault=false;var useSelectedIndex=false;if(e.code==="Space"||e.keyCode===32||e.code==="Enter"||e.keyCode===13){preventDefault=true;useSelectedIndex=false;handleClick(e)}if(!disableLeftRightKeys&&(e.keyCode===37||e.code==="ArrowLeft")||!disableUpDownKeys&&(e.keyCode===38||e.code==="ArrowUp")){if(direction==="rtl"){index=getNextTab(index)}else{index=getPrevTab(index)}preventDefault=true;useSelectedIndex=true}else if(!disableLeftRightKeys&&(e.keyCode===39||e.code==="ArrowRight")||!disableUpDownKeys&&(e.keyCode===40||e.code==="ArrowDown")){if(direction==="rtl"){index=getPrevTab(index)}else{index=getNextTab(index)}preventDefault=true;useSelectedIndex=true}else if(e.keyCode===35||e.code==="End"){index=getLastTab();preventDefault=true;useSelectedIndex=true}else if(e.keyCode===36||e.code==="Home"){index=getFirstTab();preventDefault=true;useSelectedIndex=true}if(preventDefault){e.preventDefault()}if(useSelectedIndex){setSelected(index,e)}}}function handleClick(e){var node=e.target;do{if(isTabFromContainer(node)){if(isTabDisabled(node)){return}var index=[].slice.call(node.parentNode.children).filter(isTabNode).indexOf(node);setSelected(index,e);return}}while((node=node.parentNode)!=null)}function isTabFromContainer(node){if(!isTabNode(node)){return false}var nodeAncestor=node.parentElement;do{if(nodeAncestor===_ref.current)return true;if(nodeAncestor.getAttribute("data-rttabs"))break;nodeAncestor=nodeAncestor.parentElement}while(nodeAncestor);return false}var children=props.children,className=props.className,disabledTabClassName=props.disabledTabClassName,domRef=props.domRef,focus=props.focus,forceRenderTabPanel=props.forceRenderTabPanel,onSelect=props.onSelect,selectedIndex=props.selectedIndex,selectedTabClassName=props.selectedTabClassName,selectedTabPanelClassName=props.selectedTabPanelClassName,environment=props.environment,disableUpDownKeys=props.disableUpDownKeys,disableLeftRightKeys=props.disableLeftRightKeys,attributes=_objectWithoutPropertiesLoose(props,_excluded);return _react["default"].createElement("div",Object.assign({},attributes,{className:(0,_clsx["default"])(className),onClick:handleClick,onKeyDown:handleKeyDown,ref:function ref(node){_ref.current=node;if(domRef)domRef(node)},"data-rttabs":true}),getChildren())};UncontrolledTabs.defaultProps=defaultProps;UncontrolledTabs.propTypes=process.env.NODE_ENV!=="production"?propTypes:{};var _default=UncontrolledTabs;exports["default"]=_default;