import { default as default_2 } from 'react';

export declare type CalculateViewLocation = (params: CalculateViewLocationParams) => IndexLocationWithAlign | null | number;

export declare interface CalculateViewLocationParams {
    itemBottom: number;
    itemTop: number;
    locationParams: {
        align?: 'center' | 'end' | 'start';
        behavior?: 'auto' | 'smooth';
    } & ({
        groupIndex: number;
    } | {
        index: number;
    });
    viewportBottom: number;
    viewportTop: number;
}

/**
 * Customize the Virtuoso rendering by passing a set of custom components.
 */
export declare interface Components<Data = unknown, Context = unknown> {
    /**
     * Set to render a custom UI when the list is empty.
     */
    EmptyPlaceholder?: default_2.ComponentType<ContextProp<Context>>;
    /**
     * Set to render a component at the bottom of the list.
     */
    Footer?: default_2.ComponentType<ContextProp<Context>>;
    /**
     * Set to customize the group item wrapping element. Use only if you would like to render list from elements different than a `div`.
     */
    Group?: default_2.ComponentType<GroupProps & ContextProp<Context>>;
    /**
     * Set to render a component at the top of the list.
     *
     * The header remains above the top items and does not remain sticky.
     */
    Header?: default_2.ComponentType<ContextProp<Context>>;
    /**
     * Set to customize the item wrapping element. Use only if you would like to render list from elements different than a `div`.
     */
    Item?: default_2.ComponentType<ItemProps<Data> & ContextProp<Context>>;
    /**
     * Set to customize the items wrapper. Use only if you would like to render list from elements different than a `div`.
     */
    List?: default_2.ComponentType<ListProps & ContextProp<Context>>;
    /**
     * Set to customize the outermost scrollable element. This should not be necessary in general,
     * as the component passes its HTML attribute props to it.
     */
    Scroller?: default_2.ComponentType<ScrollerProps & ContextProp<Context>>;
    /**
     * Set to render an item placeholder when the user scrolls fast.  See the `scrollSeek` property for more details.
     */
    ScrollSeekPlaceholder?: default_2.ComponentType<ScrollSeekPlaceholderProps & ContextProp<Context>>;
    /**
     * Set to customize the top list item wrapping element. Use if you would like to render list from elements different than a `div`
     * or you want to set a custom z-index for the sticky position.
     */
    TopItemList?: default_2.ComponentType<TopItemListProps & ContextProp<Context>>;
}

export declare type ComputeItemKey<D, C> = (index: number, item: D, context: C) => default_2.Key;

export declare interface ContextProp<C> {
    context: C;
}

export declare interface ElementDimensions {
    height: number;
    width: number;
}

/**
 * Passed to the Components.FillerRow custom component
 */
export declare interface FillerRowProps {
    height: number;
}

export declare type FixedFooterContent = (() => default_2.ReactNode) | null;

export declare type FixedHeaderContent = (() => default_2.ReactNode) | null;

export declare interface FlatIndexLocationWithAlign extends LocationOptions {
    /**
     * The index of the item to scroll to.
     */
    index: 'LAST' | number;
}

export declare interface FlatScrollIntoViewLocation extends ScrollIntoViewLocationOptions {
    index: number;
}

export declare type FollowOutput = FollowOutputCallback | FollowOutputScalarType;

export declare type FollowOutputCallback = (isAtBottom: boolean) => FollowOutputScalarType;

export declare type FollowOutputScalarType = 'auto' | 'smooth' | boolean;

export declare interface Gap {
    column: number;
    row: number;
}

export declare interface GridComponents<Context = any> {
    /**
     * Set to render a component at the bottom of the list.
     */
    Footer?: default_2.ComponentType<ContextProp<Context>>;
    /**
     * Set to render a component at the top of the list.
     *
     * The header remains above the top items and does not remain sticky.
     */
    Header?: default_2.ComponentType<ContextProp<Context>>;
    /**
     * Set to customize the item wrapping element. Use only if you would like to render list from elements different than a `div`.
     */
    Item?: default_2.ComponentType<GridItemProps & ContextProp<Context>>;
    /**
     * Set to customize the items wrapper. Use only if you would like to render list from elements different than a `div`.
     */
    List?: default_2.ComponentType<GridListProps & ContextProp<Context>>;
    /**
     * Set to customize the outermost scrollable element. This should not be necessary in general,
     * as the component passes its HTML attribute props to it.
     */
    Scroller?: default_2.ComponentType<ScrollerProps & ContextProp<Context>>;
    /**
     * Set to render an item placeholder when the user scrolls fast.
     * See the `scrollSeekConfiguration` property for more details.
     */
    ScrollSeekPlaceholder?: default_2.ComponentType<GridScrollSeekPlaceholderProps & ContextProp<Context>>;
}

export declare type GridComputeItemKey<D, C> = (index: number, item: D, context: C) => default_2.Key;

export declare type GridIndexLocation = FlatIndexLocationWithAlign | number;

export declare interface GridItem<D> {
    data?: D;
    index: number;
}

export declare type GridItemContent<D, C> = (index: number, data: D, context: C) => default_2.ReactNode;

/**
 * Passed to the Components.Item custom component
 */
export declare type GridItemProps = Pick<default_2.ComponentProps<'div'>, 'children' | 'className' | 'style'> & default_2.RefAttributes<HTMLDivElement> & {
    'data-index': number;
};

/**
 * Passed to the Components.List custom component
 */
export declare type GridListProps = Pick<default_2.ComponentProps<'div'>, 'children' | 'className' | 'style'> & default_2.RefAttributes<HTMLDivElement> & {
    'data-testid': string;
};

export declare type GridRootProps = Omit<default_2.HTMLProps<HTMLDivElement>, 'data' | 'ref'>;

/**
 * Passed to the GridComponents.ScrollSeekPlaceholder custom component
 */
export declare interface GridScrollSeekPlaceholderProps {
    height: number;
    index: number;
    width: number;
}

export declare interface GridStateSnapshot {
    gap: Gap;
    item: ElementDimensions;
    scrollTop: number;
    viewport: ElementDimensions;
}

export declare type GroupContent<C> = (index: number, context: C) => default_2.ReactNode;

export declare interface GroupedScrollIntoViewLocation extends ScrollIntoViewLocationOptions {
    groupIndex: number;
}

export declare const GroupedVirtuoso: <ItemData = any, Context = any>(props: GroupedVirtuosoProps<ItemData, Context> & {
    ref?: default_2.Ref<GroupedVirtuosoHandle>;
}) => default_2.ReactElement;

export declare interface GroupedVirtuosoHandle {
    autoscrollToBottom(): void;
    /**
     * Obtains the internal size state of the component, so that it can be restored later. This does not include the data items.
     */
    getState(stateCb: StateCallback): void;
    scrollBy(location: ScrollToOptions): void;
    scrollIntoView(location: number | ScrollIntoViewLocation): void;
    scrollTo(location: ScrollToOptions): void;
    scrollToIndex(location: IndexLocationWithAlign | number): void;
}

export declare interface GroupedVirtuosoProps<D, C> extends Omit<VirtuosoProps<D, C>, 'itemContent' | 'totalCount'> {
    /**
     * Use when implementing inverse infinite scrolling, decrease the value this property
     * in combination with a change in `groupCounts` to prepend groups items to the top of the list.
     * Both new groups and extending the top group is supported.
     *
     * The delta of the firstItemIndex should equal the amount of new items introduced, without the group themselves.
     * As an example, if you prepend 2 groups with 20 and 30 items each, the firstItemIndex should be decreased with 50.
     *
     * You can also prepend more items to the first group, for example:
     * `{ groupCounts: [20, 30], firstItemIndex: 1000 }` can become `{ groupCounts: [10, 30, 30], firstItemIndex: 980 }`
     *
     * Warning: the firstItemIndex should **be a positive number**, based on the total amount of items to be displayed.
     */
    firstItemIndex?: number;
    /**
     * Specifies how each each group header gets rendered. The callback receives the zero-based index of the group.
     */
    groupContent?: GroupContent<C>;
    /**
     * Specifies the amount of items in each group (and, actually, how many groups are there).
     * For example, passing [20, 30] will display 2 groups with 20 and 30 items each.
     */
    groupCounts?: number[];
    /**
     * Specifies how each each item gets rendered.
     */
    itemContent?: GroupItemContent<D, C>;
}

export declare interface GroupIndexLocationWithAlign extends LocationOptions {
    /**
     * The group index of the item to scroll to.
     */
    groupIndex: number;
}

export declare interface GroupItem<D> extends Item<D> {
    originalIndex?: number;
    type: 'group';
}

export declare type GroupItemContent<D, C> = (index: number, groupIndex: number, data: D, context: C) => default_2.ReactNode;

export declare type GroupProps = Pick<default_2.ComponentProps<'div'>, 'children' | 'style'> & {
    'data-index': number;
    'data-item-index': number;
    'data-known-size': number;
};

export declare type IndexLocationWithAlign = FlatIndexLocationWithAlign | GroupIndexLocationWithAlign;

export declare interface Item<D> {
    data?: D;
    index: number;
    offset: number;
    size: number;
}

export declare type ItemContent<D, C> = (index: number, data: D, context: C) => default_2.ReactNode;

export declare type ItemProps<D> = Pick<default_2.ComponentProps<'div'>, 'children' | 'style'> & {
    'data-index': number;
    'data-item-group-index'?: number;
    'data-item-index': number;
    'data-known-size': number;
    item: D;
};

export declare type ListItem<D> = GroupItem<D> | RecordItem<D>;

/**
 * Passed to the Components.List custom component
 */
export declare type ListProps = Pick<default_2.ComponentProps<'div'>, 'children' | 'style'> & default_2.RefAttributes<HTMLDivElement> & {
    'data-testid': string;
};

export declare interface ListRange {
    endIndex: number;
    startIndex: number;
}

export declare type ListRootProps = Omit<default_2.HTMLProps<HTMLDivElement>, 'data' | 'ref'>;

export declare interface LocationOptions {
    /**
     * How to position the item in the viewport.
     */
    align?: 'center' | 'end' | 'start';
    /**
     * Set 'smooth' to have an animated transition to the specified location.
     */
    behavior?: 'auto' | 'smooth';
    /**
     * The offset to scroll.
     */
    offset?: number;
}

export declare enum LogLevel {
    DEBUG = 0,
    INFO = 1,
    WARN = 2,
    ERROR = 3
}

export declare interface RecordItem<D> extends Item<D> {
    data?: D;
    groupIndex?: number;
    originalIndex?: number;
    type?: undefined;
}

export declare interface ScrollContainerState {
    scrollHeight: number;
    scrollTop: number;
    viewportHeight: number;
}

/**
 * Passed to the Components.Scroller custom component
 */
export declare type ScrollerProps = Pick<default_2.ComponentProps<'div'>, 'children' | 'style' | 'tabIndex'> & default_2.RefAttributes<HTMLDivElement> & {
    'data-testid'?: string;
    'data-virtuoso-scroller'?: boolean;
};

export declare type ScrollIntoViewLocation = FlatScrollIntoViewLocation | GroupedScrollIntoViewLocation;

export declare interface ScrollIntoViewLocationOptions {
    align?: 'center' | 'end' | 'start';
    behavior?: 'auto' | 'smooth';
    /**
     * Use this function to fine-tune the scrollIntoView behavior.
     * The function receives the item's top and bottom position in the viewport, and the viewport top/bottom.
     * Return an location object to scroll, or null to prevent scrolling.
     * Here's the default implementation:
     * ```ts
     const defaultCalculateViewLocation: CalculateViewLocation = ({
     itemTop,
     itemBottom,
     viewportTop,
     viewportBottom,
     locationParams: { behavior, align, ...rest },
     }) => {
     if (itemTop < viewportTop) {
     return { ...rest, behavior, align: align ?? 'start' }
     }
     if (itemBottom > viewportBottom) {
     return { ...rest, behavior, align: align ?? 'end' }
     }
     return null
     }
     *```
     */
    calculateViewLocation?: CalculateViewLocation;
    /**
     * Will be called when the scroll is done, or immediately if no scroll is needed.
     */
    done?: () => void;
}

export declare interface ScrollSeekConfiguration {
    /**
     * called during scrolling in scroll seek mode - use to display a hint where the list is.
     */
    change?: (velocity: number, range: ListRange) => void;
    /**
     * Callback to determine if the list should enter "scroll seek" mode.
     */
    enter: ScrollSeekToggle;
    /**
     * Callback to determine if the list should exit "scroll seek" mode.
     */
    exit: ScrollSeekToggle;
}

/**
 * Passed to the Components.ScrollSeekPlaceholder custom component
 */
export declare interface ScrollSeekPlaceholderProps {
    groupIndex?: number;
    height: number;
    index: number;
    type: 'group' | 'item';
}

export declare type ScrollSeekToggle = (velocity: number, range: ListRange) => boolean;

/** Calculates the height of `el`, which will be the `Item` element in the DOM. */
export declare type SizeFunction = (el: HTMLElement, field: 'offsetHeight' | 'offsetWidth') => number;

export declare interface SizeRange {
    endIndex: number;
    size: number;
    startIndex: number;
}

export declare type StateCallback = (state: StateSnapshot) => void;

export declare interface StateSnapshot {
    ranges: SizeRange[];
    scrollTop: number;
}

/**
 * Passed to the Components.TableBody custom component
 */
export declare type TableBodyProps = Pick<default_2.ComponentProps<'tbody'>, 'children' | 'className' | 'style'> & default_2.RefAttributes<HTMLTableSectionElement> & {
    'data-testid': string;
};

/**
 * Customize the TableVirtuoso rendering by passing a set of custom components.
 */
export declare interface TableComponents<Data = unknown, Context = unknown> {
    /**
     * Set to render a custom UI when the list is empty.
     */
    EmptyPlaceholder?: default_2.ComponentType<ContextProp<Context>>;
    /**
     * Set to render an empty item placeholder.
     */
    FillerRow?: default_2.ComponentType<FillerRowProps & ContextProp<Context>>;
    /**
     * Set to customize the outermost scrollable element. This should not be necessary in general,
     * as the component passes its HTML attribute props to it.
     */
    Scroller?: default_2.ComponentType<ScrollerProps & ContextProp<Context>>;
    /**
     * Set to render an item placeholder when the user scrolls fast.  See the `scrollSeek` property for more details.
     */
    ScrollSeekPlaceholder?: default_2.ComponentType<ScrollSeekPlaceholderProps & ContextProp<Context>>;
    /**
     * Set to customize the wrapping `table` element.
     *
     */
    Table?: default_2.ComponentType<TableProps & ContextProp<Context>>;
    /**
     * Set to customize the items wrapper. Default is `tbody`.
     */
    TableBody?: default_2.ComponentType<TableBodyProps & ContextProp<Context>>;
    /**
     * Set to render a fixed footer at the bottom of the table (`tfoot`). use [[fixedFooterContent]] to set the contents
     */
    TableFoot?: default_2.ComponentType<Pick<default_2.ComponentProps<'tfoot'>, 'children' | 'style'> & default_2.RefAttributes<HTMLTableSectionElement> & ContextProp<Context>>;
    /**
     * Set to render a fixed header at the top of the table (`thead`). use [[fixedHeaderContent]] to set the contents
     *
     */
    TableHead?: default_2.ComponentType<Pick<default_2.ComponentProps<'thead'>, 'children' | 'style'> & default_2.RefAttributes<HTMLTableSectionElement> & ContextProp<Context>>;
    /**
     * Set to customize the item wrapping element. Default is `tr`.
     */
    TableRow?: default_2.ComponentType<ItemProps<Data> & ContextProp<Context>>;
}

export declare type TableProps = Pick<default_2.ComponentProps<'table'>, 'children' | 'style'>;

export declare type TableRootProps = Omit<default_2.HTMLProps<HTMLTableElement>, 'data' | 'ref'>;

export declare const TableVirtuoso: <ItemData = any, Context = any>(props: TableVirtuosoProps<ItemData, Context> & {
    ref?: default_2.Ref<TableVirtuosoHandle>;
}) => default_2.ReactElement;

export declare interface TableVirtuosoHandle {
    /**
     * Obtains the internal size state of the component, so that it can be restored later. This does not include the data items.
     */
    getState(stateCb: StateCallback): void;
    scrollBy(location: ScrollToOptions): void;
    scrollIntoView(location: FlatScrollIntoViewLocation | number): void;
    scrollTo(location: ScrollToOptions): void;
    scrollToIndex(location: FlatIndexLocationWithAlign | number): void;
}

export declare interface TableVirtuosoProps<D, C> extends Omit<VirtuosoProps<D, C>, 'components' | 'headerFooterTag'> {
    /**
     * Setting `alignToBottom` to `true` aligns the items to the bottom of the list if the list is shorter than the viewport.
     * Use `followOutput` property to keep the list aligned when new items are appended.
     */
    alignToBottom?: boolean;
    /**
     * Called with true / false when the list has reached the bottom / gets scrolled up.
     * Can be used to load newer items, like `tail -f`.
     */
    atBottomStateChange?: (atBottom: boolean) => void;
    /**
     * By default `4`. Redefine to change how much away from the bottom the scroller can be before the list is not considered not at bottom.
     */
    atBottomThreshold?: number;
    /**
     * Called with `true` / `false` when the list has reached the top / gets scrolled down.
     */
    atTopStateChange?: (atTop: boolean) => void;
    /**
     * By default `0`. Redefine to change how much away from the top the scroller can be before the list is not considered not at top.
     */
    atTopThreshold?: number;
    /**
     * Use the `components` property for advanced customization of the elements rendered by the table.
     */
    components?: TableComponents<D, C>;
    /**
     * If specified, the component will use the function to generate the `key` property for each list item.
     */
    computeItemKey?: ComputeItemKey<D, C>;
    /**
     * Pass a reference to a scrollable parent element, so that the table won't wrap in its own.
     */
    customScrollParent?: HTMLElement;
    /**
     * The data items to be rendered. If data is set, the total count will be inferred from the length of the array.
     */
    data?: readonly D[];
    /**
     * By default, the component assumes the default item height from the first rendered item (rendering it as a "probe").
     *
     * If the first item turns out to be an outlier (very short or tall), the rest of the rendering will be slower,
     * as multiple passes of rendering should happen for the list to fill the viewport.
     *
     * Setting `defaultItemHeight` causes the component to skip the "probe" rendering and use the property
     * value as default height instead.
     */
    defaultItemHeight?: number;
    /**
     * Gets called when the user scrolls to the end of the list.
     * Receives the last item index as an argument. Can be used to implement endless scrolling.
     */
    endReached?: (index: number) => void;
    /**
     * Use when implementing inverse infinite scrolling - decrease the value this property
     * in combination with  `data` or `totalCount` to prepend items to the top of the list.
     *
     * Warning: the firstItemIndex should **be a positive number**, based on the total amount of items to be displayed.
     */
    firstItemIndex?: number;
    /**
     * Set the contents of the table footer.
     */
    fixedFooterContent?: FixedFooterContent;
    /**
     * Set the contents of the table header.
     */
    fixedHeaderContent?: FixedHeaderContent;
    /**
     * Can be used to improve performance if the rendered items are of known size.
     * Setting it causes the component to skip item measurements.
     */
    fixedItemHeight?: number;
    /**
     * If set to `true`, the list automatically scrolls to bottom if the total count is changed.
     * Set to `"smooth"` for an animated scrolling.
     *
     * By default, `followOutput` scrolls down only if the list is already at the bottom.
     * To implement an arbitrary logic behind that, pass a function:
     *
     * ```tsx
     * <Virtuoso
     *  followOutput={(isAtBottom: boolean) => {
     *    if (expression) {
     *      return 'smooth' // can be 'auto' or false to avoid scrolling
     *    } else {
     *      return false
     *    }
     *  }} />
     * ```
     */
    followOutput?: FollowOutput;
    /**
     * Set the increaseViewportBy property to artificially increase the viewport size, causing items to be rendered before outside of the viewport.
     * The property causes the component to render more items than the necessary, but can help with slow loading content.
     * Using `{ top?: number, bottom?: number }` lets you set the increase for each end separately.
     */
    increaseViewportBy?: number | {
        bottom: number;
        top: number;
    };
    /**
     * Use for server-side rendering - if set, the list will render the specified amount of items
     * regardless of the container / item size.
     */
    initialItemCount?: number;
    /**
     * Set this value to offset the initial location of the list.
     * Warning: using this property will still run a render cycle at the scrollTop: 0 list window.
     * If possible, avoid using it and stick to `initialTopMostItemIndex` instead.
     */
    initialScrollTop?: number;
    /**
     * Set to a value between 0 and totalCount - 1 to make the list start scrolled to that item.
     * Pass in an object to achieve additional effects similar to `scrollToIndex`.
     */
    initialTopMostItemIndex?: IndexLocationWithAlign | number;
    /**
     * Called when the list starts/stops scrolling.
     */
    isScrolling?: (isScrolling: boolean) => void;
    /**
     * Set the callback to specify the contents of the item.
     */
    itemContent?: ItemContent<D, C>;
    /**
     * Allows customizing the height/width calculation of `Item` elements.
     *
     * The default implementation reads `el.getBoundingClientRect().height` and `el.getBoundingClientRect().width`.
     */
    itemSize?: SizeFunction;
    /**
     * Called with the new set of items each time the list items are rendered due to scrolling.
     */
    itemsRendered?: (items: ListItem<D>[]) => void;
    /**
     * Set the overscan property to make the component "chunk" the rendering of new items on scroll.
     * The property causes the component to render more items than the necessary, but reduces the re-renders on scroll.
     * Setting `{ main: number, reverse: number }` lets you extend the list in both the main and the reverse scrollable directions.
     * See the `increaseViewportBy` property for a similar behavior (equivalent to the `overscan` in `react-window`).
     */
    overscan?: number | {
        main: number;
        reverse: number;
    };
    /**
     * Called with the new set of items each time the list items are rendered due to scrolling.
     */
    rangeChanged?: (range: ListRange) => void;
    /**
     * pass a state obtained from the getState() method to restore the list state - this includes the previously measured item sizes and the scroll location.
     * Notice that you should still pass the same data and totalCount properties as before, so that the list can match the data with the stored measurements.
     * This is useful when you want to keep the list state when the component is unmounted and remounted, for example when navigating to a different page.
     */
    restoreStateFrom?: StateSnapshot;
    /**
     * Provides access to the root DOM element
     */
    scrollerRef?: (ref: HTMLElement | null | Window) => any;
    /**
     * Use to display placeholders if the user scrolls fast through the list.
     *
     * Set `components.ScrollSeekPlaceholder` to change the placeholder content.
     */
    scrollSeekConfiguration?: false | ScrollSeekConfiguration;
    /**
     * Called when the user scrolls to the start of the list.
     */
    startReached?: (index: number) => void;
    /**
     * Set the amount of items to remain fixed at the top of the table.
     */
    topItemCount?: number;
    /**
     * The total amount of items to be rendered.
     */
    totalCount?: number;
    /**
     * Called when the total list height is changed due to new items or viewport resize.
     */
    totalListHeightChanged?: (height: number) => void;
    /**
     * Uses the document scroller rather than wrapping the list in its own.
     */
    useWindowScroll?: boolean;
}

export declare type TopItemListProps = Pick<default_2.ComponentProps<'div'>, 'children' | 'style'>;

export declare const Virtuoso: <ItemData = any, Context = any>(props: VirtuosoProps<ItemData, Context> & {
    ref?: default_2.Ref<VirtuosoHandle>;
}) => default_2.ReactElement;

export declare const VirtuosoGrid: <ItemData = any, Context = any>(props: VirtuosoGridProps<ItemData, Context> & {
    ref?: default_2.Ref<VirtuosoGridHandle>;
}) => default_2.ReactElement;

export declare interface VirtuosoGridHandle {
    scrollBy(location: ScrollToOptions): void;
    scrollTo(location: ScrollToOptions): void;
    scrollToIndex(location: GridIndexLocation): void;
}

export declare const VirtuosoGridMockContext: default_2.Context<VirtuosoGridMockContextValue | undefined>;

export declare interface VirtuosoGridMockContextValue {
    itemHeight: number;
    itemWidth: number;
    viewportHeight: number;
    viewportWidth: number;
}

export declare interface VirtuosoGridProps<D, C = unknown> extends GridRootProps {
    /**
     * Called with true / false when the list has reached the bottom / gets scrolled up.
     * Can be used to load newer items, like `tail -f`.
     */
    atBottomStateChange?: (atBottom: boolean) => void;
    /**
     * Called with `true` / `false` when the list has reached the top / gets scrolled down.
     */
    atTopStateChange?: (atTop: boolean) => void;
    /**
     * Use the `components` property for advanced customization of the elements rendered by the list.
     */
    components?: GridComponents<C>;
    /**
     * If specified, the component will use the function to generate the `key` property for each list item.
     */
    computeItemKey?: GridComputeItemKey<D, C>;
    /**
     * Additional context available in the custom components and content callbacks
     */
    context?: C;
    /**
     * Pass a reference to a scrollable parent element, so that the grid won't wrap in its own.
     */
    customScrollParent?: HTMLElement;
    /**
     * The data items to be rendered. If data is set, the total count will be inferred from the length of the array.
     */
    data?: readonly D[];
    /**
     * Gets called when the user scrolls to the end of the list.
     * Receives the last item index as an argument. Can be used to implement endless scrolling.
     */
    endReached?: (index: number) => void;
    /**
     *
     * *The property accepts pixel values.*
     *
     * Set the increaseViewportBy property to artificially increase the viewport size, causing items to be rendered before outside of the viewport.
     * The property causes the component to render more items than the necessary, but can help with slow loading content.
     * Using `{ top?: number, bottom?: number }` lets you set the increase for each end separately.
     *
     */
    increaseViewportBy?: number | {
        bottom: number;
        top: number;
    };
    /**
     * Use for server-side rendering - if set, the list will render the specified amount of items
     * regardless of the container / item size.
     */
    initialItemCount?: number;
    initialTopMostItemIndex?: GridIndexLocation;
    /**
     * Called when the list starts/stops scrolling.
     */
    isScrolling?: (isScrolling: boolean) => void;
    /**
     * Sets the grid items' className
     */
    itemClassName?: string;
    /**
     * Set the callback to specify the contents of the item.
     */
    itemContent?: GridItemContent<D, C>;
    /**
     * Sets the className for the list DOM element
     */
    listClassName?: string;
    /**
     * set to LogLevel.DEBUG to enable various diagnostics in the console, the most useful being the item measurement reports.
     *
     * Ensure that you have "all levels" enabled in the browser console too see the messages.
     */
    logLevel?: LogLevel;
    /**
     * Set the overscan property to make the component "chunk" the rendering of new items on scroll.
     * The property causes the component to render more items than the necessary, but reduces the re-renders on scroll.
     * Setting `{ main: number, reverse: number }` lets you extend the grid in both the main and the reverse scrollable directions.
     * See the `increaseViewportBy` property for a similar behavior (equivalent to the `overscan` in react-window).
     */
    overscan?: number | {
        main: number;
        reverse: number;
    };
    /**
     * Called with the new set of items each time the list items are rendered due to scrolling.
     */
    rangeChanged?: (range: ListRange) => void;
    /**
     * invoked with true after the grid has done the initial render and the items have been measured.
     */
    readyStateChanged?: (ready: boolean) => void;
    restoreStateFrom?: GridStateSnapshot | null | undefined;
    /**
     * Provides access to the root DOM element
     */
    scrollerRef?: (ref: HTMLElement | null) => any;
    /**
     * Use to display placeholders if the user scrolls fast through the list.
     *
     * Set `components.ScrollSeekPlaceholder` to change the placeholder content.
     */
    scrollSeekConfiguration?: false | ScrollSeekConfiguration;
    /**
     * Called when the user scrolls to the start of the list.
     */
    startReached?: (index: number) => void;
    /**
     * reports when the grid state changes. The reported value can be stored and passed back to `restoreStateFrom` to restore the grid to the same state.
     */
    stateChanged?: (state: GridStateSnapshot) => void;
    /**
     * The total amount of items to be rendered.
     */
    totalCount?: number;
    /**
     * Uses the document scroller rather than wrapping the grid in its own.
     */
    useWindowScroll?: boolean;
}

export declare interface VirtuosoHandle {
    /**
     * Use this with combination with follow output if you have images loading in the list. Listen to the image loading and call the method.
     */
    autoscrollToBottom(): void;
    /**
     * Obtains the internal size state of the component, so that it can be restored later. This does not include the data items.
     */
    getState(stateCb: StateCallback): void;
    /**
     * Scrolls the component with the specified amount. See [ScrollToOptions (MDN)](https://developer.mozilla.org/en-US/docs/Web/API/ScrollToOptions)
     */
    scrollBy(location: ScrollToOptions): void;
    /**
     * Scrolls the item into view if necessary. See [the website example](http://virtuoso.dev/keyboard-navigation/) for an implementation.
     */
    scrollIntoView(location: FlatScrollIntoViewLocation): void;
    /**
     * Scrolls the component to the specified location. See [ScrollToOptions (MDN)](https://developer.mozilla.org/en-US/docs/Web/API/ScrollToOptions)
     */
    scrollTo(location: ScrollToOptions): void;
    /**
     * Scrolls the component to the specified item index. See {@link IndexLocationWithAlign} for more options.
     */
    scrollToIndex(location: FlatIndexLocationWithAlign | number): void;
}

export declare const VirtuosoMockContext: default_2.Context<VirtuosoMockContextValue | undefined>;

export declare interface VirtuosoMockContextValue {
    itemHeight: number;
    viewportHeight: number;
}

export declare interface VirtuosoProps<D, C> extends ListRootProps {
    /**
     * Setting `alignToBottom` to `true` aligns the items to the bottom of the list if the list is shorter than the viewport.
     * Use `followOutput` property to keep the list aligned when new items are appended.
     */
    alignToBottom?: boolean;
    /**
     * Called with true / false when the list has reached the bottom / gets scrolled up.
     * Can be used to load newer items, like `tail -f`.
     */
    atBottomStateChange?: (atBottom: boolean) => void;
    /**
     * *The property accepts pixel values.*
     *
     * By default `4`. Redefine to change how much away from the bottom the scroller can be before the list is not considered not at bottom.
     */
    atBottomThreshold?: number;
    /**
     * Called with `true` / `false` when the list has reached the top / gets scrolled down.
     */
    atTopStateChange?: (atTop: boolean) => void;
    /**
     * *The property accepts pixel values.*
     *
     * By default `0`. Redefine to change how much away from the top the scroller can be before the list is not considered not at top.
     */
    atTopThreshold?: number;
    /**
     * Use the `components` property for advanced customization of the elements rendered by the list.
     */
    components?: Components<D, C>;
    /**
     * If specified, the component will use the function to generate the `key` property for each list item.
     */
    computeItemKey?: ComputeItemKey<D, C>;
    /**
     * Additional context available in the custom components and content callbacks
     */
    context?: C;
    /**
     * Pass a reference to a scrollable parent element, so that the list won't wrap in its own.
     */
    customScrollParent?: HTMLElement;
    /**
     * The data items to be rendered. If data is set, the total count will be inferred from the length of the array.
     */
    data?: readonly D[];
    /**
     * By default, the component assumes the default item height from the first rendered item (rendering it as a "probe").
     *
     * If the first item turns out to be an outlier (very short or tall), the rest of the rendering will be slower,
     * as multiple passes of rendering should happen for the list to fill the viewport.
     *
     * Setting `defaultItemHeight` causes the component to skip the "probe" rendering and use the property
     * value as default height instead.
     */
    defaultItemHeight?: number;
    /**
     * Gets called when the user scrolls to the end of the list.
     * Receives the last item index as an argument. Can be used to implement endless scrolling.
     */
    endReached?: (index: number) => void;
    /**
     * Use when implementing inverse infinite scrolling - decrease the value this property
     * in combination with  `data` or `totalCount` to prepend items to the top of the list.
     *
     * Warning: the firstItemIndex should **be a positive number**, based on the total amount of items to be displayed.
     */
    firstItemIndex?: number;
    /**
     * Can be used to improve performance if the rendered items are of known size.
     * Setting it causes the component to skip item measurements.
     */
    fixedItemHeight?: number;
    /**
     * If set to `true`, the list automatically scrolls to bottom if the total count is changed.
     * Set to `"smooth"` for an animated scrolling.
     *
     * By default, `followOutput` scrolls down only if the list is already at the bottom.
     * To implement an arbitrary logic behind that, pass a function:
     *
     * ```tsx
     * <Virtuoso
     *  followOutput={(isAtBottom: boolean) => {
     *    if (expression) {
     *      return 'smooth' // can be 'auto' or false to avoid scrolling
     *    } else {
     *      return false
     *    }
     *  }} />
     * ```
     */
    followOutput?: FollowOutput;
    /**
     * Set to customize the wrapper tag for the header and footer components (default is `div`).
     */
    headerFooterTag?: string;
    /**
     * When set, turns the scroller into a horizontal list. The items are positioned with `inline-block`.
     */
    horizontalDirection?: boolean;
    /**
     *
     * *The property accepts pixel values.*
     *
     * Set the increaseViewportBy property to artificially increase the viewport size, causing items to be rendered before outside of the viewport.
     * The property causes the component to render more items than the necessary, but can help with slow loading content.
     * Using `{ top?: number, bottom?: number }` lets you set the increase for each end separately.
     *
     */
    increaseViewportBy?: number | {
        bottom: number;
        top: number;
    };
    /**
     * Use for server-side rendering - if set, the list will render the specified amount of items
     * regardless of the container / item size.
     */
    initialItemCount?: number;
    /**
     * Set this value to offset the initial location of the list.
     * Warning: using this property will still run a render cycle at the scrollTop: 0 list window.
     * If possible, avoid using it and stick to `initialTopMostItemIndex` instead.
     */
    initialScrollTop?: number;
    /**
     * Set to a value between 0 and totalCount - 1 to make the list start scrolled to that item.
     * Pass in an object to achieve additional effects similar to `scrollToIndex`.
     */
    initialTopMostItemIndex?: IndexLocationWithAlign | number;
    /**
     * Called when the list starts/stops scrolling.
     */
    isScrolling?: (isScrolling: boolean) => void;
    /**
     * Set the callback to specify the contents of the item.
     */
    itemContent?: ItemContent<D, C>;
    /**
     * Allows customizing the height/width calculation of `Item` elements.
     *
     * The default implementation reads `el.getBoundingClientRect().height` and `el.getBoundingClientRect().width`.
     */
    itemSize?: SizeFunction;
    /**
     * Called with the new set of items each time the list items are rendered due to scrolling.
     */
    itemsRendered?: (items: ListItem<D>[]) => void;
    /**
     * set to LogLevel.DEBUG to enable various diagnostics in the console, the most useful being the item measurement reports.
     *
     * Ensure that you have "all levels" enabled in the browser console too see the messages.
     */
    logLevel?: LogLevel;
    /**
     * *The property accepts pixel values.*
     *
     * Set the overscan property to make the component "chunk" the rendering of new items on scroll.
     * The property causes the component to render more items than the necessary, but reduces the re-renders on scroll.
     * Setting `{ main: number, reverse: number }` lets you extend the list in both the main and the reverse scrollable directions.
     * See the `increaseViewportBy` property for a similar behavior (equivalent to the `overscan` in react-window).
     *
     */
    overscan?: number | {
        main: number;
        reverse: number;
    };
    /**
     * Called with the new set of items each time the list items are rendered due to scrolling.
     */
    rangeChanged?: (range: ListRange) => void;
    /**
     * pass a state obtained from the getState() method to restore the list state - this includes the previously measured item sizes and the scroll location.
     * Notice that you should still pass the same data and totalCount properties as before, so that the list can match the data with the stored measurements.
     * This is useful when you want to keep the list state when the component is unmounted and remounted, for example when navigating to a different page.
     */
    restoreStateFrom?: StateSnapshot;
    /**
     * Provides access to the root DOM element
     */
    scrollerRef?: (ref: HTMLElement | null | Window) => any;
    /**
     * Use to display placeholders if the user scrolls fast through the list.
     *
     * Set `components.ScrollSeekPlaceholder` to change the placeholder content.
     */
    scrollSeekConfiguration?: false | ScrollSeekConfiguration;
    /**
     * When set, the resize observer used to measure the items will not use `requestAnimationFrame` to report the size changes.
     * Setting this to true will improve performance and reduce flickering, but will cause benign errors to be reported in the console if the size of the items changes while they are being measured.
     * See https://github.com/petyosi/react-virtuoso/issues/1049 for more information.
     */
    skipAnimationFrameInResizeObserver?: boolean;
    /**
     * Called when the user scrolls to the start of the list.
     */
    startReached?: (index: number) => void;
    /**
     * Set the amount of items to remain fixed at the top of the list.
     *
     * For a header that scrolls away when scrolling, check the `components.Header` property.
     */
    topItemCount?: number;
    /**
     * The total amount of items to be rendered.
     */
    totalCount?: number;
    /**
     * Called when the total list height is changed due to new items or viewport resize.
     */
    totalListHeightChanged?: (height: number) => void;
    /**
     * Uses the document scroller rather than wrapping the list in its own.
     */
    useWindowScroll?: boolean;
}

export declare interface WindowViewportInfo {
    offsetTop: number;
    visibleHeight: number;
    visibleWidth: number;
}

export { }

declare namespace _default {
    let stories: string[];
}
