<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class TbkDashboardTile extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tbk_dashboard_tile', function (Blueprint $table) {
            $table->bigIncrements('tbk_id');
            $table->bigInteger('dt_id');
            $table->bigInteger('dt_settings_id');
            $table->string('dt_static_tile',50)->nullable()->collation('utf8_unicode_ci');
            $table->string('dt_title',50)->collation('utf8_unicode_ci');
            $table->char('dt_color_option', 1)->collation('utf8_unicode_ci');
            $table->string('dt_color',10)->collation('utf8_unicode_ci');
            $table->string('dt_icon',30)->collation('utf8_unicode_ci');
            $table->char('dt_layout', 1)->collation('utf8_unicode_ci');
            $table->char('dt_revised_type', 1)->collation('utf8_unicode_ci');
            $table->char('dt_status_submitted', 1)->nullable()->collation('utf8_unicode_ci');
            $table->char('dt_submitted_author', 1)->nullable()->collation('utf8_unicode_ci');
            $table->char('dt_no_result', 1)->default('y')->collation('utf8_unicode_ci');
            $table->text('dt_art_type')->nullable()->collation('utf8_unicode_ci');
            $table->text('dt_data')->collation('utf8_unicode_ci');
            $table->bigInteger('dt_posted_by');
            $table->dateTime('dt_posted_date');
            $table->bigInteger('dt_proxy_id');
            $table->char('dt_operation',1)->comment('u-update,i-insert')->collation('utf8_unicode_ci');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('tbk_dashboard_tile');
    }
}
