<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
      DB::beginTransaction();
        try
        {
        DB::statement("ALTER TABLE `rvw_generic_discussion` ADD `gdis_dsctp_id` BIGINT(20)  UNSIGNED NOT NULL COMMENT 'pk of rvw_discussion_type' AFTER `gdis_art_id`");
        DB::statement("ALTER TABLE `tbk_generic_discussion` ADD `gdis_dsctp_id` BIGINT(20) UNSIGNED NOT NULL AFTER `gdis_art_id`");
        DB::statement("ALTER TABLE `rvw_generic_discussion` CHANGE `gdis_dsctp_id` `gdis_dsctp_id` BIGINT(20) UNSIGNED NULL DEFAULT NULL COMMENT 'pk of rvw_discussion_type'");
        DB::statement("ALTER TABLE `tbk_generic_discussion` CHANGE `gdis_dsctp_id` `gdis_dsctp_id` BIGINT(20) UNSIGNED NULL DEFAULT NULL");
        DB::statement("ALTER TABLE `rvw_discussion_type` CHANGE `dsctp_role_id` `dsctp_role_id` TEXT CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL COMMENT 'pk of rvw_roles'");
        DB::statement("ALTER TABLE `tbk_discussion_type` CHANGE `dsctp_role_id` `dsctp_role_id` TEXT CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL");
        DB::statement("CREATE TABLE IF NOT EXISTS  `rvw_email_deeplink_click_tracking` (
            `edt_id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
            `edt_ip` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
            `edt_browser` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
            `edt_os` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
            `edt_deeplink_token` varchar(500) COLLATE utf8_unicode_ci NOT NULL,
            `edt_action_type` char(3) COLLATE utf8_unicode_ci NOT NULL COMMENT 'ec-email confirmation,url-user url email confirmation,ra-review accpet,rr-review reject,ap-article proposal',
            `edt_posted_by` bigint(20) UNSIGNED NOT NULL COMMENT 'pk of rvw_user',
            `edt_posted_date` datetime NOT NULL,
            `edt_proxy_id` bigint(20) NOT NULL,
            `edt_operation` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'u' COMMENT 'u-update,i-insert',
          PRIMARY KEY (`edt_id`)
          ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci");
        DB::statement("CREATE TABLE IF NOT EXISTS  `rvw_password_history` (
            `pash_id` bigint(20) NOT NULL,
            `pash_usr_id` bigint(20) NOT NULL,
            `pash_pwd` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
            `pash_posted_by` bigint(20) NOT NULL,
            `pash_posted_date` datetime NOT NULL,
            `pash_proxy_id` bigint(20) NOT NULL,
            `pash_operation` varchar(1) COLLATE utf8_unicode_ci NOT NULL
          ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='This is to store password history of the users'");
        DB::statement("ALTER TABLE `rvw_password_history` ADD PRIMARY KEY (`pash_id`)");
        DB::statement("ALTER TABLE `rvw_password_history` MODIFY `pash_id` bigint(20) NOT NULL AUTO_INCREMENT;");
        // DB::statement("ALTER TABLE `rvw_discussion_type` CHANGE `dsctp_role_id` `dsctp_role_id` TEXT CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL COMMENT 'pk of rvw_roles';");
        DB::statement("ALTER TABLE `tbk_discussion_type` CHANGE `dsctp_role_id` `dsctp_role_id` TEXT CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL ;");
        }
        catch(\Exception $e)
        {
          throw new \Exception($e->getTraceAsString());
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('rvw_email_deeplink_click_tracking');
        Schema::dropIfExists('rvw_password_history');
        /*
        ALTER TABLE `rvw_generic_discussion` DROP `gdis_dsctp_id`;
        ALTER TABLE `tbk_generic_discussion` DROP `gdis_dsctp_id`;
        */
    }
};
