<?php

use Illuminate\Database\Migrations\Migration;
use App\Http\Controllers\Controller;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        /*missing #169*/
        DB::beginTransaction();
        try
        {
            $client_code=(new Controller())->get_client_details('clnt_client_code');
            if($client_code->clnt_client_code=='lepra'){
            DB::statement("ALTER TABLE `rvw_issues` ADD `iss_start_date` DATETIME NULL AFTER `iss_due_date`, ADD `iss_soft_end_date` DATETIME NULL AFTER `iss_start_date`, ADD `iss_hard_end_date` DATETIME NULL AFTER `iss_soft_end_date`, ADD `iss_art_type` VARCHAR(250) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT '[]' AFTER `iss_hard_end_date`;");
            DB::statement("ALTER TABLE `tbk_issues` ADD `iss_start_date` DATETIME NULL AFTER `iss_due_date`, ADD `iss_soft_end_date` DATETIME NULL AFTER `iss_start_date`, ADD `iss_hard_end_date` DATETIME NULL AFTER `iss_soft_end_date`, ADD `iss_art_type` VARCHAR(250) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT '[]' AFTER `iss_hard_end_date`;");
            }
            DB::statement("ALTER TABLE `rvw_article_flow` ADD `aflw_chapter_next_stages` TEXT NULL DEFAULT NULL COMMENT 'For book workflow, after successfully validating current stage jwf_id of child stages are added in this column. Which is used in the master chapter-view page to submit multiple chapters to next stage' AFTER `aflw_usr_review_reopen`;");
            DB::statement("ALTER TABLE `tbk_article_flow` ADD `aflw_chapter_next_stages` TEXT NULL DEFAULT NULL COMMENT 'For book workflow, after successfully validating current stage jwf_id of child stages are added in this column. Which is used in the master chapter-view page to submit multiple chapters to next stage' AFTER `aflw_usr_review_reopen`;");
            DB::statement("ALTER TABLE `rvw_article_types` CHANGE `artp_book_short_title` `artp_book_short_title` VARCHAR(200) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT 'short title of book';");
            DB::statement("ALTER TABLE `tbk_article_types` CHANGE `artp_book_short_title` `artp_book_short_title` VARCHAR(200) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT 'short title of book';");
            DB::statement("ALTER TABLE `rvw_article_notes` ADD `an_note_by_proposal` CHAR(5) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n' AFTER `an_read_users`;");
            DB::statement("ALTER TABLE `tbk_article_notes`  ADD `an_note_by_proposal` CHAR(5) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n'  AFTER `an_read_users`;");
            DB::statement("ALTER TABLE `rvw_article_types` ADD `artp_eproduct_code` VARCHAR(30) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT 'eproduct code of book' AFTER `artp_abbr_article_type`;");
            DB::statement("ALTER TABLE `tbk_article_types` ADD `artp_eproduct_code` VARCHAR(30) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT 'eproduct code of book' AFTER `artp_abbr_article_type`;");
            DB::statement("UPDATE `rvw_journal_metadata` SET `jm_meta_value` = 'in' WHERE `jm_meta_name` = 'unt_mesrmnt_pg_sz' and `jm_meta_value` LIKE 'inch';");
            DB::statement("ALTER TABLE `rvw_stage_email_tmpls` ADD `stage_etmp_remind_after` CHAR(1) NULL COMMENT 'send reminder email after due date/accepted date/invitation date' AFTER `stage_etmp_remind_months`;");
            DB::statement("ALTER TABLE `tbk_stage_email_tmpls`  ADD `stage_etmp_remind_after` CHAR(1) NULL COMMENT 'send reminder email after due date/accepted date/invitation date'  AFTER `stage_etmp_remind_months`;");
            DB::statement("ALTER TABLE `rvw_article_flow` CHANGE `aflw_clk_count` `aflw_decline_clk_count` INT(11) UNSIGNED NOT NULL DEFAULT '0';");
            DB::statement("ALTER TABLE `tbk_article_flow` CHANGE `aflw_clk_count` `aflw_decline_clk_count` INT(11) UNSIGNED NOT NULL DEFAULT '0';");
            
            DB::statement("ALTER TABLE `rvw_article_flow` ADD `aflw_accept_clk_count` INT(11) UNSIGNED NOT NULL DEFAULT '0' AFTER `aflw_decline_clk_count`;");
            DB::statement("ALTER TABLE `tbk_article_flow` ADD `aflw_accept_clk_count` INT(11) UNSIGNED NOT NULL DEFAULT '0' AFTER `aflw_decline_clk_count`;");
        }
        catch(\Exception $e)
        {
            throw new \Exception($e->getTraceAsString());
        }
       
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        /*
        ALTER TABLE `rvw_article_flow` DROP `aflw_chapter_next_stages`;
        ALTER TABLE `tbk_article_flow` DROP `aflw_chapter_next_stages`;
        ALTER TABLE `rvw_issues` DROP `iss_start_date`;
        ALTER TABLE `tbk_issues` DROP `iss_start_date`;
        ALTER TABLE `rvw_issues` DROP `iss_soft_end_date`;
        ALTER TABLE `tbk_issues` DROP `iss_soft_end_date`;
        ALTER TABLE `rvw_issues` DROP `iss_hard_end_date`;
        ALTER TABLE `tbk_issues` DROP `iss_hard_end_date`;
        ALTER TABLE `rvw_issues` DROP `iss_art_type`;
        ALTER TABLE `tbk_issues` DROP `iss_art_type`;
        ALTER TABLE `rvw_article_notes` DROP `an_note_by_proposal`;
        ALTER TABLE `tbk_article_notes` DROP `an_note_by_proposal`;
        ALTER TABLE `rvw_article_types` DROP `artp_eproduct_code`;
        ALTER TABLE `tbk_article_types` DROP `artp_eproduct_code`;
        ALTER TABLE `rvw_article_types` DROP `artp_eproduct_code`;
        ALTER TABLE `tbk_article_types` DROP `artp_eproduct_code`;
        ALTER TABLE `rvw_stage_email_tmpls` DROP `stage_etmp_remind_after`;
        ALTER TABLE `tbk_stage_email_tmpls` DROP `stage_etmp_remind_after`;
        ALTER TABLE `rvw_article_flow` DROP `aflw_accept_clk_count`;
        ALTER TABLE `tbk_article_flow` DROP `aflw_accept_clk_count`;
        */
    }
};
