<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasColumn('rvw_currency_master', 'curr_posted_date'))
        {
            Schema::table('rvw_currency_master', function (Blueprint $table) {
                $table->string('curr_status', 1)->default('y')->after('curr_code')->comment('yes:y,no:n');
                $table->timestamp('curr_posted_date')->after('curr_status')->useCurrent();
                $table->char('curr_operation', 1)->after('curr_posted_date')->default('n');        
            });
        }
        if (!Schema::hasColumn('tbk_currency_master', 'curr_posted_date'))
        {
            Schema::table('tbk_currency_master', function (Blueprint $table) {
                $table->string('curr_status', 1)->default('y')->after('curr_code')->comment('yes:y,no:n');
                $table->timestamp('curr_posted_date')->after('curr_status')->useCurrent();
                $table->char('curr_operation', 1)->after('curr_posted_date')->default('n');              
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (Schema::hasColumn('rvw_currency_master', 'curr_posted_date'))
        {
            Schema::table('rvw_currency_master', function (Blueprint $table) {
                $table->dropColumn('curr_status');
                $table->dropColumn('curr_posted_date');
                $table->dropColumn('curr_operation');        
            });
        }
        if (Schema::hasColumn('tbk_currency_master', 'curr_posted_date'))
        {
            Schema::table('tbk_currency_master', function (Blueprint $table) {
                $table->dropColumn('curr_status');
                $table->dropColumn('curr_posted_date');     
                $table->dropColumn('curr_operation');   
            });
        }
    }
};
