<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasColumn('rvw_article_custom_reasons', 'cusr_status_change_by'))
        {
            Schema::table('rvw_article_custom_reasons', function (Blueprint $table) {
                $table->bigInteger('cusr_status_change_by')->after('cusr_status')->nullable(); 
                $table->text('cusr_status_change_reason')->after('cusr_status_change_by')->nullable();     
            });
        }
        if (!Schema::hasColumn('tbk_article_custom_reasons', 'cusr_status_change_by'))
        {
            Schema::table('tbk_article_custom_reasons', function (Blueprint $table) {
                $table->bigInteger('cusr_status_change_by')->after('cusr_status')->nullable(); 
                $table->text('cusr_status_change_reason')->after('cusr_status_change_by')->nullable();            
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (Schema::hasColumn('rvw_article_custom_reasons', 'cusr_status_change_by'))
        {
            Schema::table('rvw_article_custom_reasons', function (Blueprint $table) {
                $table->dropColumn('cusr_status_change_by');      
                $table->dropColumn('cusr_status_change_reason');
            });
        }
        if (Schema::hasColumn('tbk_article_custom_reasons', 'cusr_status_change_by'))
        {
            Schema::table('tbk_article_custom_reasons', function (Blueprint $table) {
                $table->dropColumn('cusr_status_change_by');
                $table->dropColumn('cusr_status_change_reason');            
            });
        }
    }
};
