<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {

       
        DB::statement("CREATE TABLE IF NOT EXISTS  `rvw_article_rating` (
            `rat_id` bigint UNSIGNED NOT NULL PRIMARY KEY AUTO_INCREMENT,
            `rat_art_id` bigint UNSIGNED NOT NULL COMMENT 'pk of rvw_articles',
            `rat_aflw_id` bigint UNSIGNED NOT NULL COMMENT 'pk of rvw_article_flow',
            `rat_rated_by` bigint UNSIGNED NOT NULL COMMENT 'pk of rvw_users',
            `rat_star_value` FLOAT NULL DEFAULT 0,
            `rat_posted_by` bigint UNSIGNED NOT NULL,
            `rat_posted_date` datetime NOT NULL,
            `rat_proxy_id` bigint NOT NULL,
            `rat_operation` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'u' COMMENT 'u-update,i-insert'
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
        ");

        DB::statement("CREATE TABLE IF NOT EXISTS  `tbk_article_rating` (
            `rat_id` bigint UNSIGNED NOT NULL PRIMARY KEY AUTO_INCREMENT,
            `rat_art_id` bigint UNSIGNED NOT NULL COMMENT 'pk of rvw_articles',
            `rat_aflw_id` bigint UNSIGNED NOT NULL COMMENT 'pk of rvw_article_flow',
            `rat_rated_by` bigint UNSIGNED NOT NULL COMMENT 'pk of rvw_users',
            `rat_star_value` FLOAT NULL DEFAULT 0,
            `rat_posted_by` bigint UNSIGNED NOT NULL,
            `rat_posted_date` datetime NOT NULL,
            `rat_proxy_id` bigint NOT NULL,
            `rat_operation` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'u' COMMENT 'u-update,i-insert',
            `tbk_id` int UNSIGNED NOT NULL
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
        ");
           
           DB::unprepared('
            CREATE TRIGGER trg_article_rating_after_insert AFTER INSERT ON `rvw_article_rating` FOR EACH ROW
            BEGIN
            INSERT INTO tbk_article_rating SELECT *,NULL tbk_id FROM rvw_article_rating WHERE rat_id= NEW.rat_id;
            END
        ');
        DB::unprepared("
            CREATE TRIGGER trg_article_rating_after_update AFTER UPDATE ON `rvw_article_rating` FOR EACH ROW
            BEGIN
            IF (NEW.rat_operation != 'm') THEN INSERT INTO tbk_article_rating SELECT *,NULL tbk_id FROM rvw_article_rating WHERE rat_id= OLD.rat_id;
            END IF;
            END
        ");     
 
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('rvw_article_rating');
        Schema::dropIfExists('tbk_article_rating');
    }
};
