<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
       try {
        Schema::table('rvw_articles', function (Blueprint $table) {
            // Change the column type and character set
            $table->string('art_title', 2000)
                ->charset('utf8mb4')
                ->collation('utf8mb4_unicode_ci')
                ->nullable(false)
                ->change();
        });
        Schema::table('tbk_articles', function (Blueprint $table) {
            // Change the column type and character set
            $table->string('art_title', 2000)
                ->charset('utf8mb4')
                ->collation('utf8mb4_unicode_ci')
                ->nullable(false)
                ->change();
        });
       } catch (\Exception $e) {
        DB::rollback();
       }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
