<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     * alter rvw_journal_settings , rvw_article_type_advance_options tables and its tbk tables
     */
    public function up(): void
    {
        try
        {
            DB::statement("ALTER TABLE `rvw_journal_settings` ADD `jset_ith_v2_add_to_index` JSON NULL DEFAULT NULL COMMENT 'ith_v2 indexing_settings options' AFTER `jset_ith_v2_view_settings`;");
            DB::statement("ALTER TABLE `tbk_journal_settings` ADD `jset_ith_v2_add_to_index` JSON NULL DEFAULT NULL COMMENT 'ith_v2 indexing_settings options' AFTER `jset_ith_v2_view_settings`;");

            DB::statement("ALTER TABLE `rvw_journal_settings` ADD `jset_ith_v2_save_changes` JSON NULL DEFAULT NULL COMMENT 'ith_v2 similarity_view_settings options' AFTER `jset_ith_v2_add_to_index`;");
            DB::statement("ALTER TABLE `tbk_journal_settings` ADD `jset_ith_v2_save_changes` JSON NULL DEFAULT NULL COMMENT 'ith_v2 similarity_view_settings options' AFTER `jset_ith_v2_add_to_index`;");

            DB::statement("ALTER TABLE `rvw_article_type_advance_options` ADD `atotp_ith_v2_add_to_index` JSON NULL DEFAULT NULL COMMENT 'ith_v2 indexing_settings options' AFTER `atotp_ith_v2_view_settings`;");
            DB::statement("ALTER TABLE `tbk_article_type_advance_options` ADD `atotp_ith_v2_add_to_index` JSON NULL DEFAULT NULL COMMENT 'ith_v2 indexing_settings options' AFTER `atotp_ith_v2_view_settings`;");

            DB::statement("ALTER TABLE `rvw_article_type_advance_options` ADD `atotp_ith_v2_save_changes` JSON NULL DEFAULT NULL COMMENT 'ith_v2 similarity_view_settings options' AFTER `atotp_ith_v2_add_to_index`;");
            DB::statement("ALTER TABLE `tbk_article_type_advance_options` ADD `atotp_ith_v2_save_changes` JSON NULL DEFAULT NULL COMMENT 'ith_v2 similarity_view_settings options' AFTER `atotp_ith_v2_add_to_index`;");

            DB::statement("ALTER TABLE `rvw_article_pdf` ADD `pdf_ith_v2_fileupload_status` CHAR(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n' COMMENT 'n-no,y-yes ,after successfull upload of pdf into ith_v2 then marked as y ' AFTER `pdf_ith_submission_status`;");
            DB::statement("ALTER TABLE `tbk_article_pdf` ADD `pdf_ith_v2_fileupload_status` CHAR(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n' COMMENT 'n-no,y-yes ,after successfull upload of pdf into ith_v2 then marked as y ' AFTER `pdf_ith_submission_status`;");

            DB::statement("ALTER TABLE `rvw_article_pdf` ADD `pdf_ith_version` CHAR(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'v1' COMMENT 'ithentication - v1 - version 1, v2 - version 2' AFTER `pdf_ith_submission_status`;");

            DB::statement("ALTER TABLE `tbk_article_pdf` ADD `pdf_ith_version` CHAR(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'v1' COMMENT 'ithentication - v1 - version 1, v2 - version 2' AFTER `pdf_ith_submission_status`;");

        }
        catch(\Exception $e)
        {
            print_r($e);exit;
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
