<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        try{
            DB::statement ("DROP TABLE IF EXISTS `rvw_research_integrity_reports`");
            DB::statement("CREATE TABLE `rvw_research_integrity_reports` (
                        `rri_id` bigint UNSIGNED NOT NULL PRIMARY KEY AUTO_INCREMENT,
                        `rri_art_id` bigint UNSIGNED NOT NULL COMMENT 'art id',
                        `rri_report` text COMMENT 'report link',
                        `rri_status` CHAR(1) NULL COMMENT 'n - not generated ; y - generated',
                        `rri_new_report` CHAR(1) NULL COMMENT 'n - old report; y - new report',
                        `rri_posted_by` bigint UNSIGNED NOT NULL,
                        `rri_posted_date` datetime NOT NULL,
                        `rri_proxy_id` bigint DEFAULT NULL,
                        `rri_operation` char(1) NOT NULL DEFAULT 'u' COMMENT 'u-update,i-insert'
                        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;");
            
            DB::statement("CREATE TABLE `tbk_research_integrity_reports` (
                `rri_id` bigint UNSIGNED NOT NULL,
                `rri_art_id` bigint UNSIGNED NOT NULL COMMENT 'art id',
                `rri_report` text COMMENT 'report link',
                `rri_status` CHAR(1) NULL COMMENT 'n - not generated ; y - generated',
                `rri_new_report` CHAR(1) NULL COMMENT 'n - old report; y - new report',
                `rri_posted_by` bigint UNSIGNED NOT NULL,
                `rri_posted_date` datetime NOT NULL,
                `rri_proxy_id` bigint DEFAULT NULL,
                `rri_operation` char(1) NOT NULL DEFAULT 'u' COMMENT 'u-update,i-insert',
                `tbk_id` int UNSIGNED NOT NULL PRIMARY KEY AUTO_INCREMENT
                ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;");

            DB::unprepared("drop trigger if exists trg_research_integrity_reports_after_insert; CREATE TRIGGER trg_research_integrity_reports_after_insert  AFTER INSERT ON rvw_research_integrity_reports FOR EACH ROW INSERT INTO tbk_research_integrity_reports SELECT *,NULL tbk_id FROM rvw_research_integrity_reports WHERE rri_id= NEW.rri_id;");    
            
            DB::unprepared("drop trigger if exists trg_research_integrity_reports_after_update; CREATE TRIGGER trg_research_integrity_reports_after_update  AFTER UPDATE ON rvw_research_integrity_reports FOR EACH ROW INSERT INTO tbk_research_integrity_reports SELECT *,NULL tbk_id FROM rvw_research_integrity_reports WHERE rri_id= OLD.rri_id;");
        }
        catch (\Exception $e) {
            DB::rollback();
        }

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('rvw_research_integrity_reports');
        Schema::dropIfExists('tbk_research_integrity_reports');
    }
};
