<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        //DB::statement("ALTER TABLE `rvw_ftp_master` ADD `ftpm_ext_location` CHAR(1) NULL DEFAULT 'n' COMMENT 'y=yes,n=no' AFTER `ftpm_location`");
        Schema::table('rvw_ftp_master', function (Blueprint $table) {
            $table->char('ftpm_ext_location', 1)
                  ->nullable()
                  ->default('n')
                  ->comment('y=yes,n=no')
                  ->after('ftpm_location');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //DB::statement("ALTER TABLE `rvw_ftp_master` DROP `ftpm_ext_location`");
        Schema::table('rvw_ftp_master', function (Blueprint $table) {
            $table->dropColumn('ftpm_ext_location');
        });
    }
};
