<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasColumn('rvw_article_type_advance_options', 'atotp_author_viewable_content')) {

           Schema::table('rvw_article_type_advance_options', function (Blueprint $table) {
            $table->char('atotp_author_viewable_content', 1)
                  ->default('n')
                  ->comment('y-show author viewable content only after decision n-normal')
                  ->after('atotp_rvriauto_submissions');
            });
       }

       if (!Schema::hasColumn('tbk_article_type_advance_options', 'atotp_author_viewable_content')) {

        Schema::table('tbk_article_type_advance_options', function (Blueprint $table) {
         $table->char('atotp_author_viewable_content', 1)
               ->default('n')
               ->comment('y-show author viewable content only after decision n-normal')
               ->after('atotp_rvriauto_submissions');
         });
    }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        
        Schema::table('rvw_article_type_advance_options', function (Blueprint $table) {
            $table->dropColumn('atotp_author_viewable_content');
        });

        Schema::table('tbk_article_type_advance_options', function (Blueprint $table) {
            $table->dropColumn('atotp_author_viewable_content');
        });
    }
};
