<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        // Drop the existing trigger if it exists
        DB::unprepared('DROP TRIGGER IF EXISTS `trg_client_functionalities_after_update`;');

        // Create the new trigger
        DB::unprepared("
            CREATE TRIGGER `trg_client_functionalities_after_update` AFTER UPDATE ON `rvw_client_functionalities`
 FOR EACH ROW INSERT INTO tbk_client_functionalities SELECT *,NULL tbk_id FROM rvw_client_functionalities WHERE cfty_id= NEW.cfty_id;
        ");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
