<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        //
        $table_exist = Schema::connection('mysql_common')->hasTable('rvw_client_module_status');
        if (!$table_exist) {
            Schema::connection('mysql_common')->create('rvw_client_module_status', function (Blueprint $table) {
                $table->id('cms_id');
                $table->bigInteger('cms_cls_id', false, true)->nullable();
                $table->bigInteger('cms_cm_id', false, true)->nullable();
                $table->bigInteger('cms_clu_id', false, true)->nullable();
                $table->char('cms_status', 1);
                $table->unsignedBigInteger('cms_posted_by');
                $table->dateTime('cms_posted_date');
                $table->unsignedBigInteger('cms_proxy_id')->nullable();
                $table->char('cms_operation', 1);
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
