<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
       
        if (!Schema::connection('mysql_common')->hasColumn('rvw_faqs', 'faq_platform_type')) {
            Schema::connection('mysql_common')->table('rvw_faqs', function (Blueprint $table) {
                $table->char('faq_platform_type', 10)->nullable()->after('faq_client');
            });
        }
       
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (Schema::connection('mysql_common')->hasColumn('rvw_faqs', 'faq_platform_type')) {
            Schema::connection('mysql_common')->table('rvw_faqs', function (Blueprint $table) {
                $table->dropColumn('faq_platform_type');
            });
         }
    }
};
