<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        //
        $table_exist = Schema::connection('mysql_common')->hasTable('rvw_rvt_setting');
        if (!$table_exist) {
            Schema::connection('mysql_common')->create('rvw_rvt_setting', function (Blueprint $table) {
                $table->id('rvt_id');
                $table->string('rvt_title', 50);
                $table->mediumText('rvt_description')->nullable();
                $table->string('rvt_image',250);
                $table->unsignedBigInteger('rvt_posted_by');
                $table->dateTime('rvt_posted_date');
                $table->unsignedBigInteger('rvt_proxy_id')->nullable();
                $table->char('rvt_operation', 1);
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
