<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        try{
            DB::statement("ALTER TABLE `rvw_flags` ADD `flag_prefix` CHAR(3) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT 'fa' COMMENT 'fa, far, fas' AFTER `flag_color`;");
            DB::statement("ALTER TABLE `tbk_flags` ADD `flag_prefix` CHAR(3) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT 'fa' COMMENT 'fa, far, fas' AFTER `flag_color`;");
            DB::statement("UPDATE
                            `rvw_flags`
                            SET
                                `flag_prefix` = CASE 
                                    WHEN `rvw_flags`.`flag_icon` = 'themeisle' THEN 'fab' 
                                    WHEN `rvw_flags`.`flag_icon` = 'wikipedia-w' THEN 'fab' 
                                    WHEN `rvw_flags`.`flag_icon` = 'gitlab' THEN 'fab' 
                                    WHEN `rvw_flags`.`flag_icon` = 'dropbox' THEN 'fab' 
                                    WHEN `rvw_flags`.`flag_icon` = 'foursquare' THEN 'fab'
                                ELSE `rvw_flags`.`flag_prefix`
                            END");
            }
        catch (\Exception $e) {
            DB::rollback();
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        DB::statement("ALTER TABLE `rvw_flags` DROP `flag_prefix`;");
        DB::statement("ALTER TABLE `tbk_flags` DROP `flag_prefix`;");
    }
};
