<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        try
        {
            DB::statement(
                "CREATE TABLE IF NOT EXISTS `rvw_workflow_assignment_reference` (
                    `war_id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
                    `war_Jwf_id` bigint UNSIGNED NOT NULL,
                    `war_wa_id` bigint UNSIGNED NOT NULL,
                    `war_posted_by` bigint UNSIGNED NOT NULL,
                    `war_posted_date` datetime NOT NULL,
                    `war_proxy_id` bigint UNSIGNED NOT NULL,
                    `war_operation` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'u' COMMENT 'u-update,i-insert',
                    PRIMARY KEY (`war_id`)
                  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;"
            );
            DB::statement(
                "CREATE TABLE IF NOT EXISTS `tbk_workflow_assignment_reference` (
                    `war_id` bigint UNSIGNED NOT NULL,
                    `war_Jwf_id` bigint UNSIGNED NOT NULL,
                    `war_wa_id` bigint UNSIGNED NOT NULL,
                    `war_posted_by` bigint UNSIGNED NOT NULL,
                    `war_posted_date` datetime NOT NULL,
                    `war_proxy_id` bigint UNSIGNED NOT NULL,
                    `war_operation` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'u' COMMENT 'u-update,i-insert',
                    `tbk_id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
                    PRIMARY KEY (`tbk_id`)
                  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;"
            );
            DB::unprepared("drop trigger if exists trg_workflow_assignment_reference_after_insert; CREATE TRIGGER trg_workflow_assignment_reference_after_insert  AFTER INSERT ON rvw_workflow_assignment_reference FOR EACH ROW INSERT INTO tbk_workflow_assignment_reference SELECT *,NULL tbk_id FROM rvw_workflow_assignment_reference WHERE war_id= NEW.war_id;");    
            
            DB::unprepared("drop trigger if exists trg_workflow_assignment_reference_after_update; CREATE TRIGGER trg_workflow_assignment_reference_after_update  AFTER UPDATE ON rvw_workflow_assignment_reference FOR EACH ROW INSERT INTO tbk_workflow_assignment_reference SELECT *,NULL tbk_id FROM rvw_workflow_assignment_reference WHERE war_id= OLD.war_id;");

        }
        catch(\Exception $e)
        {
            
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::drop("rvw_workflow_assignment_reference");
        Schema::drop("tbk_workflow_assignment_reference");
    }
};
