<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        try
        {
            DB::statement(
                "CREATE TABLE IF NOT EXISTS `rvw_workflow_assignment_user_parent_flow_based` (
                    `waup_id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
                    `waup_wa_id` bigint UNSIGNED NOT NULL,
                    `waup_souce_jwf_id` bigint UNSIGNED NOT NULL,
                    `waup_flow_master_id` bigint UNSIGNED NOT NULL,
                    `waup_source_aflw_id` bigint UNSIGNED NOT NULL,
                    `waup_minimum_user` INT(11) UNSIGNED NOT NULL DEFAULT '0' ,
                    `waup_maximum_user` INT(11) UNSIGNED NOT NULL DEFAULT '0' ,
                    `waup_posted_by` bigint UNSIGNED NOT NULL,
                    `waup_posted_date` datetime NOT NULL,
                    `waup_proxy_id` bigint UNSIGNED NOT NULL,
                    `waup_operation` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'u' COMMENT 'u-update,i-insert',
                    PRIMARY KEY (`waup_id`)
                  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;"
            );
            DB::statement(
                "CREATE TABLE IF NOT EXISTS `tbk_workflow_assignment_user_parent_flow_based` (
                    `waup_id` bigint UNSIGNED NOT NULL,
                    `waup_wa_id` bigint UNSIGNED NOT NULL,
                    `waup_souce_jwf_id` bigint UNSIGNED NOT NULL,
                    `waup_flow_master_id` bigint UNSIGNED NOT NULL,
                    `waup_source_aflw_id` bigint UNSIGNED NOT NULL,
                    `waup_minimum_user` INT(11) UNSIGNED NOT NULL DEFAULT '0' ,
                    `waup_maximum_user` INT(11) UNSIGNED NOT NULL DEFAULT '0' ,
                    `waup_posted_by` bigint UNSIGNED NOT NULL,
                    `waup_posted_date` datetime NOT NULL,
                    `waup_proxy_id` bigint UNSIGNED NOT NULL,
                    `waup_operation` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'u' COMMENT 'u-update,i-insert',
                    `tbk_id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
                    PRIMARY KEY (`tbk_id`)
                  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;"
            );
            DB::unprepared("drop trigger if exists trg_workflow_assignment_user_parent_flow_based_after_insert; CREATE TRIGGER trg_workflow_assignment_user_parent_flow_based_after_insert  AFTER INSERT ON rvw_workflow_assignment_user_parent_flow_based FOR EACH ROW INSERT INTO tbk_workflow_assignment_user_parent_flow_based SELECT *,NULL tbk_id FROM rvw_workflow_assignment_user_parent_flow_based WHERE waup_id= NEW.waup_id;");    
            
            DB::unprepared("drop trigger if exists trg_workflow_assignment_user_parent_flow_based_after_update; CREATE TRIGGER trg_workflow_assignment_user_parent_flow_based_after_update  AFTER UPDATE ON rvw_workflow_assignment_user_parent_flow_based FOR EACH ROW INSERT INTO tbk_workflow_assignment_user_parent_flow_based SELECT *,NULL tbk_id FROM rvw_workflow_assignment_user_parent_flow_based WHERE waup_id= OLD.waup_id;");

        }
        catch(\Exception $e)
        {
            
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::drop("rvw_workflow_assignment_user_parent_flow_based");
        Schema::drop("tbk_workflow_assignment_user_parent_flow_based");
    }
};
