<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('rvw_abstract_categories', function (Blueprint $table) {
            $table->id('absc_id');
            $table->string('absc_category', 64)->unique();
            $table->bigInteger('absc_posted_by', false, true);
            $table->timestamp('absc_posted_date');
            $table->bigInteger('absc_proxy_id');
            $table->foreign('absc_posted_by')->references('usr_id')->on('rvw_users')->onDelete('cascade')->onUpdate('cascade');
            $table->char('absc_operation', 1)->default('n');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('rvw_abstract_categories');
    }
};
