<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasColumn('rvw_journal_settings', 'jset_batch_decision'))
        {
            Schema::table('rvw_journal_settings', function (Blueprint $table) {
                $table->json('jset_batch_decision')->after('jset_blind_articles')->nullable();
            });
        }
        if (!Schema::hasColumn('tbk_journal_settings', 'jset_batch_decision'))
        {
            Schema::table('tbk_journal_settings', function (Blueprint $table) {
                $table->json('jset_batch_decision')->after('jset_blind_articles')->nullable();
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (Schema::hasColumn('rvw_journal_settings', 'jset_batch_decision'))
        {
            Schema::table('rvw_journal_settings', function (Blueprint $table) {
                $table->dropColumn('jset_batch_decision');        
            });
        }
        if (Schema::hasColumn('tbk_journal_settings', 'jset_batch_decision'))
        {
            Schema::table('tbk_journal_settings', function (Blueprint $table) {
                $table->dropColumn('jset_batch_decision');              
            });
        }
    }
};
