<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */

    /* Task #196-10096 */
    public function up(): void
    {
        if (!Schema::hasColumn('rvw_article_submission_tab_status', 'tab_status_transfer_bit'))
        {
            Schema::table('rvw_article_submission_tab_status', function (Blueprint $table) {
                $table->char('tab_status_transfer_bit',1)
                      ->after('tab_status_array')
                      ->default('n')
                      ->comment('y=yes,n=no :Transferred article tab status');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (Schema::hasColumn('rvw_article_submission_tab_status', 'tab_status_transfer_bit'))
        {
            Schema::table('rvw_article_submission_tab_status', function (Blueprint $table) {
                $table->dropColumn('tab_status_transfer_bit');
            });
        }
    }
};
