<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        $journals = DB::table('rvw_journals')->get();

        foreach ($journals as $journal) {
            $code = $journal->jnl_journal_code;
            $jnlId = (int) $journal->jnl_id;

            $table = 'article_gnf_form_data_' . $code;
            $key = 'gdata_id';

            // Drop existing triggers if any
            DB::unprepared('DROP TRIGGER IF EXISTS `trg_rvw_' . $table . '_after_insert`;');
            DB::unprepared('DROP TRIGGER IF EXISTS `trg_rvw_' . $table . '_after_update`;');
            DB::unprepared('DROP TRIGGER IF EXISTS `trg_rvw_' . $table . '_before_delete`;');

            // AFTER INSERT trigger
            $afterInsertTrigger = <<<SQL
                CREATE TRIGGER `trg_rvw_{$table}_after_insert`
                AFTER INSERT ON `rvw_{$table}`
                FOR EACH ROW
                BEGIN
                    DECLARE v_posted_by INT DEFAULT 0;
                    DECLARE v_current_time DATETIME DEFAULT NOW();

                    INSERT INTO tbk_{$table}
                    SELECT *, 'i' AS operation, v_current_time
                    FROM rvw_{$table}
                    WHERE {$key} = NEW.{$key};

                    IF NEW.gdata_flag_id IS NOT NULL THEN
                        INSERT INTO rvw_article_flag (
                            aflg_id,
                            aflg_flag_id,
                            aflg_art_id,
                            aflg_jnl_id,
                            aflg_type,
                            aflg_emt_id,
                            aflg_aflw_id,
                            aflg_posted_by,
                            aflg_posted_date,
                            aflg_merge_date,
                            aflg_proxy_id,
                            aflg_operation
                        ) VALUES (
                            NULL,
                            NEW.gdata_flag_id,
                            NEW.gdata_art_id,
                            {$jnlId},
                            'g',
                            NEW.gdata_atfemt_id,
                            NEW.gdata_artflw_id,
                            NEW.gdata_posted_by,
                            NEW.gdata_posted_date,
                            NULL,
                            NEW.gdata_proxy_id,
                            'i'
                        );
                    END IF;
                END;
                SQL;

                            // AFTER UPDATE trigger
                            $afterUpdateTrigger = <<<SQL
                CREATE TRIGGER `trg_rvw_{$table}_after_update`
                AFTER UPDATE ON `rvw_{$table}`
                FOR EACH ROW
                BEGIN
                    IF (NEW.gdata_operation != 'm') THEN

                        INSERT INTO tbk_{$table}
                        SELECT *, 'u' AS operation, NOW()
                        FROM rvw_{$table}
                        WHERE {$key} = OLD.{$key};

                        IF OLD.gdata_flag_id IS NOT NULL THEN
                            DELETE FROM rvw_article_flag
                            WHERE aflg_flag_id = OLD.gdata_flag_id
                            AND aflg_art_id = OLD.gdata_art_id
                            AND aflg_emt_id = OLD.gdata_atfemt_id
                            AND aflg_aflw_id = OLD.gdata_artflw_id
                            AND aflg_type = 'g';
                        END IF;

                        IF NEW.gdata_flag_id IS NOT NULL THEN
                            INSERT INTO rvw_article_flag (
                                aflg_id,
                                aflg_flag_id,
                                aflg_art_id,
                                aflg_jnl_id,
                                aflg_type,
                                aflg_emt_id,
                                aflg_aflw_id,
                                aflg_posted_by,
                                aflg_posted_date,
                                aflg_merge_date,
                                aflg_proxy_id,
                                aflg_operation
                            ) VALUES (
                                NULL,
                                NEW.gdata_flag_id,
                                NEW.gdata_art_id,
                                {$jnlId},
                                'g',
                                NEW.gdata_atfemt_id,
                                NEW.gdata_artflw_id,
                                NEW.gdata_posted_by,
                                NEW.gdata_posted_date,
                                NULL,
                                NEW.gdata_proxy_id,
                                'i'
                            );
                        END IF;

                    END IF;
                END;
                SQL;

                            // BEFORE DELETE trigger
                            $beforeDeleteTrigger = <<<SQL
                CREATE TRIGGER `trg_rvw_{$table}_before_delete`
                BEFORE DELETE ON `rvw_{$table}`
                FOR EACH ROW
                BEGIN
                    INSERT INTO tbk_{$table}
                    SELECT *, 'd' AS operation, NOW()
                    FROM rvw_{$table}
                    WHERE {$key} = OLD.{$key};

                    IF OLD.gdata_flag_id IS NOT NULL THEN
                        DELETE FROM rvw_article_flag
                        WHERE aflg_flag_id = OLD.gdata_flag_id
                        AND aflg_art_id = OLD.gdata_art_id
                        AND aflg_emt_id = OLD.gdata_atfemt_id
                        AND aflg_aflw_id = OLD.gdata_artflw_id
                        AND aflg_type = 'g';
                    END IF;
                END;
                SQL;

                            // Apply triggers
                            DB::unprepared($afterInsertTrigger);
                            DB::unprepared($afterUpdateTrigger);
                            DB::unprepared($beforeDeleteTrigger);
                        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        $journals = DB::table('rvw_journals')->get();

        foreach ($journals as $journal) {
            $table = 'article_gnf_form_data_' . $journal->jnl_journal_code;

            DB::unprepared('DROP TRIGGER IF EXISTS `trg_rvw_' . $table . '_after_insert`;');
            DB::unprepared('DROP TRIGGER IF EXISTS `trg_rvw_' . $table . '_after_update`;');
            DB::unprepared('DROP TRIGGER IF EXISTS `trg_rvw_' . $table . '_before_delete`;');
        }
    }
};
