<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class TbkJournalPermissionMaster extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tbk_journal_permission_master', function (Blueprint $table) {
            $table->bigInteger('jpm_id');
            $table->string('jpm_description',100)->comment('Description Master Table')->collation('utf8_unicode_ci');
            $table->bigInteger('jpm_posted_by');
            $table->dateTime('jpm_posted_date');
            $table->bigInteger('jpm_proxy_id');
            $table->char('jpm_operation',1)->collation('utf8_unicode_ci');
            $table->bigIncrements('tbk_id',20);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tbk_journal_permission_master');
    }
}
