<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class RvwFtpLocations extends Migration
{
    /**
     * Run the migrations.
     * 
     * @return void
     */
    public function up()
    {
        //
        // DB::beginTransaction();
        try {
            DB::statement("CREATE TABLE IF NOT EXISTS `rvw_ftp_master` (
                `ftpm_id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
                `ftpm_display_name` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
                `ftpm_host_name` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
                `ftpm_user_name` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
                `ftpm_password` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
                `ftpm_enable_private_key` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'n',
                `ftpm_private_key_path` varchar(85) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
                `ftpm_port` int(5) UNSIGNED NOT NULL,
                `ftpm_location` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
                `ftpm_temp_ftp_ids` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
                `ftpm_posted_by` bigint(20) UNSIGNED NOT NULL,
                `ftpm_proxy_id` bigint(20) UNSIGNED DEFAULT NULL,
                `ftpm_posted_date` datetime NOT NULL,
                `ftpm_operation` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'u' COMMENT 'u-update,i-insert',
               PRIMARY KEY (`ftpm_id`)
              ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;");

            DB::statement("ALTER TABLE `rvw_ftp_locations`
                CHANGE `ftp_location` `ftp_location` VARCHAR(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NULL;");

            DB::statement("ALTER TABLE `tbk_ftp_locations`
                CHANGE `ftp_location` `ftp_location` VARCHAR(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NULL;");

            DB::statement("ALTER TABLE `rvw_ftp_locations` 
                ADD `ftp_ftpm_id` BIGINT UNSIGNED NOT NULL COMMENT 'PK of rvw_ftp_master table' AFTER `ftp_jwf_id`;");

            DB::statement("ALTER TABLE `tbk_ftp_locations` 
                ADD `ftp_ftpm_id` BIGINT UNSIGNED NOT NULL COMMENT 'PK of rvw_ftp_master table' AFTER `ftp_jwf_id`;");

            DB::statement("ALTER TABLE `rvw_ftp_locations` 
                ADD INDEX(`ftp_ftpm_id`);");

            // DB::statement("ALTER TABLE `rvw_ftp_locations` 
            //     ADD FOREIGN KEY (`ftp_ftpm_id`) REFERENCES `rvw_ftp_master`(`ftpm_id`) ON DELETE CASCADE ON UPDATE CASCADE;");

            // DB::statement("SET GLOBAL group_concat_max_len=15000;");

            /* DB::statement(" INSERT
                INTO
                `rvw_ftp_master`(
                    `ftpm_display_name`,
                    `ftpm_host_name`,
                    `ftpm_user_name`,
                    `ftpm_password`,
                    `ftpm_enable_private_key`,
                    `ftpm_private_key_path`,
                    `ftpm_port`,
                    `ftpm_location`,
                    `ftpm_temp_ftp_ids`,
                    `ftpm_posted_by`,
                    `ftpm_proxy_id`,
                    `ftpm_posted_date`,
                    `ftpm_operation`
                )
                SELECT
                `ftp_display_name`,
                `ftp_host_name`,
                `ftp_user_name`,
                `ftp_password`,
                `ftp_enable_private_key`,
                `ftp_private_key_path`,
                `ftp_port`,
                `ftp_location`,
                GROUP_CONCAT(`ftp_id`) as ftp_temp_ftp_ids,
                `ftp_posted_by`,
                `ftp_proxy_id`,
                `ftp_posted_date`,
                `ftp_operation` 
                FROM
                `rvw_ftp_locations`
                GROUP BY
                `ftp_display_name`,
                `ftp_host_name`,
                `ftp_user_name`,
                `ftp_password`,
                `ftp_enable_private_key`,
                `ftp_private_key_path`,
                `ftp_port`,
                `ftp_location`;"); */
        } catch (\Exception $e) {
            DB::rollback();
        }
    }

    /**
     * Reverse the migrations.
     * 
     * @return void
     */
    public function down()
    {
        //DROP TABLE `rvw_ftp_locations`, `tbk_ftp_locations`, `rvw_ftp_master`;

        Schema::table('rvw_ftp_locations', function (Blueprint $table) {
            if (Schema::hasColumn('rvw_ftp_locations','ftp_ftpm_id')) {
                $table->dropColumn('ftp_ftpm_id');
            }
        });

        Schema::table('tbk_ftp_locations', function (Blueprint $table) {
            if (Schema::hasColumn('tbk_ftp_locations','ftp_ftpm_id')) {
                $table->dropColumn('ftp_ftpm_id');
            }
        });

        Schema::dropIfExists('rvw_ftp_master');
    }
};
