<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        try
        {
            DB::statement(
                "CREATE TABLE IF NOT EXISTS `rvw_workflow_assignment` (
                    `wa_id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
                    `wa_name` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
                    `wa_minimum_user` INT(11) UNSIGNED NOT NULL DEFAULT '0' ,
                    `wa_maximum_user` INT(11) UNSIGNED NOT NULL DEFAULT '0' ,
                    `wa_destination_review_stage_id` bigint UNSIGNED NOT NULL,
                    `wa_posted_by` bigint UNSIGNED NOT NULL,
                    `wa_posted_date` datetime NOT NULL,
                    `wa_proxy_id` bigint UNSIGNED NOT NULL,
                    `wa_operation` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'u' COMMENT 'u-update,i-insert',
                    PRIMARY KEY (`wa_id`)
                  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;"
            );
            DB::statement(
                "CREATE TABLE IF NOT EXISTS `tbk_workflow_assignment` (
                    `wa_id` bigint UNSIGNED NOT NULL,
                    `wa_name` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
                    `wa_minimum_user` INT(11) UNSIGNED NOT NULL DEFAULT '0' ,
                    `wa_maximum_user` INT(11) UNSIGNED NOT NULL DEFAULT '0' ,
                    `wa_destination_review_stage_id` bigint UNSIGNED NOT NULL,
                    `wa_posted_by` bigint UNSIGNED NOT NULL,
                    `wa_posted_date` datetime NOT NULL,
                    `wa_proxy_id` bigint UNSIGNED NOT NULL,
                    `wa_operation` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'u' COMMENT 'u-update,i-insert',
                    `tbk_id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
                    PRIMARY KEY (`tbk_id`)
                  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;"
            );
            DB::unprepared("drop trigger if exists trg_workflow_assignment_after_insert; CREATE TRIGGER trg_workflow_assignment_after_insert  AFTER INSERT ON rvw_workflow_assignment FOR EACH ROW INSERT INTO tbk_workflow_assignment SELECT *,NULL tbk_id FROM rvw_workflow_assignment WHERE wa_id= NEW.wa_id;");    
            
            DB::unprepared("drop trigger if exists trg_workflow_assignment_after_update; CREATE TRIGGER trg_workflow_assignment_after_update  AFTER UPDATE ON rvw_workflow_assignment FOR EACH ROW INSERT INTO tbk_workflow_assignment SELECT *,NULL tbk_id FROM rvw_workflow_assignment WHERE wa_id= OLD.wa_id;");

        }
        catch(\Exception $e)
        {
            
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::drop("rvw_workflow_assignment");
        Schema::drop("tbk_workflow_assignment");
    }
};
