<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        DB::beginTransaction();
        try
        {  
            DB::statement("ALTER TABLE `rvw_article_reviewers` ADD `sorw_state` VARCHAR(100)  CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL AFTER `sorw_ringgold_family`");
            DB::statement("ALTER TABLE `tbk_article_reviewers` ADD `sorw_state` VARCHAR(100)  CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL AFTER `sorw_ringgold_family`");
        }
        catch(\Exception $e)
        {
            DB::rollback();
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('rvw_article_reviewers', function (Blueprint $table) {
            if (Schema::hasColumn('rvw_article_reviewers','sorw_state')) {
                $table->dropColumn('sorw_state');
            }
        });

        Schema::table('tbk_article_reviewers', function (Blueprint $table) {
            if (Schema::hasColumn('tbk_article_reviewers','sorw_state')) {
                $table->dropColumn('sorw_state');
            }
        });
    }
};
