<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        try {
            DB::statement("ALTER TABLE `rvw_payment_order` ADD `pmt_ord_card_no` INT NOT NULL DEFAULT '0' AFTER `pmt_ord_payment_method`;");
            DB::statement("ALTER TABLE `tbk_payment_order` ADD `pmt_ord_card_no` INT NOT NULL DEFAULT '0' AFTER `pmt_ord_payment_method`;");
            DB::statement("ALTER TABLE rvw_journal_workflows MODIFY COLUMN jwf_payment_fees DOUBLE;");
            DB::statement("ALTER TABLE tbk_journal_workflows MODIFY COLUMN jwf_payment_fees DOUBLE;");
        } catch (\Exception $e) {
            DB::rollback();
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        DB::statement("ALTER TABLE `rvw_payment_order` DROP COLUMN `pmt_ord_card_no`;");
        DB::statement("ALTER TABLE `tbk_payment_order` DROP COLUMN `pmt_ord_card_no`;");
    }
};
