<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('rvw_article_types', function (Blueprint $table) {
            $table->string('artp_venue', 256)->after('artp_description')->nullable()->default(null);
            $table->string('artp_contact_num', 16)->after('artp_venue')->nullable()->default(null);
            $table->string('artp_website_url', 128)->after('artp_contact_num')->nullable()->default(null);
        });
        Schema::table('tbk_article_types', function (Blueprint $table) {
            $table->string('artp_venue', 256)->after('artp_description')->nullable()->default(null);
            $table->string('artp_contact_num', 16)->after('artp_venue')->nullable()->default(null);
            $table->string('artp_website_url', 128)->after('artp_contact_num')->nullable()->default(null);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('rvw_article_types', function (Blueprint $table) {
            $table->dropColumn(['artp_venue', 'artp_contact_num', 'artp_website_url']);
        });
        Schema::table('tbk_article_types', function (Blueprint $table) {
            $table->dropColumn(['artp_venue', 'artp_contact_num', 'artp_website_url']);
        });
    }
};
