<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasColumn('rvw_journal_permission', 'jp_prevent_edit'))
        {
            Schema::table('rvw_journal_permission', function (Blueprint $table) {
                $table->json('jp_prevent_edit')->after('jp_download_review')->nullable();        
            });
        }
        if (!Schema::hasColumn('tbk_journal_permission', 'jp_prevent_edit'))
        {
            Schema::table('tbk_journal_permission', function (Blueprint $table) {
                $table->json('jp_prevent_edit')->after('jp_download_review')->nullable();              
            });
        }
        if (!Schema::hasColumn('rvw_journal_settings', 'jset_prevent_edit'))
        {
            Schema::table('rvw_journal_settings', function (Blueprint $table) {
                $table->json('jset_prevent_edit')->after('jset_classification_selection_mode')->nullable();        
            });
        }
        if (!Schema::hasColumn('tbk_journal_settings', 'jset_prevent_edit'))
        {
            Schema::table('tbk_journal_settings', function (Blueprint $table) {
                $table->json('jset_prevent_edit')->after('jset_classification_selection_mode')->nullable();              
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (Schema::hasColumn('rvw_journal_permission', 'jp_prevent_edit'))
        {
            Schema::table('rvw_journal_permission', function (Blueprint $table) {
                $table->dropColumn('jp_prevent_edit');        
            });
        }
        if (Schema::hasColumn('tbk_journal_permission', 'jp_prevent_edit'))
        {
            Schema::table('tbk_journal_permission', function (Blueprint $table) {
                $table->dropColumn('jp_prevent_edit');              
            });
        }
        if (Schema::hasColumn('rvw_journal_settings', 'jset_prevent_edit'))
        {
            Schema::table('rvw_journal_settings', function (Blueprint $table) {
                $table->dropColumn('jset_prevent_edit');        
            });
        }
        if (Schema::hasColumn('tbk_journal_settings', 'jset_prevent_edit'))
        {
            Schema::table('tbk_journal_settings', function (Blueprint $table) {
                $table->dropColumn('jset_prevent_edit');              
            });
        }
    }
};
