<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {;
       
        Schema::dropIfExists('tbk_user_emails');

        Schema::create('tbk_user_emails', function (Blueprint $table) {
            $table->unsignedBigInteger('uml_id');
            $table->unsignedBigInteger('uml_user_id');
            $table->string('uml_email', 100)->nullable();
            $table->char('uml_cc_email', 1)->default('n')->comment('if cc email then y otherwise n');
            $table->string('uml_url', 500)->nullable()->default(null);
            $table->char('uml_status', 1)->default('n')->comment('c-confirmed,n-not confirmed');
            $table->bigInteger('uml_posted_by')->nullable()->default(null); 
            $table->dateTime('uml_posted_date')->nullable()->default(null);
            $table->bigInteger('uml_proxy_id')->nullable()->default(null);
            $table->char('uml_operation', 1)->default('u')->comment('u-update,i-insert');
            $table->index('uml_user_id');
            $table->bigIncrements('tbk_id');
            $table->primary('tbk_id');
        });
        DB::unprepared('
        CREATE TRIGGER trg_user_emails_after_insert AFTER INSERT ON `rvw_user_emails` FOR EACH ROW
        BEGIN
        INSERT INTO tbk_user_emails SELECT *,NULL tbk_id FROM rvw_user_emails WHERE uml_id= NEW.uml_id;
        END
        ');

        DB::unprepared("
        CREATE TRIGGER trg_user_emails_after_update AFTER UPDATE ON `rvw_user_emails` FOR EACH ROW
        BEGIN
        IF (NEW.uml_operation != 'm') THEN INSERT INTO tbk_user_emails SELECT *,NULL tbk_id FROM rvw_user_emails WHERE uml_id= OLD.uml_id;
        END IF;
        END
        ");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        DB::unprepared('DROP TRIGGER IF EXISTS trg_user_emails_after_insert');
        DB::unprepared('DROP TRIGGER IF EXISTS trg_user_emails_after_update');
        Schema::dropIfExists('tbk_user_emails');
    }
};