<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        try {
            // add new feild from article flag table aflg_emt_id
            DB::statement("ALTER TABLE `rvw_article_flag` ADD `aflg_type`  CHAR(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n' COMMENT 'n-normal,g-added from custom form'  AFTER `aflg_jnl_id`;");
            DB::statement("ALTER TABLE `tbk_article_flag` ADD `aflg_type`  CHAR(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n' COMMENT 'n-normal,g-added from custom form' AFTER `aflg_jnl_id`;");
            DB::statement("ALTER TABLE `rvw_article_flag` ADD `aflg_emt_id` INT NULL DEFAULT NULL AFTER `aflg_type`");
            DB::statement("ALTER TABLE tbk_article_flag ADD aflg_emt_id INT NULL DEFAULT NULL AFTER aflg_type;");
            // Static table names to be updated directly
            $staticTables = [
                'rvw_article_gnf_form_data',
                'tbk_article_gnf_form_data',
                'rvw_article_gnf_form_data_temp',
                'tbk_article_gnf_form_data_temp'
            ];

            // Adding the gdata_flag column to static tables
            foreach ($staticTables as $table) {
                if (Schema::hasTable($table)) {
                    if (!Schema::hasColumn($table, 'gdata_flag')) {
                        Schema::table($table, function (Blueprint $table) {
                            $table->integer('gdata_flag')->nullable()->default(null)
                                  ->comment('Element flag id')
                                  ->after('gdata_dynamic_status');
                        });
                    }
                }
            }

            // Get all jnl_journal_code values from the rvw_journals table
            $journals = DB::table('rvw_journals')->select('jnl_journal_code')->get();

            // Process each journal code to create dynamic table names: rvw_ and tbk_
            $tableNames = $journals->flatMap(function ($journal) {
                return [
                    'rvw_article_gnf_form_data_' . $journal->jnl_journal_code,
                    'tbk_article_gnf_form_data_' . $journal->jnl_journal_code
                ];
            });

            // Adding the gdata_flag column to dynamic tables based on journal codes
            foreach ($tableNames as $tableName) {
                if (Schema::hasTable($tableName)) {
                    if (!Schema::hasColumn($tableName, 'gdata_flag')) {
                        Schema::table($tableName, function (Blueprint $table) {
                            $table->integer('gdata_flag')->nullable()->default(null)
                                  ->comment('Element flag id')
                                  ->after('gdata_dynamic_status');
                        });
                    }
                }
            }
        } catch (\Exception $e) {
            Log::error('Migration error: ' . $e->getMessage());
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        try {
            // Static table names to drop the gdata_flag column
            $staticTables = [
                'rvw_article_gnf_form_data',
                'tbk_article_gnf_form_data',
                'rvw_article_gnf_form_data_temp',
                'tbk_article_gnf_form_data_temp'
            ];

            // Dropping the gdata_flag column from static tables
            foreach ($staticTables as $table) {
                if (Schema::hasTable($table) && Schema::hasColumn($table, 'gdata_flag')) {
                    Schema::table($table, function (Blueprint $table) {
                        $table->dropColumn('gdata_flag');
                    });
                }
            }

            // Get all jnl_journal_code values from the rvw_journals table
            $journals = DB::table('rvw_journals')->select('jnl_journal_code')->get();

            // Process each journal code to create dynamic table names: rvw_ and tbk_
            $tableNames = $journals->flatMap(function ($journal) {
                return [
                    'rvw_article_gnf_form_data_' . $journal->jnl_journal_code,
                    'tbk_article_gnf_form_data_' . $journal->jnl_journal_code
                ];
            });

            // Dropping the gdata_flag column from dynamic tables
            foreach ($tableNames as $tableName) {
                if (Schema::hasTable($tableName) && Schema::hasColumn($tableName, 'gdata_flag')) {
                    Schema::table($tableName, function (Blueprint $table) {
                        $table->dropColumn('gdata_flag');
                    });
                }
            }
        } catch (\Exception $e) {
            Log::error('Migration rollback error: ' . $e->getMessage());
        }
    }
};
