<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        $table_exist = Schema::connection('mysql_common')->hasTable('rvw_release_version');
        if (!$table_exist) {
            Schema::connection('mysql_common')->create('rvw_release_version', function (Blueprint $table) {
                $table->id('rel_id');
                $table->string('rel_title', 1000);
                $table->string('rel_number', 250);
                $table->dateTime('rel_date');
                $table->char('rel_status', 1);
                $table->unsignedBigInteger('rel_posted_by');
                $table->dateTime('rel_posted_date');
                $table->unsignedBigInteger('rel_proxy_id')->nullable();
                $table->char('rel_operation', 1);
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('rvw_release_version');
    }
};
