<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasColumn('rvw_article_notification_emails', 'ane_for')) {
            DB::statement("ALTER TABLE `rvw_article_notification_emails` ADD `ane_for`  CHAR(1) NULL DEFAULT NULL COMMENT 'to identify that notification mail save from which case. a -> alternate reviewer invitation, n -> normal invitation ' AFTER `ane_status`");
        }
        if (!Schema::hasColumn('tbk_article_notification_emails', 'ane_for')) {
            DB::statement("ALTER TABLE `tbk_article_notification_emails` ADD `ane_for`  CHAR(1) NULL DEFAULT NULL COMMENT 'to identify that notification mail save from which case. a -> alternate reviewer invitation, n -> normal invitation ' AFTER `ane_status`");
        }
        if (!Schema::hasColumn('rvw_email_attachments', 'emat_for')) {
            DB::statement("ALTER TABLE `rvw_email_attachments` ADD `emat_for`  CHAR(1) NULL DEFAULT NULL COMMENT 'to identify that attachment save from which case. a -> alternate reviewer invitation, n -> normal invitation ' AFTER `emat_action_status`");
        }
        if (!Schema::hasColumn('tbk_email_attachments', 'emat_for')) {
            DB::statement("ALTER TABLE `tbk_email_attachments` ADD `emat_for`  CHAR(1) NULL DEFAULT NULL COMMENT 'to identify that attachment save from which case. a -> alternate reviewer invitation, n -> normal invitation ' AFTER `emat_action_status`");
        }

        // to add comment to the fields in 'article_flow' table (aflw_source_assignment_id , aflw_assignment_type_id)
        if (Schema::hasColumn('rvw_article_flow', 'aflw_source_assignment_id')) {
            DB::statement("ALTER TABLE `rvw_article_flow` CHANGE `aflw_source_assignment_id` `aflw_source_assignment_id` bigint UNSIGNED COMMENT 'primary id of workflow_assignment_reference table (to identify the stage where the reviewer shortlisted)'");
        }
        if (Schema::hasColumn('tbk_article_flow', 'aflw_source_assignment_id')) {
            DB::statement("ALTER TABLE `tbk_article_flow` CHANGE `aflw_source_assignment_id` `aflw_source_assignment_id` bigint UNSIGNED COMMENT 'primary id of workflow_assignment_reference table (to identify the stage where the reviewer shortlisted)'");
        }
        if (Schema::hasColumn('rvw_article_flow', 'aflw_assignment_type_id')) {
            DB::statement("ALTER TABLE `rvw_article_flow` CHANGE `aflw_assignment_type_id` `aflw_assignment_type_id` bigint UNSIGNED COMMENT 'primary id of workflow_assignment table (to identify which assignment pool was used to shortlist the reviewer)'");
        }
        if (Schema::hasColumn('tbk_article_flow', 'aflw_assignment_type_id')) {
            DB::statement("ALTER TABLE `tbk_article_flow` CHANGE `aflw_assignment_type_id` `aflw_assignment_type_id` bigint UNSIGNED COMMENT 'primary id of workflow_assignment table (to identify which assignment pool was used to shortlist the reviewer)'");
        }

        // to add comment to the fields in 'workflow_assignment_reference' table ( war_Jwf_id , war_destination_review_stage_id , war_flow_master_id , war_wa_id )
        if (Schema::hasColumn('rvw_workflow_assignment_reference', 'war_Jwf_id')) {
            DB::statement("ALTER TABLE `rvw_workflow_assignment_reference` CHANGE `war_Jwf_id` `war_Jwf_id` JSON NOT NULL COMMENT 'primary id of workflow_assignment_reference table (to identify source stages where reviewers can be shortlisted through pre-review stages)'");
        }
        if (Schema::hasColumn('tbk_workflow_assignment_reference', 'war_Jwf_id')) {
            DB::statement("ALTER TABLE `tbk_workflow_assignment_reference` CHANGE `war_Jwf_id` `war_Jwf_id` JSON NOT NULL COMMENT 'primary id of workflow_assignment_reference table (to identify source stages where reviewers can be shortlisted through pre-review stages)'");
        }
        if (Schema::hasColumn('rvw_workflow_assignment_reference', 'war_destination_review_stage_id')) {
            DB::statement("ALTER TABLE `rvw_workflow_assignment_reference` CHANGE `war_destination_review_stage_id` `war_destination_review_stage_id` JSON NULL COMMENT 'primary id of journal_workflows table (to identify which destination stages the workflow assignment has added for shortlist reviewers)'");
        }
        if (Schema::hasColumn('tbk_workflow_assignment_reference', 'war_destination_review_stage_id')) {
            DB::statement("ALTER TABLE `tbk_workflow_assignment_reference` CHANGE `war_destination_review_stage_id` `war_destination_review_stage_id` JSON NULL COMMENT 'primary id of journal_workflows table (to identify which destination stages the workflow assignment has added for shortlist reviewers )'");
        }
        if (Schema::hasColumn('rvw_workflow_assignment_reference', 'war_flow_master_id')) {
            DB::statement("ALTER TABLE `rvw_workflow_assignment_reference` CHANGE `war_flow_master_id` `war_flow_master_id` bigint UNSIGNED NOT NULL COMMENT 'primary id of flow_master table (to identify the flow master details)'");
        }
        if (Schema::hasColumn('tbk_workflow_assignment_reference', 'war_flow_master_id')) {
            DB::statement("ALTER TABLE `tbk_workflow_assignment_reference` CHANGE `war_flow_master_id` `war_flow_master_id` bigint UNSIGNED NOT NULL COMMENT 'primary id of flow_master table (to identify the flow master details)'");
        }
        if (Schema::hasColumn('rvw_workflow_assignment_reference', 'war_wa_id')) {
            DB::statement("ALTER TABLE `rvw_workflow_assignment_reference` CHANGE `war_wa_id` `war_wa_id` bigint UNSIGNED NOT NULL COMMENT 'primary id of workflow_assignment table (to identify which assignment pool was used to shortlist the reviewer)'");
        }
        if (Schema::hasColumn('tbk_workflow_assignment_reference', 'war_wa_id')) {
            DB::statement("ALTER TABLE `tbk_workflow_assignment_reference` CHANGE `war_wa_id` `war_wa_id` bigint UNSIGNED NOT NULL COMMENT 'primary id of workflow_assignment table (to identify which assignment pool was used to shortlist the reviewer)'");
        }

        // to add comment to the fields in 'workflow_assignment_user_parent_flow_based' table ( waup_wa_id , waup_souce_jwf_id , waup_destination_jwf_id , waup_flow_master_id , waup_source_aflw_id)
        if (Schema::hasColumn('rvw_workflow_assignment_user_parent_flow_based', 'waup_wa_id')) {
            DB::statement("ALTER TABLE `rvw_workflow_assignment_user_parent_flow_based` CHANGE `waup_wa_id` `waup_wa_id` bigint UNSIGNED NOT NULL COMMENT 'primary id of workflow_assignment table (to identify which assignment pool was used to shortlist the reviewer)'");
        }
        if (Schema::hasColumn('tbk_workflow_assignment_user_parent_flow_based', 'waup_wa_id')) {
            DB::statement("ALTER TABLE `tbk_workflow_assignment_user_parent_flow_based` CHANGE `waup_wa_id` `waup_wa_id` bigint UNSIGNED NOT NULL COMMENT 'primary id of workflow_assignment table (to identify which assignment pool was used to shortlist the reviewer)'");
        }
        if (Schema::hasColumn('rvw_workflow_assignment_user_parent_flow_based', 'waup_souce_jwf_id')) {
            DB::statement("ALTER TABLE `rvw_workflow_assignment_user_parent_flow_based` CHANGE `waup_souce_jwf_id` `waup_souce_jwf_id` bigint UNSIGNED NOT NULL COMMENT 'To identify from which pre-review stage the min-max reviewer count was modified'");
        }
        if (Schema::hasColumn('tbk_workflow_assignment_user_parent_flow_based', 'waup_souce_jwf_id')) {
            DB::statement("ALTER TABLE `tbk_workflow_assignment_user_parent_flow_based` CHANGE `waup_souce_jwf_id` `waup_souce_jwf_id` bigint UNSIGNED NOT NULL COMMENT 'to identify from which pre-review stage the min-max reviewer count was modified'");
        }
        if (Schema::hasColumn('rvw_workflow_assignment_user_parent_flow_based', 'waup_destination_jwf_id')) {
            DB::statement("ALTER TABLE `rvw_workflow_assignment_user_parent_flow_based` CHANGE `waup_destination_jwf_id` `waup_destination_jwf_id` bigint UNSIGNED  NULL COMMENT 'to identify the destination stage of the workflow assignment'");
        }
        if (Schema::hasColumn('tbk_workflow_assignment_user_parent_flow_based', 'waup_destination_jwf_id')) {
            DB::statement("ALTER TABLE `tbk_workflow_assignment_user_parent_flow_based` CHANGE `waup_destination_jwf_id` `waup_destination_jwf_id` bigint UNSIGNED  NULL COMMENT 'to identify the destination stage of the workflow assignment'");
        }
        if (Schema::hasColumn('rvw_workflow_assignment_user_parent_flow_based', 'waup_flow_master_id')) {
            DB::statement("ALTER TABLE `rvw_workflow_assignment_user_parent_flow_based` CHANGE `waup_flow_master_id` `waup_flow_master_id` bigint UNSIGNED NOT NULL COMMENT 'primary id of flow_master table (to identify the flow master details)'");
        }
        if (Schema::hasColumn('tbk_workflow_assignment_user_parent_flow_based', 'waup_flow_master_id')) {
            DB::statement("ALTER TABLE `tbk_workflow_assignment_user_parent_flow_based` CHANGE `waup_flow_master_id` `waup_flow_master_id` bigint UNSIGNED NOT NULL COMMENT 'primary id of flow_master table (to identify the flow master details)'");
        }
        if (Schema::hasColumn('rvw_workflow_assignment_user_parent_flow_based', 'waup_source_aflw_id')) {
            DB::statement("ALTER TABLE `rvw_workflow_assignment_user_parent_flow_based` CHANGE `waup_source_aflw_id` `waup_source_aflw_id` bigint UNSIGNED NOT NULL COMMENT 'to identify from which article flow the min-max reviewer count was modified'");
        }
        if (Schema::hasColumn('tbk_workflow_assignment_user_parent_flow_based', 'waup_source_aflw_id')) {
            DB::statement("ALTER TABLE `tbk_workflow_assignment_user_parent_flow_based` CHANGE `waup_source_aflw_id` `waup_source_aflw_id` bigint UNSIGNED NOT NULL COMMENT 'to identify from which article flow the min-max reviewer count was modified'");
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (Schema::hasColumn('rvw_article_notification_emails', 'ane_for')) {
            DB::statement("ALTER TABLE `rvw_article_notification_emails` DROP `ane_for`");
        }
        if (Schema::hasColumn('tbk_article_notification_emails', 'ane_for')) {
            DB::statement("ALTER TABLE `tbk_article_notification_emails` DROP `ane_for`");
        }
        if (Schema::hasColumn('rvw_email_attachments', 'emat_for')) {
            DB::statement("ALTER TABLE `rvw_email_attachments` DROP `emat_for`");
        }
        if (Schema::hasColumn('tbk_email_attachments', 'emat_for')) {
            DB::statement("ALTER TABLE `tbk_email_attachments` DROP `emat_for`");
        }
    }
};
